/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.stream.InputWireRecord;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.utilint.VLSN;
import java.nio.ByteBuffer;
import java.util.UUID;

public class Protocol
extends BinaryProtocol {
    private static int VERSION = 4;
    private static int MIN_VERSION = 3;
    private static int HB_TXN_END_VLSN_VERSION = 4;
    private final RepNode repNode;
    private final int writeLogVersion;
    public static final BinaryProtocol.MessageOp REPLICA_PROTOCOL_VERSION = new BinaryProtocol.MessageOp(1, ReplicaProtocolVersion.class);
    public static final BinaryProtocol.MessageOp FEEDER_PROTOCOL_VERSION = new BinaryProtocol.MessageOp(2, FeederProtocolVersion.class);
    public static final BinaryProtocol.MessageOp DUP_NODE_REJECT = new BinaryProtocol.MessageOp(3, DuplicateNodeReject.class);
    public static final BinaryProtocol.MessageOp REPLICA_JE_VERSIONS = new BinaryProtocol.MessageOp(4, ReplicaJEVersions.class);
    public static final BinaryProtocol.MessageOp FEEDER_JE_VERSIONS = new BinaryProtocol.MessageOp(5, FeederJEVersions.class);
    public static final BinaryProtocol.MessageOp JE_VERSIONS_REJECT = new BinaryProtocol.MessageOp(6, JEVersionsReject.class);
    public static final BinaryProtocol.MessageOp MEMBERSHIP_INFO = new BinaryProtocol.MessageOp(7, NodeGroupInfo.class);
    public static final BinaryProtocol.MessageOp MEMBERSHIP_INFO_OK = new BinaryProtocol.MessageOp(8, NodeGroupInfoOK.class);
    public static final BinaryProtocol.MessageOp MEMBERSHIP_INFO_REJECT = new BinaryProtocol.MessageOp(9, NodeGroupInfoReject.class);
    public static final BinaryProtocol.MessageOp SNTP_REQUEST = new BinaryProtocol.MessageOp(10, SNTPRequest.class);
    public static final BinaryProtocol.MessageOp SNTP_RESPONSE = new BinaryProtocol.MessageOp(11, SNTPResponse.class);
    public static final BinaryProtocol.MessageOp ENTRY = new BinaryProtocol.MessageOp(101, Entry.class);
    public static final BinaryProtocol.MessageOp START_STREAM = new BinaryProtocol.MessageOp(102, StartStream.class);
    public static final BinaryProtocol.MessageOp HEARTBEAT = new BinaryProtocol.MessageOp(103, Heartbeat.class);
    public static final BinaryProtocol.MessageOp HEARTBEAT_RESPONSE = new BinaryProtocol.MessageOp(104, HeartbeatResponse.class);
    public static final BinaryProtocol.MessageOp COMMIT = new BinaryProtocol.MessageOp(105, Commit.class);
    public static final BinaryProtocol.MessageOp ACK = new BinaryProtocol.MessageOp(106, Ack.class);
    public static final BinaryProtocol.MessageOp ENTRY_REQUEST = new BinaryProtocol.MessageOp(107, EntryRequest.class);
    public static final BinaryProtocol.MessageOp ENTRY_NOTFOUND = new BinaryProtocol.MessageOp(108, EntryNotFound.class);
    public static final BinaryProtocol.MessageOp ALT_MATCHPOINT = new BinaryProtocol.MessageOp(109, AlternateMatchpoint.class);
    public static final BinaryProtocol.MessageOp RESTORE_REQUEST = new BinaryProtocol.MessageOp(110, RestoreRequest.class);
    public static final BinaryProtocol.MessageOp RESTORE_RESPONSE = new BinaryProtocol.MessageOp(111, RestoreResponse.class);
    public static final BinaryProtocol.MessageOp SHUTDOWN_REQUEST = new BinaryProtocol.MessageOp(112, ShutdownRequest.class);
    public static final BinaryProtocol.MessageOp SHUTDOWN_RESPONSE = new BinaryProtocol.MessageOp(113, ShutdownResponse.class);

    private Protocol(RepNode repNode, int protocolVersion, int writeLogVersion) {
        super(repNode != null ? repNode.getNameIdPair() : NameIdPair.NULL, VERSION, protocolVersion, repNode != null ? repNode.getRepImpl() : null);
        this.repNode = repNode;
        this.configuredVersion = protocolVersion;
        this.writeLogVersion = writeLogVersion;
        this.initializeMessageOps(new BinaryProtocol.MessageOp[]{REPLICA_PROTOCOL_VERSION, FEEDER_PROTOCOL_VERSION, DUP_NODE_REJECT, REPLICA_JE_VERSIONS, FEEDER_JE_VERSIONS, JE_VERSIONS_REJECT, MEMBERSHIP_INFO, MEMBERSHIP_INFO_OK, MEMBERSHIP_INFO_REJECT, SNTP_REQUEST, SNTP_RESPONSE, ENTRY, START_STREAM, HEARTBEAT, HEARTBEAT_RESPONSE, COMMIT, ACK, ENTRY_REQUEST, ENTRY_NOTFOUND, RESTORE_REQUEST, RESTORE_RESPONSE, ALT_MATCHPOINT, SHUTDOWN_REQUEST, SHUTDOWN_RESPONSE});
    }

    public static Protocol get(RepNode repNode, int protocolVersion) {
        return Protocol.get(repNode, protocolVersion, 8);
    }

    public static Protocol get(RepNode repNode, int protocolVersion, int writeLogVersion) {
        assert (repNode != null);
        if (!Protocol.isSupportedVersion(protocolVersion)) {
            return null;
        }
        return new Protocol(repNode, protocolVersion, writeLogVersion);
    }

    static Protocol getProtocol(RepNode repNode) {
        assert (repNode != null);
        return new Protocol(repNode, VERSION, 8);
    }

    private static boolean isSupportedVersion(int protocolVersion) {
        if (protocolVersion == Integer.MIN_VALUE) {
            return false;
        }
        return MIN_VERSION <= protocolVersion && protocolVersion <= VERSION;
    }

    public static int getDefaultVersion() {
        return VERSION;
    }

    public static void setDefaultVersion(int testVersion) {
        VERSION = testVersion;
    }

    void writeOutputWireRecord(OutputWireRecord record, ByteBuffer messageBuffer) {
        boolean changedFormat = record.writeToWire(messageBuffer, this.writeLogVersion);
        if (changedFormat) {
            this.nEntriesWrittenOldVersion.increment();
        }
    }

    private static boolean getByteNeedsAck(byte needsAckByte) {
        switch (needsAckByte) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw EnvironmentFailureException.unexpectedState("Invalid bool ordinal: " + needsAckByte);
    }

    private static Durability.SyncPolicy getByteReplicaSyncPolicy(byte syncPolicyByte) {
        for (Durability.SyncPolicy p : Durability.SyncPolicy.values()) {
            if (p.ordinal() != syncPolicyByte) continue;
            return p;
        }
        throw EnvironmentFailureException.unexpectedState("Invalid sync policy ordinal: " + syncPolicyByte);
    }

    public class RestoreResponse
    extends BinaryProtocol.SimpleMessage {
        private final VLSN cbvlsn;
        private final RepNodeImpl[] logProviders;

        public RestoreResponse(VLSN cbvlsn, RepNodeImpl[] logProviders) {
            super(Protocol.this);
            this.cbvlsn = cbvlsn;
            this.logProviders = logProviders;
        }

        public RestoreResponse(ByteBuffer buffer) {
            super(Protocol.this);
            long vlsnSequence = LogUtils.readLong(buffer);
            this.cbvlsn = new VLSN(vlsnSequence);
            this.logProviders = this.getRepNodeImplArray(buffer);
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(this.cbvlsn.getSequence(), this.logProviders);
        }

        public BinaryProtocol.MessageOp getOp() {
            return RESTORE_RESPONSE;
        }

        RepNodeImpl[] getLogProviders() {
            return this.logProviders;
        }

        VLSN getCBVLSN() {
            return this.cbvlsn;
        }
    }

    public class RestoreRequest
    extends VLSNMessage {
        RestoreRequest(VLSN failedMatchpoint) {
            super(failedMatchpoint);
        }

        public RestoreRequest(ByteBuffer buffer) {
            super(buffer);
        }

        public BinaryProtocol.MessageOp getOp() {
            return RESTORE_REQUEST;
        }
    }

    public class AlternateMatchpoint
    extends BinaryProtocol.Message {
        private final InputWireRecord alternateInput;
        private OutputWireRecord alternateOutput;

        AlternateMatchpoint(OutputWireRecord alternate) {
            super(Protocol.this);
            this.alternateOutput = null;
            this.alternateInput = null;
            this.alternateOutput = alternate;
        }

        public BinaryProtocol.MessageOp getOp() {
            return ALT_MATCHPOINT;
        }

        public ByteBuffer wireFormat() {
            int bodySize = this.alternateOutput.getWireSize(Protocol.this.writeLogVersion);
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            Protocol.this.writeOutputWireRecord(this.alternateOutput, messageBuffer);
            messageBuffer.flip();
            return messageBuffer;
        }

        public AlternateMatchpoint(ByteBuffer buffer) throws DatabaseException {
            super(Protocol.this);
            this.alternateOutput = null;
            this.alternateInput = new InputWireRecord(Protocol.this.repNode.getRepImpl(), buffer);
        }

        public InputWireRecord getAlternateWireRecord() {
            return this.alternateInput;
        }

        public boolean match(BinaryProtocol.Message other) {
            if (this.alternateOutput == null) {
                this.alternateOutput = new OutputWireRecord((EnvironmentImpl)Protocol.this.repNode.getRepImpl(), this.alternateInput);
            }
            return super.match(other);
        }
    }

    public class EntryNotFound
    extends BinaryProtocol.Message {
        public EntryNotFound() {
            super(Protocol.this);
        }

        public EntryNotFound(ByteBuffer buffer) {
            super(Protocol.this);
        }

        public BinaryProtocol.MessageOp getOp() {
            return ENTRY_NOTFOUND;
        }
    }

    public class EntryRequest
    extends VLSNMessage {
        EntryRequest(VLSN matchpoint) {
            super(matchpoint);
        }

        public EntryRequest(ByteBuffer buffer) {
            super(buffer);
        }

        public BinaryProtocol.MessageOp getOp() {
            return ENTRY_REQUEST;
        }
    }

    public class Ack
    extends BinaryProtocol.Message {
        private final long txnId;

        public Ack(long txnId) {
            super(Protocol.this);
            this.txnId = txnId;
        }

        public BinaryProtocol.MessageOp getOp() {
            return ACK;
        }

        public ByteBuffer wireFormat() {
            int bodySize = 8;
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            LogUtils.writeLong(messageBuffer, this.txnId);
            messageBuffer.flip();
            return messageBuffer;
        }

        public Ack(ByteBuffer buffer) {
            super(Protocol.this);
            this.txnId = LogUtils.readLong(buffer);
        }

        public long getTxnId() {
            return this.txnId;
        }

        public String toString() {
            return super.toString() + " txn " + this.txnId;
        }
    }

    public class Commit
    extends Entry {
        private final boolean needsAck;
        private final Durability.SyncPolicy replicaSyncPolicy;

        public Commit(boolean needsAck, Durability.SyncPolicy replicaSyncPolicy, OutputWireRecord wireRecord) {
            super(wireRecord);
            this.needsAck = needsAck;
            this.replicaSyncPolicy = replicaSyncPolicy;
        }

        public BinaryProtocol.MessageOp getOp() {
            return COMMIT;
        }

        public ByteBuffer wireFormat() {
            int bodySize = super.getWireSize() + 1 + 1;
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            messageBuffer.put((byte)(this.needsAck ? 1 : 0));
            messageBuffer.put((byte)this.replicaSyncPolicy.ordinal());
            Protocol.this.writeOutputWireRecord(this.outputWireRecord, messageBuffer);
            messageBuffer.flip();
            return messageBuffer;
        }

        public Commit(ByteBuffer buffer) throws DatabaseException {
            this(Protocol.getByteNeedsAck(buffer.get()), Protocol.getByteReplicaSyncPolicy(buffer.get()), buffer);
        }

        private Commit(boolean needsAck, Durability.SyncPolicy replicaSyncPolicy, ByteBuffer buffer) throws DatabaseException {
            super(buffer);
            this.needsAck = needsAck;
            this.replicaSyncPolicy = replicaSyncPolicy;
        }

        public boolean getNeedsAck() {
            return this.needsAck;
        }

        public Durability.SyncPolicy getReplicaSyncPolicy() {
            return this.replicaSyncPolicy;
        }
    }

    public class ShutdownResponse
    extends BinaryProtocol.Message {
        public ShutdownResponse() {
            super(Protocol.this);
        }

        public BinaryProtocol.MessageOp getOp() {
            return SHUTDOWN_RESPONSE;
        }

        public ShutdownResponse(ByteBuffer buffer) {
            super(Protocol.this);
        }
    }

    public class ShutdownRequest
    extends BinaryProtocol.SimpleMessage {
        private final long shutdownTimeMs;

        public ShutdownRequest(long shutdownTimeMs) {
            super(Protocol.this);
            this.shutdownTimeMs = shutdownTimeMs;
        }

        public BinaryProtocol.MessageOp getOp() {
            return SHUTDOWN_REQUEST;
        }

        public ShutdownRequest(ByteBuffer buffer) {
            super(Protocol.this);
            this.shutdownTimeMs = LogUtils.readLong(buffer);
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(this.shutdownTimeMs);
        }

        public long getShutdownTimeMs() {
            return this.shutdownTimeMs;
        }
    }

    public class HeartbeatResponse
    extends BinaryProtocol.Message {
        private final VLSN syncupVLSN;
        private final VLSN txnEndVLSN;

        public HeartbeatResponse(VLSN syncupVLSN, VLSN ackedVLSN) {
            super(Protocol.this);
            this.syncupVLSN = syncupVLSN;
            this.txnEndVLSN = ackedVLSN;
        }

        public HeartbeatResponse(ByteBuffer buffer) {
            super(Protocol.this);
            this.syncupVLSN = new VLSN(LogUtils.readLong(buffer));
            this.txnEndVLSN = Protocol.this.getVersion() >= HB_TXN_END_VLSN_VERSION ? new VLSN(LogUtils.readLong(buffer)) : null;
        }

        public BinaryProtocol.MessageOp getOp() {
            return HEARTBEAT_RESPONSE;
        }

        public ByteBuffer wireFormat() {
            boolean includeTxnEndVLSN = Protocol.this.getVersion() >= HB_TXN_END_VLSN_VERSION;
            int bodySize = includeTxnEndVLSN ? 16 : 8;
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            LogUtils.writeLong(messageBuffer, this.syncupVLSN.getSequence());
            if (includeTxnEndVLSN) {
                LogUtils.writeLong(messageBuffer, this.txnEndVLSN.getSequence());
            }
            messageBuffer.flip();
            return messageBuffer;
        }

        public VLSN getSyncupVLSN() {
            return this.syncupVLSN;
        }

        public VLSN getTxnEndVLSN() {
            return this.txnEndVLSN;
        }

        public String toString() {
            return super.toString() + " syncupVLSN=" + this.syncupVLSN;
        }
    }

    public class Heartbeat
    extends BinaryProtocol.Message {
        private final long masterNow;
        private final long currentTxnEndVLSN;

        public Heartbeat(long masterNow, long currentTxnEndVLSN) {
            super(Protocol.this);
            this.masterNow = masterNow;
            this.currentTxnEndVLSN = currentTxnEndVLSN;
        }

        public BinaryProtocol.MessageOp getOp() {
            return HEARTBEAT;
        }

        public ByteBuffer wireFormat() {
            int bodySize = 16;
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            LogUtils.writeLong(messageBuffer, this.masterNow);
            LogUtils.writeLong(messageBuffer, this.currentTxnEndVLSN);
            messageBuffer.flip();
            return messageBuffer;
        }

        public Heartbeat(ByteBuffer buffer) {
            super(Protocol.this);
            this.masterNow = LogUtils.readLong(buffer);
            this.currentTxnEndVLSN = LogUtils.readLong(buffer);
        }

        public long getMasterNow() {
            return this.masterNow;
        }

        public long getCurrentTxnEndVLSN() {
            return this.currentTxnEndVLSN;
        }

        public String toString() {
            return super.toString() + " masterNow=" + this.masterNow + " currentCommit=" + this.currentTxnEndVLSN;
        }
    }

    public class StartStream
    extends VLSNMessage {
        StartStream(VLSN startVLSN) {
            super(startVLSN);
        }

        public StartStream(ByteBuffer buffer) {
            super(buffer);
        }

        public BinaryProtocol.MessageOp getOp() {
            return START_STREAM;
        }
    }

    public class Entry
    extends BinaryProtocol.Message {
        protected final InputWireRecord inputWireRecord;
        protected OutputWireRecord outputWireRecord;

        public Entry(OutputWireRecord outputWireRecord) {
            super(Protocol.this);
            this.inputWireRecord = null;
            this.outputWireRecord = outputWireRecord;
        }

        public BinaryProtocol.MessageOp getOp() {
            return ENTRY;
        }

        public ByteBuffer wireFormat() {
            int bodySize = this.getWireSize();
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            Protocol.this.writeOutputWireRecord(this.outputWireRecord, messageBuffer);
            messageBuffer.flip();
            return messageBuffer;
        }

        protected int getWireSize() {
            return this.outputWireRecord.getWireSize(Protocol.this.writeLogVersion);
        }

        public Entry(ByteBuffer buffer) throws DatabaseException {
            super(Protocol.this);
            this.inputWireRecord = new InputWireRecord(Protocol.this.repNode.getRepImpl(), buffer);
        }

        public InputWireRecord getWireRecord() {
            return this.inputWireRecord;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            if (this.inputWireRecord != null) {
                sb.append(" ");
                sb.append(this.inputWireRecord);
            }
            if (this.outputWireRecord != null) {
                sb.append(" ");
                sb.append(this.outputWireRecord);
            }
            return sb.toString();
        }

        public boolean match(BinaryProtocol.Message other) {
            if (this.outputWireRecord == null) {
                this.outputWireRecord = new OutputWireRecord((EnvironmentImpl)Protocol.this.repNode.getRepImpl(), this.inputWireRecord);
            }
            return super.match(other);
        }

        public boolean isTxnEnd() {
            byte entryType = this.getWireRecord().getEntryType();
            return LogEntryType.LOG_TXN_COMMIT.equalsType(entryType) || LogEntryType.LOG_TXN_ABORT.equalsType(entryType);
        }
    }

    abstract class VLSNMessage
    extends BinaryProtocol.Message {
        protected final VLSN vlsn;

        VLSNMessage(VLSN vlsn) {
            super(Protocol.this);
            this.vlsn = vlsn;
        }

        public VLSNMessage(ByteBuffer buffer) {
            super(Protocol.this);
            long vlsnSequence = LogUtils.readLong(buffer);
            this.vlsn = new VLSN(vlsnSequence);
        }

        public ByteBuffer wireFormat() {
            int bodySize = 8;
            ByteBuffer messageBuffer = this.allocateInitializedBuffer(bodySize);
            LogUtils.writeLong(messageBuffer, this.vlsn.getSequence());
            messageBuffer.flip();
            return messageBuffer;
        }

        VLSN getVLSN() {
            return this.vlsn;
        }

        public String toString() {
            return super.toString() + " " + this.vlsn;
        }
    }

    public class NodeGroupInfoReject
    extends BinaryProtocol.RejectMessage {
        NodeGroupInfoReject(String errorMessage) {
            super((BinaryProtocol)Protocol.this, errorMessage);
        }

        public BinaryProtocol.MessageOp getOp() {
            return MEMBERSHIP_INFO_REJECT;
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(this.errorMessage);
        }

        public NodeGroupInfoReject(ByteBuffer buffer) {
            super((BinaryProtocol)Protocol.this, buffer);
        }
    }

    public class NodeGroupInfoOK
    extends HandshakeMessage {
        private final UUID uuid;
        private final NameIdPair nameIdPair;

        public NodeGroupInfoOK(UUID uuid, NameIdPair nameIdPair) {
            this.uuid = uuid;
            this.nameIdPair = nameIdPair;
        }

        public NodeGroupInfoOK(ByteBuffer buffer) {
            this.uuid = new UUID(LogUtils.readLong(buffer), LogUtils.readLong(buffer));
            this.nameIdPair = this.getNameIdPair(buffer);
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(this.uuid.getMostSignificantBits(), this.uuid.getLeastSignificantBits(), this.nameIdPair);
        }

        public BinaryProtocol.MessageOp getOp() {
            return MEMBERSHIP_INFO_OK;
        }

        public NameIdPair getNameIdPair() {
            return this.nameIdPair;
        }

        public UUID getUUID() {
            return this.uuid;
        }
    }

    public class NodeGroupInfo
    extends HandshakeMessage {
        private final String groupName;
        private final UUID uuid;
        private final NameIdPair nameIdPair;
        private final String hostName;
        private final int port;
        private final NodeType nodeType;
        private final boolean designatedPrimary;

        NodeGroupInfo(String groupName, UUID uuid, NameIdPair nameIdPair, String hostName, int port, NodeType nodeType, boolean designatedPrimary) {
            this.groupName = groupName;
            this.uuid = uuid;
            this.nameIdPair = nameIdPair;
            this.hostName = hostName;
            this.port = port;
            this.nodeType = nodeType;
            this.designatedPrimary = designatedPrimary;
        }

        public BinaryProtocol.MessageOp getOp() {
            return MEMBERSHIP_INFO;
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(new Object[]{this.groupName, this.uuid.getMostSignificantBits(), this.uuid.getLeastSignificantBits(), this.nameIdPair, this.hostName, this.port, this.nodeType, this.designatedPrimary});
        }

        public NodeGroupInfo(ByteBuffer buffer) {
            this.groupName = Protocol.this.getString(buffer);
            this.uuid = new UUID(LogUtils.readLong(buffer), LogUtils.readLong(buffer));
            this.nameIdPair = this.getNameIdPair(buffer);
            this.hostName = Protocol.this.getString(buffer);
            this.port = LogUtils.readInt(buffer);
            this.nodeType = this.getEnum(NodeType.class, buffer);
            this.designatedPrimary = this.getBoolean(buffer);
        }

        public String getGroupName() {
            return this.groupName;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public String getNodeName() {
            return this.nameIdPair.getName();
        }

        public int getNodeId() {
            return this.nameIdPair.getId();
        }

        public String getHostName() {
            return this.hostName;
        }

        public NameIdPair getNameIdPair() {
            return this.nameIdPair;
        }

        public int port() {
            return this.port;
        }

        public NodeType getNodeType() {
            return this.nodeType;
        }

        public boolean isDesignatedPrimary() {
            return this.designatedPrimary;
        }
    }

    public class JEVersionsReject
    extends BinaryProtocol.RejectMessage {
        public JEVersionsReject(String errorMessage) {
            super((BinaryProtocol)Protocol.this, errorMessage);
        }

        public JEVersionsReject(ByteBuffer buffer) {
            super((BinaryProtocol)Protocol.this, buffer);
        }

        public BinaryProtocol.MessageOp getOp() {
            return JE_VERSIONS_REJECT;
        }
    }

    public class FeederJEVersions
    extends JEVersions {
        FeederJEVersions(JEVersion version, int logVersion) {
            super(version, logVersion);
        }

        public FeederJEVersions(ByteBuffer buffer) {
            super(buffer);
        }

        public BinaryProtocol.MessageOp getOp() {
            return FEEDER_JE_VERSIONS;
        }
    }

    public class ReplicaJEVersions
    extends JEVersions {
        ReplicaJEVersions(JEVersion version, int logVersion) {
            super(version, logVersion);
        }

        public ReplicaJEVersions(ByteBuffer buffer) {
            super(buffer);
        }

        public BinaryProtocol.MessageOp getOp() {
            return REPLICA_JE_VERSIONS;
        }
    }

    abstract class JEVersions
    extends HandshakeMessage {
        private final JEVersion version;
        private final int logVersion;

        public JEVersions(JEVersion version, int logVersion) {
            this.version = version;
            this.logVersion = logVersion;
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(this.version.getVersionString(), this.logVersion);
        }

        public JEVersions(ByteBuffer buffer) {
            this.version = new JEVersion(Protocol.this.getString(buffer));
            this.logVersion = LogUtils.readInt(buffer);
        }

        public JEVersion getVersion() {
            return this.version;
        }

        public byte getLogVersion() {
            return (byte)this.logVersion;
        }
    }

    public class SNTPResponse
    extends HandshakeMessage {
        private final long originateTimestamp;
        private final long receiveTimestamp;
        private long transmitTimestamp;
        private long destinationTimestamp;

        public SNTPResponse(SNTPRequest request) {
            this.transmitTimestamp = -1L;
            this.destinationTimestamp = -1L;
            this.originateTimestamp = request.originateTimestamp;
            this.receiveTimestamp = request.receiveTimestamp;
        }

        public ByteBuffer wireFormat() {
            this.transmitTimestamp = Protocol.this.repNode.getClock().currentTimeMillis();
            return this.wireFormat(this.originateTimestamp, this.receiveTimestamp, this.transmitTimestamp);
        }

        public SNTPResponse(ByteBuffer buffer) {
            this.transmitTimestamp = -1L;
            this.destinationTimestamp = -1L;
            this.originateTimestamp = LogUtils.readLong(buffer);
            this.receiveTimestamp = LogUtils.readLong(buffer);
            this.transmitTimestamp = LogUtils.readLong(buffer);
            this.destinationTimestamp = Protocol.this.repNode.getClock().currentTimeMillis();
        }

        public BinaryProtocol.MessageOp getOp() {
            return SNTP_RESPONSE;
        }

        public long getOriginateTimestamp() {
            return this.originateTimestamp;
        }

        public long getReceiveTimestamp() {
            return this.receiveTimestamp;
        }

        public long getTransmitTimestamp() {
            return this.transmitTimestamp;
        }

        public long getDestinationTimestamp() {
            return this.destinationTimestamp;
        }

        public long getDelay() {
            assert (this.destinationTimestamp != -1L);
            return this.destinationTimestamp - this.originateTimestamp - (this.transmitTimestamp - this.receiveTimestamp);
        }

        public long getDelta() {
            assert (this.destinationTimestamp != -1L);
            return (this.receiveTimestamp - this.originateTimestamp + (this.transmitTimestamp - this.destinationTimestamp)) / 2L;
        }
    }

    public class SNTPRequest
    extends HandshakeMessage {
        private final long originateTimestamp;
        private long receiveTimestamp;
        private boolean isLast;

        public SNTPRequest(boolean isLast) {
            this.receiveTimestamp = -1L;
            this.isLast = true;
            this.isLast = isLast;
            this.originateTimestamp = Protocol.this.repNode.getClock().currentTimeMillis();
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(this.originateTimestamp, this.isLast);
        }

        public SNTPRequest(ByteBuffer buffer) {
            this.receiveTimestamp = -1L;
            this.isLast = true;
            this.originateTimestamp = LogUtils.readLong(buffer);
            this.isLast = this.getBoolean(buffer);
            this.receiveTimestamp = Protocol.this.repNode.getClock().currentTimeMillis();
        }

        public BinaryProtocol.MessageOp getOp() {
            return SNTP_REQUEST;
        }

        public long getOriginateTimestamp() {
            return this.originateTimestamp;
        }

        public long getReceiveTimestamp() {
            return this.receiveTimestamp;
        }

        public boolean isLast() {
            return this.isLast;
        }
    }

    public class DuplicateNodeReject
    extends BinaryProtocol.RejectMessage {
        DuplicateNodeReject(String errorMessage) {
            super((BinaryProtocol)Protocol.this, errorMessage);
        }

        public DuplicateNodeReject(ByteBuffer buffer) {
            super((BinaryProtocol)Protocol.this, buffer);
        }

        public BinaryProtocol.MessageOp getOp() {
            return DUP_NODE_REJECT;
        }
    }

    public class FeederProtocolVersion
    extends ProtocolVersion {
        public FeederProtocolVersion(int proposedVersion) {
            super(proposedVersion);
        }

        public FeederProtocolVersion(ByteBuffer buffer) {
            super(buffer);
        }

        public BinaryProtocol.MessageOp getOp() {
            return FEEDER_PROTOCOL_VERSION;
        }
    }

    public class ReplicaProtocolVersion
    extends ProtocolVersion {
        public ReplicaProtocolVersion() {
            super(VERSION);
        }

        public ReplicaProtocolVersion(ByteBuffer buffer) {
            super(buffer);
        }

        public BinaryProtocol.MessageOp getOp() {
            return REPLICA_PROTOCOL_VERSION;
        }
    }

    abstract class ProtocolVersion
    extends HandshakeMessage {
        private final int version;
        private final NameIdPair nameIdPair;

        public ProtocolVersion(int version) {
            this.version = version;
            this.nameIdPair = Protocol.this.nameIdPair;
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(this.version, this.nameIdPair);
        }

        public ProtocolVersion(ByteBuffer buffer) {
            this.version = LogUtils.readInt(buffer);
            this.nameIdPair = this.getNameIdPair(buffer);
        }

        int getVersion() {
            return this.version;
        }

        NameIdPair getNameIdPair() {
            return this.nameIdPair;
        }
    }

    abstract class HandshakeMessage
    extends BinaryProtocol.SimpleMessage {
        HandshakeMessage() {
            super(Protocol.this);
        }
    }
}

