/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import java.math.BigDecimal;
import java.util.Arrays;

public class MathUtil {
    public static final double MAX_PROB_BELOW_ONE = 0.9999999999999999;
    public static final LogMath LOG_2_MATH = new LogMath(2.0);
    public static final LogMath NATURAL_LOG_MATH = new LogMath(Math.exp(1.0)){

        @Override
        public double getLogValue(double nonLogValue) {
            return Math.log(nonLogValue);
        }
    };
    public static final LogMath LOG_10_MATH = new LogMath(10.0){

        @Override
        public double getLogValue(double nonLogValue) {
            return Math.log10(nonLogValue);
        }
    };

    public static double mean(double[] in, int start, int stop) {
        double total = 0.0;
        for (int i = start; i < stop; ++i) {
            total += in[i];
        }
        return total / (double)(stop - start);
    }

    public static double stddev(double[] in, int start, int length) {
        return MathUtil.stddev(in, start, length, MathUtil.mean(in, start, length));
    }

    public static double stddev(double[] in, int start, int stop, double mean) {
        double total = 0.0;
        for (int i = start; i < stop; ++i) {
            total += in[i] * in[i];
        }
        return Math.sqrt(total / (double)(stop - start) - mean * mean);
    }

    public static int compare(int v1, int v2) {
        return v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
    }

    public static double median(double ... in) {
        if (in.length == 0) {
            throw new IllegalArgumentException("Attempting to find the median of an empty array");
        }
        double[] data = Arrays.copyOf(in, in.length);
        Arrays.sort(data);
        int middle = data.length / 2;
        return data.length % 2 == 1 ? data[middle] : (data[middle - 1] + data[middle]) / 2.0;
    }

    public static Double percentageOrNull(Long numerator, Long denominator) {
        if (numerator != null && denominator != null && denominator != 0L) {
            return numerator.doubleValue() / denominator.doubleValue();
        }
        return null;
    }

    public static double round(double num, int precision) {
        BigDecimal bd = new BigDecimal(num);
        bd = bd.setScale(precision, 4);
        return bd.doubleValue();
    }

    public static double max(double[] nums) {
        return nums[MathUtil.indexOfMax(nums)];
    }

    public static int indexOfMax(double[] nums) {
        double max = nums[0];
        int index = 0;
        for (int i = 1; i < nums.length; ++i) {
            if (!(nums[i] > max)) continue;
            max = nums[i];
            index = i;
        }
        return index;
    }

    public static double min(double[] nums) {
        double min = nums[0];
        for (int i = 1; i < nums.length; ++i) {
            if (!(nums[i] < min)) continue;
            min = nums[i];
        }
        return min;
    }

    public static double[] seq(double from, double to, double by) {
        if (from < to && by <= 0.0) {
            return new double[0];
        }
        if (from > to && by >= 0.0) {
            return new double[0];
        }
        int values = 1 + (int)Math.floor((to - from) / by);
        double[] results = new double[values];
        BigDecimal value = new BigDecimal(from);
        BigDecimal increment = new BigDecimal(by);
        for (int i = 0; i < values; ++i) {
            results[i] = value.doubleValue();
            value = value.add(increment);
        }
        return results;
    }

    public static double[] promote(int[] is) {
        double[] ds = new double[is.length];
        for (int i = 0; i < is.length; ++i) {
            ds[i] = is[i];
        }
        return ds;
    }

    public static double[] logLikelihoodsToProbs(double[] likelihoods) {
        double maxLikelihood = MathUtil.max(likelihoods);
        double bump = 300.0 - maxLikelihood;
        double[] tmp = new double[likelihoods.length];
        double total = 0.0;
        for (int i = 0; i < likelihoods.length; ++i) {
            tmp[i] = Math.pow(10.0, likelihoods[i] + bump);
            total += tmp[i];
        }
        double maxP = 0.9999999999999999;
        double minP = (double)1.110223E-16f / (double)(tmp.length - 1);
        for (int i = 0; i < likelihoods.length; ++i) {
            int n = i;
            tmp[n] = tmp[n] / total;
            if (tmp[i] > 0.9999999999999999) {
                tmp[i] = 0.9999999999999999;
                continue;
            }
            if (!(tmp[i] < minP)) continue;
            tmp[i] = minP;
        }
        return tmp;
    }

    public static double[] divide(double[] numerators, double[] denominators) {
        if (numerators.length != denominators.length) {
            throw new IllegalArgumentException("Arrays must be of same length.");
        }
        int len = numerators.length;
        double[] result = new double[len];
        for (int i = 0; i < len; ++i) {
            result[i] = numerators[i] / denominators[i];
        }
        return result;
    }

    public static double[] multiply(double[] lhs, double[] rhs) {
        if (lhs.length != rhs.length) {
            throw new IllegalArgumentException("Arrays must be of same length.");
        }
        int len = lhs.length;
        double[] result = new double[len];
        for (int i = 0; i < len; ++i) {
            result[i] = lhs[i] * rhs[i];
        }
        return result;
    }

    public static double sum(double[] arr) {
        double result = 0.0;
        for (double next : arr) {
            result += next;
        }
        return result;
    }

    public static long sum(long[] arr, int start, int stop) {
        long result = 0L;
        for (int i = start; i < stop; ++i) {
            result += arr[i];
        }
        return result;
    }

    public static class LogMath {
        private final double base;

        private LogMath(double base) {
            this.base = base;
        }

        public double getNonLogValue(double logValue) {
            return Math.pow(this.base, logValue);
        }

        public double getLogValue(double nonLogValue) {
            return Math.log(nonLogValue) / Math.log(this.base);
        }

        public double mean(double ... logValues) {
            return this.sum(logValues) - this.getLogValue(logValues.length);
        }

        public double sum(double ... logValues) {
            double scalingFactor = MathUtil.max(logValues);
            double simpleAdditionResult = 0.0;
            for (double v : logValues) {
                simpleAdditionResult += this.getNonLogValue(v - scalingFactor);
            }
            return this.getLogValue(simpleAdditionResult) + scalingFactor;
        }

        public double product(double ... logValues) {
            return MathUtil.sum(logValues);
        }
    }
}

