/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;
import picard.sam.AbstractAlignmentMerger;

public class RevertOriginalBaseQualitiesAndAddMateCigar
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Reverts the original base qualities and adds the mate cigar tag to read-group BAMs.";
    @Option(shortName="I", doc="The input SAM/BAM file to revert the state of.")
    public File INPUT;
    @Option(shortName="O", doc="The output SAM/BAM file to create.")
    public File OUTPUT;
    @Option(shortName="SO", doc="The sort order to create the reverted output file with.By default, the sort order will be the same as the input.", optional=true)
    public SAMFileHeader.SortOrder SORT_ORDER = null;
    @Option(shortName="OQ", doc="True to restore original qualities from the OQ field to the QUAL field if available.")
    public boolean RESTORE_ORIGINAL_QUALITIES = true;
    @Option(doc="The maximum number of records to examine to determine if we can exit early and not output, given that there are a no original base qualities (if we are to restore) and mate cigars exist. Set to 0 to never skip the file.")
    public int MAX_RECORDS_TO_EXAMINE = 10000;
    private static final Log log = Log.getInstance(RevertOriginalBaseQualitiesAndAddMateCigar.class);

    public RevertOriginalBaseQualitiesAndAddMateCigar() {
        this.CREATE_INDEX = true;
        this.CREATE_MD5_FILE = true;
    }

    public static void main(String[] args) {
        new RevertOriginalBaseQualitiesAndAddMateCigar().instanceMainWithExit(args);
    }

    @Override
    public int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        boolean foundPairedMappedReads = false;
        CanSkipSamFile skipSamFile = RevertOriginalBaseQualitiesAndAddMateCigar.canSkipSAMFile(this.INPUT, this.MAX_RECORDS_TO_EXAMINE, this.RESTORE_ORIGINAL_QUALITIES);
        log.info(new Object[]{skipSamFile.getMessage(this.MAX_RECORDS_TO_EXAMINE)});
        if (skipSamFile.canSkip()) {
            return 0;
        }
        SAMFileReader in = new SAMFileReader(this.INPUT, true);
        SAMFileHeader inHeader = in.getFileHeader();
        SAMFileHeader outHeader = inHeader.clone();
        if (null == this.SORT_ORDER) {
            this.SORT_ORDER = inHeader.getSortOrder();
        }
        outHeader.setSortOrder(this.SORT_ORDER);
        SAMFileWriterFactory.setDefaultCreateIndexWhileWriting((boolean)this.CREATE_INDEX);
        SAMFileWriterFactory.setDefaultCreateMd5File((boolean)this.CREATE_MD5_FILE);
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(outHeader, false, this.OUTPUT);
        SortingCollection sorter = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(outHeader), (Comparator)new SAMRecordQueryNameComparator(), (int)this.MAX_RECORDS_IN_RAM);
        ProgressLogger revertingProgress = new ProgressLogger(log, 1000000, " reverted OQs");
        int numOriginalQualitiesRestored = 0;
        for (SAMRecord record : in) {
            AbstractAlignmentMerger.createNewCigarsIfMapsOffEndOfReference(record);
            if (this.RESTORE_ORIGINAL_QUALITIES && null != record.getOriginalBaseQualities()) {
                record.setBaseQualities(record.getOriginalBaseQualities());
                record.setOriginalBaseQualities(null);
                ++numOriginalQualitiesRestored;
            }
            if (!foundPairedMappedReads && record.getReadPairedFlag() && !record.getReadUnmappedFlag()) {
                foundPairedMappedReads = true;
            }
            revertingProgress.record(record);
            sorter.add((Object)record);
        }
        CloserUtil.close((Object)in);
        log.info(new Object[]{"Reverted the original base qualities for " + numOriginalQualitiesRestored + " records"});
        PeekableIterator sorterIterator = new PeekableIterator((Iterator)sorter.iterator());
        ProgressLogger sorterProgress = new ProgressLogger(log, 1000000, " mate cigars added");
        int numMateCigarsAdded = 0;
        while (sorterIterator.hasNext()) {
            LinkedList<SAMRecord> records = new LinkedList<SAMRecord>();
            SAMRecord firstRecord = null;
            SAMRecord secondRecord = null;
            SAMRecord first = (SAMRecord)sorterIterator.peek();
            while (sorterIterator.hasNext() && ((SAMRecord)sorterIterator.peek()).getReadName().equals(first.getReadName())) {
                SAMRecord record = (SAMRecord)sorterIterator.next();
                if (record.getReadPairedFlag() && !record.isSecondaryOrSupplementary()) {
                    if (record.getFirstOfPairFlag()) {
                        if (null != firstRecord) {
                            throw new PicardException("Found two records that are paired, not supplementary, and first of the pair");
                        }
                        firstRecord = record;
                    } else if (record.getSecondOfPairFlag()) {
                        if (null != secondRecord) {
                            throw new PicardException("Found two records that are paired, not supplementary, and second of the pair");
                        }
                        secondRecord = record;
                    }
                }
                records.add(record);
            }
            if (null != firstRecord && null != secondRecord) {
                SamPairUtil.setMateInfo(firstRecord, secondRecord, (SAMFileHeader)outHeader, (boolean)true);
                numMateCigarsAdded += 2;
            }
            for (SAMRecord record : records) {
                sorterProgress.record(record);
                out.addAlignment(record);
            }
        }
        sorterIterator.close();
        CloserUtil.close((Object)out);
        log.info(new Object[]{"Updated " + numMateCigarsAdded + " records with mate cigar"});
        if (!foundPairedMappedReads) {
            log.info(new Object[]{"Did not find any paired mapped reads."});
        }
        return 0;
    }

    public static CanSkipSamFile canSkipSAMFile(File inputFile, int maxRecordsToExamine, boolean revertOriginalBaseQualities) {
        SAMFileReader in = new SAMFileReader(inputFile, true);
        SAMRecordIterator iterator = in.iterator();
        CanSkipSamFile returnType = CanSkipSamFile.FOUND_NO_EVIDENCE;
        for (int numRecordsExamined = 0; iterator.hasNext() && numRecordsExamined < maxRecordsToExamine; ++numRecordsExamined) {
            SAMRecord record = (SAMRecord)iterator.next();
            if (revertOriginalBaseQualities && null != record.getOriginalBaseQualities()) {
                returnType = CanSkipSamFile.CANNOT_SKIP_FOUND_OQ;
                break;
            }
            if (!record.getReadPairedFlag() || record.getMateUnmappedFlag()) continue;
            if (null == SAMUtils.getMateCigar((SAMRecord)record)) {
                returnType = CanSkipSamFile.CANNOT_SKIP_FOUND_NO_MC;
                break;
            }
            returnType = CanSkipSamFile.CAN_SKIP;
            break;
        }
        if (!iterator.hasNext() && CanSkipSamFile.FOUND_NO_EVIDENCE == returnType) {
            returnType = CanSkipSamFile.CAN_SKIP;
        }
        in.close();
        return returnType;
    }

    public static enum CanSkipSamFile {
        CAN_SKIP("Can skip the BAM file", true),
        CANNOT_SKIP_FOUND_OQ("Cannot skip the BAM as we found a record with an OQ", false),
        CANNOT_SKIP_FOUND_NO_MC("Cannot skip the BAM as we found a mate with no mate cigar tag", false),
        FOUND_NO_EVIDENCE("Found no evidence of OQ or mate with no mate cigar in the first %d records.  Will continue...", false);

        private String format;
        private boolean skip;

        private CanSkipSamFile(String format, boolean skip) {
            this.format = format;
            this.skip = skip;
        }

        public String getMessage(int maxRecordsToExamine) {
            return String.format(this.format, maxRecordsToExamine);
        }

        public boolean canSkip() {
            return this.skip;
        }
    }
}

