/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import net.sf.samtools.Defaults;
import net.sf.samtools.seekablestream.SeekableBufferedStream;
import net.sf.samtools.seekablestream.SeekableFileStream;
import net.sf.samtools.seekablestream.SeekableStream;
import net.sf.samtools.util.RuntimeIOException;

public class IOUtil {
    @Deprecated
    public static final int STANDARD_BUFFER_SIZE = Defaults.NON_ZERO_BUFFER_SIZE;
    public static final long ONE_GB = 0x40000000L;
    public static final long TWO_GBS = 0x80000000L;
    public static final long FIVE_GBS = 0x140000000L;

    public static BufferedInputStream toBufferedStream(InputStream stream) {
        if (stream instanceof BufferedInputStream) {
            return (BufferedInputStream)stream;
        }
        return new BufferedInputStream(stream, Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public static void transferByStream(InputStream in, OutputStream out, long bytes) {
        byte[] buffer = new byte[Defaults.NON_ZERO_BUFFER_SIZE];
        try {
            int read;
            for (long remaining = bytes; remaining > 0L; remaining -= (long)read) {
                read = in.read(buffer, 0, (int)Math.min((long)buffer.length, remaining));
                out.write(buffer, 0, read);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }

    public static OutputStream maybeBufferOutputStream(OutputStream os) {
        return IOUtil.maybeBufferOutputStream(os, Defaults.BUFFER_SIZE);
    }

    public static OutputStream maybeBufferOutputStream(OutputStream os, int bufferSize) {
        if (bufferSize > 0) {
            return new BufferedOutputStream(os, bufferSize);
        }
        return os;
    }

    public static SeekableStream maybeBufferedSeekableStream(SeekableStream stream, int bufferSize) {
        return bufferSize > 0 ? new SeekableBufferedStream(stream, bufferSize) : stream;
    }

    public static SeekableStream maybeBufferedSeekableStream(SeekableStream stream) {
        return IOUtil.maybeBufferedSeekableStream(stream, Defaults.BUFFER_SIZE);
    }

    public static SeekableStream maybeBufferedSeekableStream(File file) {
        try {
            return IOUtil.maybeBufferedSeekableStream(new SeekableFileStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static InputStream maybeBufferInputStream(InputStream is) {
        return IOUtil.maybeBufferInputStream(is, Defaults.BUFFER_SIZE);
    }

    public static InputStream maybeBufferInputStream(InputStream is, int bufferSize) {
        if (bufferSize > 0) {
            return new BufferedInputStream(is, bufferSize);
        }
        return is;
    }

    public static Reader maybeBufferReader(Reader reader, int bufferSize) {
        if (bufferSize > 0) {
            reader = new BufferedReader(reader, bufferSize);
        }
        return reader;
    }

    public static Reader maybeBufferReader(Reader reader) {
        return IOUtil.maybeBufferReader(reader, Defaults.BUFFER_SIZE);
    }

    public static Writer maybeBufferWriter(Writer writer, int bufferSize) {
        if (bufferSize > 0) {
            writer = new BufferedWriter(writer, bufferSize);
        }
        return writer;
    }

    public static Writer maybeBufferWriter(Writer writer) {
        return IOUtil.maybeBufferWriter(writer, Defaults.BUFFER_SIZE);
    }

    public static void deleteFiles(File ... files) {
        for (File f : files) {
            if (f.delete()) continue;
            System.err.println("Could not delete file " + f);
        }
    }

    public static void deleteFiles(Iterable<File> files) {
        for (File f : files) {
            if (f.delete()) continue;
            System.err.println("Could not delete file " + f);
        }
    }

    public static boolean isRegularPath(File file) {
        return !file.exists() || file.isFile();
    }

    public static File newTempFile(String prefix, String suffix, File[] tmpDirs, long minBytesFree) throws IOException {
        File f = null;
        for (int i = 0; i < tmpDirs.length; ++i) {
            if (i != tmpDirs.length - 1 && tmpDirs[i].getUsableSpace() <= minBytesFree) continue;
            f = File.createTempFile(prefix, suffix, tmpDirs[i]);
            f.deleteOnExit();
            break;
        }
        return f;
    }

    public static File newTempFile(String prefix, String suffix, File[] tmpDirs) throws IOException {
        return IOUtil.newTempFile(prefix, suffix, tmpDirs, 0x140000000L);
    }

    public static File getDefaultTmpDir() {
        String user = System.getProperty("user.name");
        String tmp = System.getProperty("java.io.tmpdir");
        if (tmp.endsWith(File.separatorChar + user)) {
            return new File(tmp);
        }
        return new File(tmp, user);
    }

    public static String basename(File f) {
        String full = f.getName();
        int index = full.lastIndexOf(".");
        if (index > 0 && index > full.lastIndexOf(File.separator)) {
            return full.substring(0, index);
        }
        return full;
    }
}

