/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import net.sf.samtools.BinaryTagCodec;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.TagValueAndUnsignedArrayFlag;
import net.sf.samtools.util.DateParser;
import net.sf.samtools.util.Iso8601Date;
import net.sf.samtools.util.StringUtil;

public class TextTagCodec {
    private static final int NUM_TAG_FIELDS = 3;
    private final String[] fields = new String[3];

    public String encode(String tagName, Object value) {
        long longVal;
        StringBuilder sb = new StringBuilder(tagName);
        sb.append(':');
        char tagType = BinaryTagCodec.getTagValueType(value);
        switch (tagType) {
            case 'C': 
            case 'I': 
            case 'S': 
            case 'c': 
            case 's': {
                tagType = 'i';
            }
        }
        if (tagType == 'H') {
            value = StringUtil.bytesToHexString((byte[])value);
        } else if (tagType == 'B') {
            value = this.getArrayType(value, false) + "," + this.encodeArrayValue(value);
        } else if (tagType == 'i' && ((longVal = ((Number)value).longValue()) > Integer.MAX_VALUE || longVal < Integer.MIN_VALUE)) {
            throw new SAMFormatException("Value for tag " + tagName + " cannot be stored in an Integer: " + longVal);
        }
        sb.append(tagType);
        sb.append(':');
        sb.append(value.toString());
        return sb.toString();
    }

    private char getArrayType(Object array, boolean isUnsigned) {
        int type;
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType == Float.TYPE) {
            if (isUnsigned) {
                throw new IllegalArgumentException("float array cannot be unsigned");
            }
            return 'f';
        }
        if (componentType == Byte.TYPE) {
            type = 99;
        } else if (componentType == Short.TYPE) {
            type = 115;
        } else if (componentType == Integer.TYPE) {
            type = 105;
        } else {
            throw new IllegalArgumentException("Unrecognized array type " + componentType);
        }
        return (char)((int)(isUnsigned ? Character.toUpperCase((char)type) : type));
    }

    private String encodeArrayValue(Object value) {
        StringBuilder ret = new StringBuilder(Array.get(value, 0).toString());
        int length = Array.getLength(value);
        for (int i = 1; i < length; ++i) {
            ret.append(",");
            ret.append(Array.get(value, i).toString());
        }
        return ret.toString();
    }

    private long[] widenToUnsigned(Object array) {
        long mask;
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType == Byte.TYPE) {
            mask = 255L;
        } else if (componentType == Short.TYPE) {
            mask = 65535L;
        } else if (componentType == Integer.TYPE) {
            mask = 0xFFFFFFFFL;
        } else {
            throw new IllegalArgumentException("Unrecognized unsigned array type " + componentType);
        }
        long[] ret = new long[Array.getLength(array)];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Array.getLong(array, i) & mask;
        }
        return ret;
    }

    String encodeUnsignedArray(String tagName, Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Non-array passed to encodeUnsignedArray: " + array.getClass());
        }
        long[] widened = this.widenToUnsigned(array);
        return tagName + ":B:" + this.getArrayType(array, true) + "," + this.encodeArrayValue(widened);
    }

    public String encodeUntypedTag(String tagName, Object value) {
        StringBuilder sb = new StringBuilder(tagName);
        sb.append(':');
        sb.append(value.toString());
        return sb.toString();
    }

    public Map.Entry<String, Object> decode(String tag) {
        int numFields = StringUtil.splitConcatenateExcessTokens(tag, this.fields, ':');
        if (numFields != 3) {
            throw new SAMFormatException("Not enough fields in tag '" + tag + "'");
        }
        final String key = this.fields[0];
        String type = this.fields[1];
        String stringVal = this.fields[2];
        final Object val = this.convertStringToObject(type, stringVal);
        return new Map.Entry<String, Object>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Object getValue() {
                return val;
            }

            @Override
            public Object setValue(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Object convertStringToObject(String type, String stringVal) {
        if (type.equals("Z")) {
            return stringVal;
        }
        if (type.equals("A")) {
            if (stringVal.length() != 1) {
                throw new SAMFormatException("Tag of type A should have a single-character value");
            }
            return Character.valueOf(stringVal.charAt(0));
        }
        if (type.equals("i")) {
            try {
                return new Integer(stringVal);
            }
            catch (NumberFormatException e) {
                throw new SAMFormatException("Tag of type i should have signed decimal value");
            }
        }
        if (type.equals("f")) {
            try {
                return new Float(stringVal);
            }
            catch (NumberFormatException e) {
                throw new SAMFormatException("Tag of type f should have single-precision floating point value");
            }
        }
        if (type.equals("H")) {
            try {
                return StringUtil.hexStringToBytes(stringVal);
            }
            catch (NumberFormatException e) {
                throw new SAMFormatException("Tag of type H should have valid hex string with even number of digits");
            }
        }
        if (type.equals("B")) {
            return this.covertStringArrayToObject(stringVal);
        }
        throw new SAMFormatException("Unrecognized tag type: " + type);
    }

    private Object covertStringArrayToObject(String stringVal) {
        String[] elementTypeAndValue = new String[2];
        if (StringUtil.splitConcatenateExcessTokens(stringVal, elementTypeAndValue, ',') != 2) {
            throw new SAMFormatException("Tag of type B should have an element type followed by comma");
        }
        if (elementTypeAndValue[0].length() != 1) {
            throw new SAMFormatException("Unrecognized element type for array tag value: " + elementTypeAndValue[0]);
        }
        char elementType = elementTypeAndValue[0].charAt(0);
        String[] stringValues = elementTypeAndValue[1].split(",");
        if (stringValues.length == 0) {
            throw new SAMFormatException("Tag of type B should have at least one element");
        }
        if (elementType == 'f') {
            float[] ret = new float[stringValues.length];
            for (int i = 0; i < stringValues.length; ++i) {
                try {
                    ret[i] = Float.parseFloat(stringValues[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SAMFormatException("Array tag of type f should have single-precision floating point value");
                }
            }
            return ret;
        }
        long mask = Long.MAX_VALUE;
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        boolean isUnsigned = Character.isUpperCase(elementType);
        switch (Character.toLowerCase(elementType)) {
            case 'c': {
                if (isUnsigned) {
                    mask = 255L;
                    break;
                }
                minValue = -128L;
                maxValue = 127L;
                break;
            }
            case 's': {
                if (isUnsigned) {
                    mask = 65535L;
                    break;
                }
                minValue = -32768L;
                maxValue = 32767L;
                break;
            }
            case 'i': {
                if (isUnsigned) {
                    mask = 0xFFFFFFFFL;
                    break;
                }
                minValue = Integer.MIN_VALUE;
                maxValue = Integer.MAX_VALUE;
                break;
            }
            default: {
                throw new SAMFormatException("Unrecognized array tag element type: " + elementType);
            }
        }
        if (isUnsigned) {
            minValue = 0L;
            maxValue = mask;
        }
        long[] longValues = new long[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            long longValue;
            try {
                longValue = Long.parseLong(stringValues[i]);
            }
            catch (NumberFormatException e) {
                throw new SAMFormatException("Array tag of type " + elementType + " should have integral value");
            }
            if (longValue < minValue || longValue > maxValue) {
                throw new SAMFormatException("Value for element of array tag of type " + elementType + " is out of allowed range: " + longValue);
            }
            longValues[i] = longValue;
        }
        switch (Character.toLowerCase(elementType)) {
            case 'c': {
                byte[] array = new byte[longValues.length];
                for (int i = 0; i < longValues.length; ++i) {
                    array[i] = (byte)longValues[i];
                }
                if (isUnsigned) {
                    return new TagValueAndUnsignedArrayFlag(array, true);
                }
                return array;
            }
            case 's': {
                short[] array = new short[longValues.length];
                for (int i = 0; i < longValues.length; ++i) {
                    array[i] = (short)longValues[i];
                }
                if (isUnsigned) {
                    return new TagValueAndUnsignedArrayFlag(array, true);
                }
                return array;
            }
            case 'i': {
                int[] array = new int[longValues.length];
                for (int i = 0; i < longValues.length; ++i) {
                    array[i] = (int)longValues[i];
                }
                if (isUnsigned) {
                    return new TagValueAndUnsignedArrayFlag(array, true);
                }
                return array;
            }
        }
        throw new SAMFormatException("Unrecognized array tag element type: " + elementType);
    }

    Iso8601Date decodeDate(String dateStr) {
        try {
            return new Iso8601Date(dateStr);
        }
        catch (DateParser.InvalidDateException ex) {
            try {
                return new Iso8601Date(DateFormat.getDateTimeInstance().parse(dateStr));
            }
            catch (ParseException e) {
                try {
                    return new Iso8601Date(new Date(dateStr));
                }
                catch (Exception e1) {
                    throw new DateParser.InvalidDateException("Could not parse as date: " + dateStr, e);
                }
            }
        }
    }
}

