/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.sf.samtools.BAMFileWriter;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.StreamInflatingIndexingOutputStream;
import net.sf.samtools.util.BlockCompressedFilePointerUtil;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.BlockCompressedOutputStream;
import net.sf.samtools.util.BlockCompressedStreamConstants;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.Md5CalculatingOutputStream;
import net.sf.samtools.util.RuntimeIOException;

public class BamFileIoUtils {
    public static final String BAM_FILE_EXTENSION = ".bam";

    public static boolean isBamFile(File file) {
        return file != null && file.getName().endsWith(BAM_FILE_EXTENSION);
    }

    public static void reheaderBamFile(SAMFileHeader samFileHeader, File inputFile, File outputFile) {
        BamFileIoUtils.reheaderBamFile(samFileHeader, inputFile, outputFile, true, true);
    }

    public static void reheaderBamFile(SAMFileHeader samFileHeader, File inputFile, File outputFile, boolean createMd5, boolean createIndex) {
        try {
            BlockCompressedInputStream.assertNonDefectiveFile(inputFile);
            BamFileIoUtils.assertSortOrdersAreEqual(samFileHeader, inputFile);
            OutputStream outputStream = BamFileIoUtils.buildOutputStream(outputFile, createMd5, createIndex);
            BAMFileWriter.writeHeader(outputStream, samFileHeader);
            BamFileIoUtils.blockCopyBamFile(inputFile, outputStream, true, false);
            CloserUtil.close(inputFile);
            outputStream.close();
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }

    public static void blockCopyBamFile(File inputFile, OutputStream outputStream, boolean skipHeader, boolean skipTerminator) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(inputFile);
            BlockCompressedInputStream.FileTermination term = BlockCompressedInputStream.checkTermination(inputFile);
            if (term == BlockCompressedInputStream.FileTermination.DEFECTIVE) {
                throw new SAMException(inputFile.getAbsolutePath() + " does not have a valid GZIP block at the end of the file.");
            }
            if (skipHeader) {
                long vOffsetOfFirstRecord = SAMUtils.findVirtualOffsetOfFirstRecordInBam(inputFile);
                BlockCompressedInputStream blockIn = new BlockCompressedInputStream(inputFile);
                blockIn.seek(vOffsetOfFirstRecord);
                long remainingInBlock = blockIn.available();
                if (remainingInBlock >= 0L) {
                    BlockCompressedOutputStream blockOut = new BlockCompressedOutputStream(outputStream, null);
                    IOUtil.transferByStream(blockIn, blockOut, remainingInBlock);
                    blockOut.flush();
                }
                blockIn.close();
                for (long pos = BlockCompressedFilePointerUtil.getBlockAddress(blockIn.getFilePointer()); pos > 0L; pos -= in.skip(pos)) {
                }
            }
            long currentPos = in.getChannel().position();
            long length = inputFile.length();
            long skipLast = term == BlockCompressedInputStream.FileTermination.HAS_TERMINATOR_BLOCK && skipTerminator ? (long)BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK.length : 0L;
            long bytesToWrite = length - skipLast - currentPos;
            IOUtil.transferByStream(in, outputStream, bytesToWrite);
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeIOException(ioe);
            }
            catch (Throwable throwable) {
                CloserUtil.close(in);
                throw throwable;
            }
        }
        CloserUtil.close(in);
    }

    public static void gatherWithBlockCopying(List<File> bams, File output, boolean createIndex, boolean createMd5) {
        try {
            OutputStream out = new FileOutputStream(output);
            if (createMd5) {
                out = new Md5CalculatingOutputStream(out, new File(output.getAbsolutePath() + ".md5"));
            }
            if (createIndex) {
                out = new StreamInflatingIndexingOutputStream(out, new File(output.getParentFile(), IOUtil.basename(output) + ".bai"));
            }
            boolean isFirstFile = true;
            for (File f : bams) {
                BamFileIoUtils.blockCopyBamFile(f, out, !isFirstFile, true);
                isFirstFile = false;
            }
            ((OutputStream)out).write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
            ((OutputStream)out).close();
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }

    private static OutputStream buildOutputStream(File outputFile, boolean createMd5, boolean createIndex) throws IOException {
        OutputStream outputStream = new FileOutputStream(outputFile);
        if (createMd5) {
            outputStream = new Md5CalculatingOutputStream(outputStream, new File(outputFile.getAbsolutePath() + ".md5"));
        }
        if (createIndex) {
            outputStream = new StreamInflatingIndexingOutputStream(outputStream, new File(outputFile.getParentFile(), IOUtil.basename(outputFile) + ".bai"));
        }
        return outputStream;
    }

    private static void assertSortOrdersAreEqual(SAMFileHeader newHeader, File inputFile) throws IOException {
        SAMFileHeader origHeader = new SAMFileReader(inputFile).getFileHeader();
        SAMFileHeader.SortOrder newSortOrder = newHeader.getSortOrder();
        if (newSortOrder != SAMFileHeader.SortOrder.unsorted && newSortOrder != origHeader.getSortOrder()) {
            throw new SAMException("Sort order of new header does not match the original file, needs to be " + (Object)((Object)origHeader.getSortOrder()));
        }
    }
}

