/*
 * Copyright (c) 2014 Daniel Kang
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <utility>
#include <vector>

#include "../consts.h"
#include "../classes/GradArgs.h"
#include "../util/util.h"

#ifndef FMIN_GRADFMIN_H_
#define FMIN_GRADFMIN_H_

using std::pair;
using std::vector;

typedef double (*func_eval)(double, void *);

class GradFmin {
  GradArgs *master;
  GradArgs *heldout;
  const int MAX_IT;
  int iter;
  vector<pair<double, int> > eta_to_iter;

 public:
  GradFmin(GradArgs *m_, GradArgs *h_, const int max_it);

  ~GradFmin() {}
  GradFmin(const GradFmin&) = delete;
  GradFmin& operator=(const GradFmin&) = delete;

  void common_run();

  // Function evaluation
  double f_(const double x);

  double minimize();
};

#endif  // FMIN_GRADFMIN_H_
