/*
 * Copyright (c) 2014 Daniel Kang
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <stdint.h>

#ifndef CONSTS_H_
#define CONSTS_H_

#ifndef KBIG
  #define KBIG (8)
#endif
#ifndef K
  #define K (600)
#endif
#ifndef RESOL
  #define RESOL (1)
#endif
// Must be much greater than K2 * NUM_THREADS
#ifndef MINIBATCH
  #define MINIBATCH (20480000)
#endif

#define K2 (2*K)
#define BUF_PAD (K2 * 10)

#define ALLOC_SIZE(SIZE) ((SIZE) + BUF_PAD)
#define KALLOC (K2 / RESOL)

#define YM (1 << (KBIG*2))
#define YGRAD_SIZE (KALLOC * YM)
#define YALL_SIZE ((KALLOC * ((1 << (2*KBIG + 2)) - 1)) / 3)

#define DEFINE_CONSTS(KS) \
  const int __attribute__((unused)) M = (1 << (KS*2));\
  const int __attribute__((unused)) XSIZE_GRAD = (KALLOC*M);\
  const int __attribute__((unused)) XSIZE_ALL = ((KALLOC * ((1 << (2*KS + 2)) - 1)) / 3);

// #define SAFE_THREADING

typedef float   ftype;
typedef double  dtype;
typedef int32_t gtype;

#endif  // CONSTS_H_
