/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.utilities;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.ModelTestService;
import es.uvigo.darwin.jmodeltest.exe.RunConsense;
import es.uvigo.darwin.jmodeltest.exe.RunPhyml;
import es.uvigo.darwin.jmodeltest.exe.RunPhymlThread;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.observer.ConsoleProgressObserver;
import es.uvigo.darwin.jmodeltest.selection.AIC;
import es.uvigo.darwin.jmodeltest.selection.AICc;
import es.uvigo.darwin.jmodeltest.selection.BIC;
import es.uvigo.darwin.jmodeltest.selection.DT;
import es.uvigo.darwin.jmodeltest.selection.HLRT;
import es.uvigo.darwin.jmodeltest.selection.InformationCriterion;
import es.uvigo.darwin.jmodeltest.tree.TreeUtilities;
import es.uvigo.darwin.prottest.util.fileio.AlignmentReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Locale;
import pal.tree.Tree;
import pal.tree.TreeParseException;

public class Simulation {
    private ApplicationOptions options;
    private static final double nil = -99999.0;
    private static final String AIC = "AIC";
    private static final String AICc = "AICc";
    private static final String BIC = "BIC";
    private static final String DT = "DT";
    private static final String[] IC_TYPES = new String[]{"AIC", "AICc", "BIC", "DT"};

    public Simulation(ApplicationOptions applicationOptions) {
        this.options = applicationOptions;
    }

    public void run() {
        Object object;
        Object object2;
        int n;
        String string = "sims/";
        new File(string).mkdir();
        String string2 = string + "out/";
        new File(string2).mkdir();
        String string3 = string + "trees/";
        new File(string3).mkdir();
        String string4 = string + "parameters/";
        new File(string4).mkdir();
        String string5 = this.options.simulationsName;
        boolean bl = !this.options.getInputFile().getName().endsWith("001") && !this.options.getInputFile().getName().endsWith("001.phy") && !this.options.getInputFile().getName().endsWith("001.dat");
        TextOutputStream textOutputStream = ModelTest.setMainConsole(new TextOutputStream(string2 + string5 + ".out", bl));
        TextOutputStream textOutputStream2 = new TextOutputStream(string3 + string5 + ".trees", bl);
        TextOutputStream textOutputStream3 = new TextOutputStream(string4 + string5 + ".parms", bl);
        ModelTest.printHeader(textOutputStream);
        textOutputStream.print("\nArguments =");
        for (n = 0; n < ModelTest.arguments.length; ++n) {
            textOutputStream.print(" " + ModelTest.arguments[n]);
        }
        File file = this.options.getInputFile();
        textOutputStream.print("\n\nReading data file \"" + file.getName() + "\"...");
        if (file.exists()) {
            try {
                ModelTestService.readAlignment(file, this.options.getAlignmentFile());
                this.options.setAlignment(AlignmentReader.readAlignment((PrintWriter)new PrintWriter(System.err), (String)this.options.getAlignmentFile().getAbsolutePath(), (boolean)true));
                textOutputStream.println(" OK.");
                textOutputStream.println("  number of sequences: " + this.options.getNumTaxa());
                textOutputStream.println("  number of sites: " + this.options.getNumSites());
            }
            catch (Exception exception) {
                System.err.println("\nThe specified file \"" + file.getName() + "\" cannot be read as an alignment");
                textOutputStream.println(" failed.\n");
                System.exit(0);
            }
        } else {
            System.err.println("\nThe specified file \"" + file.getName() + "\" cannot be found");
            textOutputStream.println(" failed.\n");
            System.exit(0);
        }
        if (this.options.userTopologyExists) {
            object2 = this.options.getTreeFile();
            this.options.setInputTreeFile(file);
            textOutputStream.print("Reading tree file \"" + ((File)object2).getName() + "\"...");
            object = null;
            try {
                object = TreeUtilities.readTree(((File)object2).getAbsolutePath());
            }
            catch (IOException iOException) {
                System.err.println("\nThe specified tree file \"" + ((File)object2).getName() + "\" cannot be found");
                textOutputStream.println(" failed.\n");
                System.exit(0);
            }
            catch (TreeParseException treeParseException) {
                System.err.println("\nThe specified file \"" + ((File)object2).getName() + "\" cannot be read as valid Newick tree");
                textOutputStream.println(" failed.\n");
                System.exit(0);
            }
            if (object != null) {
                this.options.setUserTree(TreeUtilities.toNewick((Tree)object, true, false, false));
                TextOutputStream textOutputStream4 = new TextOutputStream(this.options.getTreeFile().getAbsolutePath());
                textOutputStream4.print(TreeUtilities.toNewick((Tree)object, true, false, false));
                textOutputStream4.close();
                textOutputStream.println(" OK.");
            }
        }
        System.err.print("Doing \"" + file.getName() + "\" ... ");
        if (this.options.getSubstTypeCode() == 0) {
            this.options.setNumModels(3);
        } else if (this.options.getSubstTypeCode() == 1) {
            this.options.setNumModels(5);
        } else if (this.options.getSubstTypeCode() == 2) {
            this.options.setNumModels(7);
        } else {
            this.options.setNumModels(11);
        }
        if (this.options.doF) {
            this.options.setNumModels(this.options.getNumModels() * 2);
        }
        if (this.options.doI && this.options.doG) {
            this.options.setNumModels(this.options.getNumModels() * 4);
        } else if (this.options.doI || this.options.doG) {
            this.options.setNumModels(this.options.getNumModels() * 2);
        }
        this.options.setCandidateModels();
        object2 = new RunPhymlThread(new ConsoleProgressObserver(this.options), this.options, ModelTest.getCandidateModels());
        ((RunPhyml)object2).execute();
        if (!bl) {
            textOutputStream3.println("data\tname\tln\tK\tfA\tfC\tfG\tfT\tkappa\ttitv\trAC\tAG\trAT\trCG\trCT\trGT\tpinvI\tshapeG\tpinvIG\tshapeIG");
        }
        for (n = 0; n < this.options.getNumModels(); ++n) {
            textOutputStream2.println(this.options.getInputFile().getName() + "\t" + ModelTest.getCandidateModels()[n].getName() + "\t" + ModelTest.getCandidateModels()[n].getTreeString());
            this.printModelLine(ModelTest.getCandidateModels()[n], textOutputStream3, this.options.getInputFile().getName() + "\t" + ModelTest.getCandidateModels()[n].getName(), -99999.0, -99999.0);
        }
        if (this.options.doAIC) {
            this.printSelection(AIC, string3, string5, string4, textOutputStream, bl);
        }
        if (this.options.doAICc) {
            this.printSelection(AICc, string3, string5, string4, textOutputStream, bl);
        }
        if (this.options.doBIC) {
            this.printSelection(BIC, string3, string5, string4, textOutputStream, bl);
        }
        if (this.options.doDT) {
            this.printSelection(DT, string3, string5, string4, textOutputStream, bl);
        }
        if (this.options.doHLRT) {
            object = new HLRT(this.options);
            ((HLRT)object).compute(!this.options.backwardHLRTSelection, this.options.confidenceLevelHLRT, this.options.writePAUPblock);
            textOutputStream2.println(ModelTest.averagedTreeString);
        }
        if (this.options.doDLRT) {
            object = new HLRT(this.options);
            ((HLRT)object).computeDynamical(!this.options.backwardHLRTSelection, this.options.confidenceLevelHLRT, this.options.writePAUPblock);
        }
        textOutputStream.println("\n=> This run has finished.\n");
        System.err.println("OK.");
    }

    public void printModelLine(Model model, TextOutputStream textOutputStream, String string, double d, double d2) {
        if (string == null) {
            textOutputStream.printf("%-10s", model.getName());
        } else {
            textOutputStream.printf("%-10s", string);
        }
        if (model.getLnL() == 0.0) {
            textOutputStream.println("\tOPTIMIZATION FAILED!");
            System.exit(0);
        } else {
            textOutputStream.printf("\t%.4f", model.getLnL());
            textOutputStream.printf("\t%d", model.getK());
            if (d != -99999.0) {
                textOutputStream.printf("\t%.4f ", d);
            }
            if (d2 != -99999.0) {
                textOutputStream.printf("\t%.4f ", d2);
            }
            if (model.ispF()) {
                textOutputStream.printf("\t%.4f ", model.getfA());
                textOutputStream.printf("\t%.4f ", model.getfC());
                textOutputStream.printf("\t%.4f ", model.getfG());
                textOutputStream.printf("\t%.4f ", model.getfT());
            } else {
                textOutputStream.print("\t-\t-\t-\t-");
            }
            if (model.ispT()) {
                textOutputStream.printf("\t%.4f", model.getKappa());
                textOutputStream.printf("\t%.4f", model.getTitv());
            } else {
                textOutputStream.print("\t-\t-");
            }
            if (model.ispR()) {
                textOutputStream.printf("\t%.4f", model.getRa());
                textOutputStream.printf("\t%.4f", model.getRb());
                textOutputStream.printf("\t%.4f", model.getRc());
                textOutputStream.printf("\t%.4f", model.getRd());
                textOutputStream.printf("\t%.4f", model.getRe());
                textOutputStream.printf("\t%.4f", 1.0);
            } else {
                textOutputStream.print("\t-\t-\t-\t-\t-\t-");
            }
            if (model.ispI() && model.ispG()) {
                textOutputStream.printf("\t-\t-\t%.4f", model.getPinv());
                textOutputStream.printf("\t%.4f", model.getShape());
            } else if (model.ispI()) {
                textOutputStream.printf("\t%.4f\t-\t-\t-", model.getPinv());
            } else if (model.ispG()) {
                textOutputStream.printf("\t-\t%.4f\t-\t-", model.getShape());
            } else {
                textOutputStream.print("\t-\t-\t-\t-");
            }
            textOutputStream.println(" ");
        }
    }

    public static String CheckNAsim(double d) {
        if (d == -2.147483648E9) {
            return "-";
        }
        String string = String.format(Locale.ENGLISH, "%.4f", d);
        return string;
    }

    public void printSelection(String string, String string2, String string3, String string4, TextOutputStream textOutputStream, boolean bl) {
        if (!Arrays.asList(IC_TYPES).contains(string)) {
            // empty if block
        }
        TextOutputStream textOutputStream2 = new TextOutputStream(string2 + string3 + "." + string + "_tre", bl);
        TextOutputStream textOutputStream3 = new TextOutputStream(string2 + string3 + "." + string + "_mmi_mtre", bl);
        TextOutputStream textOutputStream4 = new TextOutputStream(string2 + string3 + "." + string + "_mmi_atre", bl);
        TextOutputStream textOutputStream5 = new TextOutputStream(string4 + string3 + "." + string + "_parms", bl);
        TextOutputStream textOutputStream6 = new TextOutputStream(string4 + string3 + "." + string + "_imp_parms", bl);
        TextOutputStream textOutputStream7 = new TextOutputStream(string4 + string3 + "." + string + "_mmi_parms", bl);
        InformationCriterion informationCriterion = string.equals(AIC) ? new AIC(this.options.writePAUPblock, this.options.doImportances, this.options.doModelAveraging, this.options.confidenceInterval) : (string.equals(AICc) ? new AICc(this.options.writePAUPblock, this.options.doImportances, this.options.doModelAveraging, this.options.confidenceInterval) : (string.equals(BIC) ? new BIC(this.options.writePAUPblock, this.options.doImportances, this.options.doModelAveraging, this.options.confidenceInterval) : (string.equals(DT) ? new DT(this.options.writePAUPblock, this.options.doImportances, this.options.doModelAveraging, this.options.confidenceInterval) : null)));
        informationCriterion.compute();
        informationCriterion.print(textOutputStream);
        if (string.equals(AIC)) {
            ModelTest.setMyAIC((AIC)informationCriterion);
        } else if (string.equals(AICc)) {
            ModelTest.setMyAICc((AICc)informationCriterion);
        } else if (string.equals(BIC)) {
            ModelTest.setMyBIC((BIC)informationCriterion);
        } else if (string.equals(DT)) {
            ModelTest.setMyDT((DT)informationCriterion);
        }
        textOutputStream2.println(informationCriterion.getMinModel().getTreeString());
        if (!bl) {
            textOutputStream5.print("data\tname\tln\tK\tscore\tweigth\tfA\tfC\tfG\tfT\tkappa\ttitv\trAC\tAG\trAT\trCG\trCT\trGT\tpinvI\tshapeG\tpinvIG\tshapeIG\n");
        }
        this.printModelLine(informationCriterion.getMinModel(), textOutputStream5, this.options.getInputFile().getName() + "\t" + informationCriterion.getMinModel().getName(), informationCriterion.getMinModelValue(), informationCriterion.getMinModelWeight());
        if (this.options.doAveragedPhylogeny) {
            new RunConsense(informationCriterion, "50% majority rule", this.options.confidenceInterval);
            textOutputStream3.println(ModelTest.averagedTreeString);
            new RunConsense(informationCriterion, "strict", this.options.confidenceInterval);
            textOutputStream4.println(ModelTest.averagedTreeString);
        }
        if (this.options.doImportances) {
            if (!bl) {
                textOutputStream6.print("data\tfA\tfC\tfG\tfT\tkappa\ttitv\trAC\tAG\trAT\trCG\trCT\trGT\tpinvI\tshapeG\tpinvIG\tshapeIG\n");
            }
            textOutputStream6.print(this.options.getInputFile().getName());
            textOutputStream6.printf("\t%.4f", informationCriterion.getIfA());
            textOutputStream6.printf("\t%.4f", informationCriterion.getIfC());
            textOutputStream6.printf("\t%.4f", informationCriterion.getIfG());
            textOutputStream6.printf("\t%.4f", informationCriterion.getIfT());
            textOutputStream6.printf("\t%.4f", informationCriterion.getIkappa());
            textOutputStream6.printf("\t%.4f", informationCriterion.getItitv());
            textOutputStream6.printf("\t%.4f", informationCriterion.getiRa());
            textOutputStream6.printf("\t%.4f", informationCriterion.getiRb());
            textOutputStream6.printf("\t%.4f", informationCriterion.getiRc());
            textOutputStream6.printf("\t%.4f", informationCriterion.getiRd());
            textOutputStream6.printf("\t%.4f", informationCriterion.getiRe());
            textOutputStream6.printf("\t%.4f", informationCriterion.getiRf());
            textOutputStream6.printf("\t%.4f", informationCriterion.getIpinvI());
            textOutputStream6.printf("\t%.4f", informationCriterion.getIshapeG());
            textOutputStream6.printf("\t%.4f", informationCriterion.getIpinvIG());
            textOutputStream6.printf("\t%.4f", informationCriterion.getIshapeIG());
            textOutputStream6.println(" ");
        }
        if (this.options.doModelAveraging) {
            if (!bl) {
                textOutputStream7.print("data\tfA\tfC\tfG\tfT\tkappa\ttitv\trAC\tAG\trAT\trCG\trCT\trGT\tpinvI\tshapeG\tpinvIG\tshapeIG\n");
            }
            textOutputStream7.print(this.options.getInputFile().getName());
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getAfA()));
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getAfC()));
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getAfG()));
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getAfT()));
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getAkappa()));
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getAtitv()));
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getaRa()));
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getaRb()));
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getaRc()));
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getaRd()));
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getaRe()));
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getaRf()));
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getApinvI()));
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getAshapeG()));
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getApinvIG()));
            textOutputStream7.printf("\t%s", Simulation.CheckNAsim(informationCriterion.getAshapeIG()));
            textOutputStream7.println(" ");
        }
    }
}

