/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.tree;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import pal.io.FormattedOutput;
import pal.misc.IdGroup;
import pal.tree.Node;
import pal.tree.ReadTree;
import pal.tree.SplitSystem;
import pal.tree.SplitUtils;
import pal.tree.Tree;
import pal.tree.TreeParseException;

public class TreeUtilities {
    public static final String TREE_CLADE_SUPPORT_ATTRIBUTE = "support";

    public static Tree readTree(String string) throws IOException, TreeParseException {
        ReadTree readTree;
        try {
            readTree = new ReadTree(string);
        }
        catch (TreeParseException treeParseException) {
            throw treeParseException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        return readTree;
    }

    public static void printNH(PrintWriter printWriter, Tree tree, Node node, boolean bl, boolean bl2, boolean bl3) {
        if (!node.isLeaf()) {
            printWriter.print("(");
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (i != 0) {
                    printWriter.print(",");
                }
                TreeUtilities.printNH(printWriter, tree, node.getChild(i), bl, bl2, bl3);
            }
            printWriter.print(")");
        }
        if (!node.isRoot()) {
            if (node.isLeaf() || bl2) {
                String string = node.getIdentifier().toString();
                printWriter.print(string);
            }
            if (bl3 && tree.getAttribute(node, TREE_CLADE_SUPPORT_ATTRIBUTE) != null) {
                double d = (Double)tree.getAttribute(node, TREE_CLADE_SUPPORT_ATTRIBUTE);
                printWriter.printf(":" + FormattedOutput.getInstance().getDecimalString(d, 4), new Object[0]);
            }
            if (bl) {
                printWriter.printf(":" + FormattedOutput.getInstance().getDecimalString(node.getBranchLength(), 10), new Object[0]);
            }
        }
    }

    public static String toNewick(Tree tree, boolean bl, boolean bl2, boolean bl3) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        TreeUtilities.printNH(printWriter, tree, tree.getRoot(), bl, bl2, bl3);
        stringWriter.append(';');
        return stringWriter.toString();
    }

    public static double getEuclideanTreeDistance(Tree tree, Tree tree2) {
        double d;
        double d2;
        int n;
        double d3 = 0.0;
        int n2 = tree.getInternalNodeCount();
        if (n2 != tree2.getInternalNodeCount()) {
            throw new RuntimeException("Different number of internal nodes: " + tree.getInternalNodeCount() + " vs " + tree2.getInternalNodeCount());
        }
        int n3 = tree.getExternalNodeCount();
        if (n3 != tree2.getExternalNodeCount()) {
            throw new RuntimeException("Different number of external nodes: " + tree.getInternalNodeCount() + " vs " + tree2.getInternalNodeCount());
        }
        for (n = 0; n < n2; ++n) {
            d2 = tree.getInternalNode(n).getBranchLength();
            d = tree2.getInternalNode(n).getBranchLength();
            d3 += (d2 - d) * (d2 - d);
        }
        for (n = 0; n < n3; ++n) {
            d2 = tree.getExternalNode(n).getBranchLength();
            d = tree2.getExternalNode(n).getBranchLength();
            d3 += (d2 - d) * (d2 - d);
        }
        return Math.sqrt(d3);
    }

    public static double getRobinsonFouldsTreeDistance(Tree tree, Tree tree2) {
        int n;
        SplitSystem splitSystem = SplitUtils.getSplits((Tree)tree);
        IdGroup idGroup = splitSystem.getIdGroup();
        SplitSystem splitSystem2 = SplitUtils.getSplits((IdGroup)idGroup, (Tree)tree2);
        if (splitSystem.getLabelCount() != splitSystem2.getLabelCount()) {
            throw new IllegalArgumentException("Number of labels must be the same!");
        }
        int n2 = splitSystem.getSplitCount();
        int n3 = splitSystem2.getSplitCount();
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (splitSystem2.hasSplit(splitSystem.getSplit(n))) continue;
            ++n4;
        }
        n = 0;
        for (int i = 0; i < n3; ++i) {
            if (splitSystem.hasSplit(splitSystem2.getSplit(i))) continue;
            ++n;
        }
        return (double)n + (double)n4;
    }
}

