/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.tree;

import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.tree.TreeDistancesCache;
import es.uvigo.darwin.jmodeltest.tree.TreeEuclideanDistancesCache;
import es.uvigo.darwin.jmodeltest.tree.TreeRFDistancesCache;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import pal.tree.Tree;

public class TreeSummary {
    private int AIC_INDEX = 0;
    private int AICC_INDEX = 1;
    private int BIC_INDEX = 2;
    private int DT_INDEX = 3;
    private int IC_COUNT = 4;
    private Tree[] bestTree = new Tree[this.IC_COUNT];
    private TreeDistancesCache rfDistances = TreeRFDistancesCache.getInstance();
    private TreeDistancesCache euclideanDistances = TreeEuclideanDistancesCache.getInstance();
    private Hashtable<Tree, SummaryRow> summary;
    private List<Tree> topologiesAIC = null;
    private List<Tree> topologiesAICc = null;
    private List<Tree> topologiesBIC = null;
    private List<Tree> topologiesDT = null;
    private List<Tree> sortedTopologies = null;

    public TreeSummary(Tree tree, Tree tree2, Tree tree3, Tree tree4, Model[] modelArray) {
        if (tree != null) {
            this.bestTree[this.AIC_INDEX] = tree;
            this.topologiesAIC = new ArrayList<Tree>();
        }
        if (tree2 != null) {
            this.bestTree[this.AICC_INDEX] = tree2;
            this.topologiesAICc = new ArrayList<Tree>();
        }
        if (tree3 != null) {
            this.bestTree[this.BIC_INDEX] = tree3;
            this.topologiesBIC = new ArrayList<Tree>();
        }
        if (tree4 != null) {
            this.bestTree[this.DT_INDEX] = tree4;
            this.topologiesDT = new ArrayList<Tree>();
        }
        this.summary = new Hashtable();
        for (Model model : modelArray) {
            boolean bl = false;
            for (Tree tree5 : this.summary.keySet()) {
                if (!this.sameTopology(tree5, model.getTree())) continue;
                this.summary.get(tree5).addModel(model);
                bl = true;
                break;
            }
            if (bl) continue;
            SummaryRow summaryRow = new SummaryRow(model.getTree());
            summaryRow.addModel(model);
            this.summary.put(model.getTree(), summaryRow);
            if (this.topologiesAIC != null) {
                this.topologiesAIC.add(model.getTree());
            }
            if (this.topologiesAICc != null) {
                this.topologiesAICc.add(model.getTree());
            }
            if (this.topologiesBIC != null) {
                this.topologiesBIC.add(model.getTree());
            }
            if (this.topologiesDT == null) continue;
            this.topologiesDT.add(model.getTree());
        }
        for (Tree tree6 : this.summary.keySet()) {
            this.summary.get(tree6).computeEuclideanDistances();
        }
        if (this.topologiesAIC != null) {
            Collections.sort(this.topologiesAIC, new AicComparator());
        }
        if (this.topologiesAICc != null) {
            Collections.sort(this.topologiesAICc, new AiccComparator());
        }
        if (this.topologiesBIC != null) {
            Collections.sort(this.topologiesBIC, new BicComparator());
        }
        if (this.topologiesDT != null) {
            Collections.sort(this.topologiesDT, new DtComparator());
        }
        this.sortedTopologies = this.topologiesAIC != null ? this.topologiesAIC : (this.topologiesBIC != null ? this.topologiesBIC : (this.topologiesAICc != null ? this.topologiesAICc : (this.topologiesDT != null ? this.topologiesDT : new ArrayList<Tree>(this.summary.keySet()))));
    }

    public int getNumberOfTopologies() {
        return this.summary.size();
    }

    public Tree getTopology(int n) {
        return this.sortedTopologies.get(n);
    }

    public List<Model> getModelsByTopology(int n) {
        return this.summary.get((Object)this.getTopology((int)n)).models;
    }

    public List<Model> getAICModels(int n) {
        Tree tree = this.topologiesAIC.get(n);
        return this.summary.get((Object)tree).models;
    }

    public List<Model> getBICModels(int n) {
        Tree tree = this.topologiesBIC.get(n);
        return this.summary.get((Object)tree).models;
    }

    public List<Model> getAICcModels(int n) {
        Tree tree = this.topologiesAICc.get(n);
        return this.summary.get((Object)tree).models;
    }

    public List<Model> getDTModels(int n) {
        Tree tree = this.topologiesDT.get(n);
        return this.summary.get((Object)tree).models;
    }

    public int aicIndexOf(Tree tree) {
        return this.topologiesAIC.indexOf(tree);
    }

    public long aicRfOf(Tree tree) {
        return this.summary.get((Object)tree).rfDistance[this.AIC_INDEX];
    }

    public double aicAvgDistance(Tree tree) {
        return this.summary.get((Object)tree).avgEuclideanDistance[this.AIC_INDEX];
    }

    public double aicVarDistance(Tree tree) {
        return this.summary.get((Object)tree).varEuclideanDistance[this.AIC_INDEX];
    }

    public double aiccWeight(Tree tree) {
        return this.summary.get((Object)tree).support[this.AICC_INDEX];
    }

    public int aiccIndexOf(Tree tree) {
        return this.topologiesAICc.indexOf(tree);
    }

    public long aiccRfOf(Tree tree) {
        return this.summary.get((Object)tree).rfDistance[this.AICC_INDEX];
    }

    public double aiccAvgDistance(Tree tree) {
        return this.summary.get((Object)tree).avgEuclideanDistance[this.AICC_INDEX];
    }

    public double aiccVarDistance(Tree tree) {
        return this.summary.get((Object)tree).varEuclideanDistance[this.AICC_INDEX];
    }

    public double aicWeight(Tree tree) {
        return this.summary.get((Object)tree).support[this.AIC_INDEX];
    }

    public int bicIndexOf(Tree tree) {
        return this.topologiesBIC.indexOf(tree);
    }

    public long bicRfOf(Tree tree) {
        return this.summary.get((Object)tree).rfDistance[this.BIC_INDEX];
    }

    public double bicAvgDistance(Tree tree) {
        return this.summary.get((Object)tree).avgEuclideanDistance[this.BIC_INDEX];
    }

    public double bicVarDistance(Tree tree) {
        return this.summary.get((Object)tree).varEuclideanDistance[this.BIC_INDEX];
    }

    public double bicWeight(Tree tree) {
        return this.summary.get((Object)tree).support[this.BIC_INDEX];
    }

    public int dtIndexOf(Tree tree) {
        return this.topologiesDT.indexOf(tree);
    }

    public long dtRfOf(Tree tree) {
        return this.summary.get((Object)tree).rfDistance[this.DT_INDEX];
    }

    public double dtAvgDistance(Tree tree) {
        return this.summary.get((Object)tree).avgEuclideanDistance[this.DT_INDEX];
    }

    public double dtVarDistance(Tree tree) {
        return this.summary.get((Object)tree).varEuclideanDistance[this.DT_INDEX];
    }

    public double dtWeight(Tree tree) {
        return this.summary.get((Object)tree).support[this.DT_INDEX];
    }

    private boolean sameTopology(Tree tree, Tree tree2) {
        return this.rfDistances.getDistance(tree, tree2) == 0.0;
    }

    private long rfDistance(Tree tree, Tree tree2) {
        if (tree == null || tree2 == null) {
            return -1L;
        }
        return Math.round(this.rfDistances.getDistance(tree, tree2));
    }

    public void print(TextOutputStream textOutputStream) {
        int n = 80;
        if (this.topologiesAIC != null || this.topologiesBIC != null || this.topologiesAICc != null || this.topologiesDT != null) {
            List<Tree> list = this.topologiesAIC != null ? this.topologiesAIC : (this.topologiesBIC != null ? this.topologiesBIC : (this.topologiesAICc != null ? this.topologiesAICc : this.topologiesDT));
            textOutputStream.println("::Optimized Topologies Summary::");
            textOutputStream.println("");
            textOutputStream.println("There are " + this.getNumberOfTopologies() + " different topologies.");
            textOutputStream.println("");
            for (int i = 0; i < this.getNumberOfTopologies(); ++i) {
                int n2 = i + 1;
                Tree tree = list.get(i);
                SummaryRow summaryRow = this.summary.get(tree);
                int n3 = this.topologiesAIC != null ? this.aicIndexOf(tree) + 1 : -1;
                int n4 = this.topologiesAICc != null ? this.aiccIndexOf(tree) + 1 : -1;
                int n5 = this.topologiesBIC != null ? this.bicIndexOf(tree) + 1 : -1;
                int n6 = this.topologiesDT != null ? this.dtIndexOf(tree) + 1 : -1;
                textOutputStream.println("Topology Id: " + n2);
                textOutputStream.println("\tRank\tWeight\t\t RF\tAvgEucl\t\tVarEucl");
                if (this.topologiesAIC != null) {
                    textOutputStream.println(this.getIcRow("AIC", n3, summaryRow, this.AIC_INDEX));
                }
                if (this.topologiesBIC != null) {
                    textOutputStream.println(this.getIcRow("BIC", n5, summaryRow, this.BIC_INDEX));
                }
                if (this.topologiesAICc != null) {
                    textOutputStream.println(this.getIcRow("AICc", n4, summaryRow, this.AICC_INDEX));
                }
                if (this.topologiesDT != null) {
                    textOutputStream.println(this.getIcRow("DT", n6, summaryRow, this.DT_INDEX));
                }
                textOutputStream.println("Models supporting:   " + summaryRow.models.size());
                textOutputStream.print("                     ");
                int n7 = 0;
                for (Model model : summaryRow.models) {
                    if (n7 >= n) {
                        textOutputStream.println("");
                        textOutputStream.print("                     ");
                        n7 = 0;
                    }
                    textOutputStream.print(model.getName() + " ");
                    n7 += model.getName().length() + 1;
                }
                textOutputStream.println("");
                textOutputStream.println("");
            }
        }
    }

    private String getIcRow(String string, int n, SummaryRow summaryRow, int n2) {
        return string + "\t" + Utilities.format(n, 3, 0, false) + "\t" + Utilities.asPercent(summaryRow.support[n2] * 100.0) + "\t\t" + Utilities.format(summaryRow.rfDistance[n2], 3, 0, false) + "\t" + Utilities.format(summaryRow.avgEuclideanDistance[n2], 8, 2, true) + "\t" + Utilities.format(summaryRow.varEuclideanDistance[n2], 8, 2, true);
    }

    class DtComparator
    implements Comparator<Tree> {
        DtComparator() {
        }

        @Override
        public int compare(Tree tree, Tree tree2) {
            long l = TreeSummary.this.rfDistance(tree, TreeSummary.this.bestTree[TreeSummary.this.DT_INDEX]);
            long l2 = TreeSummary.this.rfDistance(tree2, TreeSummary.this.bestTree[TreeSummary.this.DT_INDEX]);
            return (int)(l - l2);
        }
    }

    class BicComparator
    implements Comparator<Tree> {
        BicComparator() {
        }

        @Override
        public int compare(Tree tree, Tree tree2) {
            long l = TreeSummary.this.rfDistance(tree, TreeSummary.this.bestTree[TreeSummary.this.BIC_INDEX]);
            long l2 = TreeSummary.this.rfDistance(tree2, TreeSummary.this.bestTree[TreeSummary.this.BIC_INDEX]);
            return (int)(l - l2);
        }
    }

    class AiccComparator
    implements Comparator<Tree> {
        AiccComparator() {
        }

        @Override
        public int compare(Tree tree, Tree tree2) {
            long l = TreeSummary.this.rfDistance(tree, TreeSummary.this.bestTree[TreeSummary.this.AICC_INDEX]);
            long l2 = TreeSummary.this.rfDistance(tree2, TreeSummary.this.bestTree[TreeSummary.this.AICC_INDEX]);
            return (int)(l - l2);
        }
    }

    class AicComparator
    implements Comparator<Tree> {
        AicComparator() {
        }

        @Override
        public int compare(Tree tree, Tree tree2) {
            long l = TreeSummary.this.rfDistance(tree, TreeSummary.this.bestTree[TreeSummary.this.AIC_INDEX]);
            long l2 = TreeSummary.this.rfDistance(tree2, TreeSummary.this.bestTree[TreeSummary.this.AIC_INDEX]);
            return (int)(l - l2);
        }
    }

    class SummaryRow {
        List<Model> models;
        Tree commonTopology;
        long[] rfDistance = new long[]{0L, 0L, 0L, 0L};
        double[] avgEuclideanDistance = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] varEuclideanDistance = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] support = new double[]{0.0, 0.0, 0.0, 0.0};

        SummaryRow(Tree tree) {
            this.commonTopology = tree;
            for (int i = 0; i < TreeSummary.this.IC_COUNT; ++i) {
                this.rfDistance[i] = TreeSummary.this.rfDistance(tree, TreeSummary.this.bestTree[i]);
            }
            this.models = new ArrayList<Model>();
        }

        void addModel(Model model) {
            if (this.checkTopology(model)) {
                this.models.add(model);
                int n = TreeSummary.this.AIC_INDEX;
                this.support[n] = this.support[n] + model.getAICw();
                int n2 = TreeSummary.this.AICC_INDEX;
                this.support[n2] = this.support[n2] + model.getAICcw();
                int n3 = TreeSummary.this.BIC_INDEX;
                this.support[n3] = this.support[n3] + model.getBICw();
                int n4 = TreeSummary.this.DT_INDEX;
                this.support[n4] = this.support[n4] + model.getDTw();
            }
        }

        void computeEuclideanDistances() {
            for (int i = 0; i < TreeSummary.this.IC_COUNT; ++i) {
                if (TreeSummary.this.bestTree[i] == null) continue;
                this.avgEuclideanDistance[i] = 0.0;
                this.varEuclideanDistance[i] = 0.0;
                for (Model model : this.models) {
                    double d = TreeSummary.this.euclideanDistances.getDistance(model.getTree(), TreeSummary.this.bestTree[i]);
                    int n = i;
                    this.avgEuclideanDistance[n] = this.avgEuclideanDistance[n] + d;
                    int n2 = i;
                    this.varEuclideanDistance[n2] = this.varEuclideanDistance[n2] + d * d;
                }
                int n = i;
                this.avgEuclideanDistance[n] = this.avgEuclideanDistance[n] / (double)this.models.size();
                int n3 = i;
                this.varEuclideanDistance[n3] = this.varEuclideanDistance[n3] / (double)this.models.size();
                int n4 = i;
                this.varEuclideanDistance[n4] = this.varEuclideanDistance[n4] - this.avgEuclideanDistance[i] * this.avgEuclideanDistance[i];
            }
        }

        boolean checkTopology(Model model) {
            return TreeSummary.this.rfDistances.getDistance(this.commonTopology, model.getTree()) == 0.0;
        }
    }
}

