/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.tree;

import es.uvigo.darwin.jmodeltest.tree.TreeUtilities;
import java.util.Hashtable;
import pal.tree.Tree;

public class TreeDistancesCache {
    public static final int EUCLIDEAN = 1;
    public static final int ROBINSON_FOULDS = 2;
    private Hashtable<TreePair, Double> distances;
    private int distanceType;

    public int getDistanceType() {
        return this.distanceType;
    }

    public TreeDistancesCache(int n) {
        if (n == 1 || n != 2) {
            // empty if block
        }
        this.distanceType = n;
        this.distances = new Hashtable();
    }

    public double getDistance(Tree tree, Tree tree2) {
        double d = 0.0;
        TreePair treePair = new TreePair(tree, tree2);
        if (this.distances.containsKey(treePair)) {
            d = this.distances.get(treePair);
        } else {
            switch (this.distanceType) {
                case 1: {
                    d = TreeUtilities.getEuclideanTreeDistance(tree, tree2);
                    break;
                }
                case 2: {
                    d = TreeUtilities.getRobinsonFouldsTreeDistance(tree, tree2);
                }
            }
            this.distances.put(treePair, d);
        }
        return d;
    }

    private class TreePair {
        private Tree t1;
        private Tree t2;

        public TreePair(Tree tree, Tree tree2) {
            this.t1 = tree;
            this.t2 = tree2;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.t1 == null ? 0 : this.t1.hashCode());
            n = 31 * n + (this.t2 == null ? 0 : this.t2.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TreePair treePair = (TreePair)object;
            if (!this.getOuterType().equals(treePair.getOuterType())) {
                return false;
            }
            boolean bl = this.t1.equals(treePair.t1) && this.t2.equals(treePair.t2);
            boolean bl2 = this.t1.equals(treePair.t2) && this.t2.equals(treePair.t1);
            return bl || bl2;
        }

        private TreeDistancesCache getOuterType() {
            return TreeDistancesCache.this;
        }
    }
}

