/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.selection;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.statistics.Statistics;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.util.Enumeration;

public class HLRT {
    private ApplicationOptions options;
    public final double MAX_PROB = 0.999999;
    public final double MIN_PROB = 1.0E-6;
    public double alphaLRT;
    public TextOutputStream stream = ModelTest.getMainConsole();
    public int TPMnumber;
    public int TIMnumber;

    public HLRT(ApplicationOptions applicationOptions) {
        this.options = applicationOptions;
        this.TPMnumber = 0;
        this.TIMnumber = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void compute(boolean bl, double d, boolean bl2) {
        this.alphaLRT = d;
        String[] stringArray = new String[ModelTest.testingOrder.size()];
        int n = 0;
        Enumeration<String> enumeration = ModelTest.testingOrder.elements();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = enumeration.nextElement();
        }
        if (ModelTest.buildGUI) {
            System.out.print("computing hLRT ... ");
        }
        Model model = bl ? ModelTest.getCandidateModels()[0] : ModelTest.getCandidateModels()[this.options.getNumModels() - 1];
        this.stream.println("\n\n\n---------------------------------------------------------------");
        this.stream.println("*                                                             *");
        this.stream.println("*          HIERARCHICAL LIKELIHOO RATIO TESTS (hLRT)          *");
        this.stream.println("*                                                             *");
        this.stream.println("---------------------------------------------------------------");
        if (this.options.getSubstTypeCode() >= 4) {
            this.stream.println("\nhLRT is not available for the 203 substitution scheme.");
            this.stream.println("Please use one of the other available selection criteria (AIC, BIC, AICc or DT).");
            return;
        }
        if (!(this.options.fixedTopology | this.options.userTopologyExists)) {
            this.stream.println("\nhLRT is only available when likelihoods are calculated on the same tree (i.e., models are nested)");
            this.stream.println("Execute jModelTest using a fixed BIONJ-JC tree or a user-defined topology");
        } else {
            this.stream.println("\nSettings: ");
            if (bl) {
                this.stream.println("  Forward selection (adding parameters)");
            } else {
                this.stream.println("  Backward selection (removing parameters)");
            }
            this.stream.println("    starting model = " + model.getName());
            this.stream.print("    hypotheses order = ");
            for (n = 0; n < stringArray.length; ++n) {
                this.stream.print(stringArray[n]);
                if (n >= stringArray.length - 1) continue;
                this.stream.print("-");
            }
            this.stream.print("\n  Confidence alpha level = ");
            this.stream.printf("%6.4f\n", this.alphaLRT);
            Model model2 = null;
            Model model3 = null;
            for (n = 0; n < stringArray.length; ++n) {
                block23: {
                    if (bl) {
                        model2 = model;
                    } else {
                        model3 = model;
                    }
                    this.stream.println("\n* Tested hypothesis = " + stringArray[n]);
                    Model model4 = this.findCompetingModel(model, stringArray[n], bl);
                    if (model4 == null) {
                        this.stream.println("Cannot be tested. No competing model differs just by " + stringArray[n] + " from " + model.getName() + ".\nRevise the order of hypotheses selected for the LRTs." + "\n...Skipping to the next hypothesis");
                        continue;
                    }
                    if (ApplicationOptions.getInstance().getSubstTypeCode() == 3 && (model4.getName().startsWith("TIM") || model4.getName().startsWith("TPM"))) {
                        model4 = this.BestTIMTPM(model4);
                    }
                    if (bl) {
                        model3 = model4;
                    } else {
                        model2 = model4;
                    }
                    this.stream.printf("Null model        = %-8s", model2.getName());
                    this.stream.printf("\t-lnL = %6.4f", model2.getLnL());
                    this.stream.printf("\nAlternative model = %-8s", model3.getName());
                    this.stream.printf("\t-lnL = %6.4f", model3.getLnL());
                    this.stream.println();
                    double d2 = stringArray[n].equals("gamma") || stringArray[n].equals("pinv") ? this.LRTboundary(model2, model3) : this.LRT(model2, model3);
                    if (bl) {
                        if (d2 < this.alphaLRT) {
                            model = model3;
                            break block23;
                        } else {
                            this.stream.println("\nThe current model could not be rejected");
                            if (!ModelTest.buildGUI) break;
                            Utilities.toConsoleEnd();
                            break;
                        }
                    }
                    if (d2 > this.alphaLRT) {
                        model = model2;
                    } else {
                        this.stream.println("\nThe current model rejected the null model");
                        if (!ModelTest.buildGUI) break;
                        Utilities.toConsoleEnd();
                        break;
                    }
                }
                if (!ModelTest.buildGUI) continue;
                Utilities.toConsoleEnd();
            }
            ModelTest.setMinHLRT(model);
            this.stream.println("\n Model selected: ");
            ModelTest.getMinHLRT().print(this.stream);
            if (ApplicationOptions.getInstance().optimizeMLTopology) {
                this.stream.println("\nML tree (NNI) for the best hLRT model = " + ModelTest.getMinHLRT().getTreeString());
            }
            if (bl2) {
                ModelTest.WritePaupBlock(this.stream, "hLRT", ModelTest.getMinHLRT());
            }
        }
        if (ModelTest.buildGUI) {
            Utilities.toConsoleEnd();
            System.out.println("OK");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void computeDynamical(boolean bl, double d, boolean bl2) {
        this.alphaLRT = d;
        String[] stringArray = new String[ModelTest.testingOrder.size()];
        int n = 0;
        for (String string : ModelTest.testingOrder) {
            stringArray[n++] = string;
        }
        if (ModelTest.buildGUI) {
            System.out.print("computing dynamical LRTs ... ");
        }
        Model model = bl ? ModelTest.getCandidateModels()[0] : ModelTest.getCandidateModels()[this.options.getNumModels() - 1];
        this.stream.println("\n\n\n---------------------------------------------------------------");
        this.stream.println("*                                                             *");
        this.stream.println("*          DYNAMICAL LIKELIHOO RATIO TESTS (dLRT)             *");
        this.stream.println("*                                                             *");
        this.stream.println("---------------------------------------------------------------");
        this.stream.println("\nSettings: ");
        if (bl) {
            this.stream.println("  Forward selection (adding parameters)");
        } else {
            this.stream.println("  Backward selection (removing parameters)");
        }
        this.stream.println("    starting model = " + model.getName());
        this.stream.print("    hypotheses = ");
        for (n = 0; n < stringArray.length; ++n) {
            this.stream.print(stringArray[n]);
            if (n >= stringArray.length - 1) continue;
            this.stream.print(", ");
        }
        this.stream.print("\n  Confidence alpha level = ");
        this.stream.printf("%6.4f\n", this.alphaLRT);
        Model model2 = null;
        Model model3 = null;
        boolean bl3 = true;
        while (bl3) {
            int n2;
            block24: {
                double d2;
                Model model4 = null;
                n2 = 0;
                if (bl) {
                    model2 = model;
                    d2 = 0.0;
                } else {
                    model3 = model;
                    d2 = 1000000.0;
                }
                for (n = 0; n < stringArray.length; ++n) {
                    double d3 = 0.0;
                    Model model5 = this.findCompetingModel(model, stringArray[n], bl);
                    if (model5 == null) continue;
                    if (ApplicationOptions.getInstance().getSubstTypeCode() == 3 && (model5.getName().startsWith("TIM") || model5.getName().startsWith("TPM"))) {
                        model5 = this.BestTIMTPM(model5);
                    }
                    d3 = Math.abs(model.getLnL() - model5.getLnL());
                    if (!(bl && d3 > d2) && (bl || !(d3 < d2))) continue;
                    model4 = model5;
                    d2 = d3;
                    n2 = n;
                }
                if (model4 == null) {
                    this.stream.print("\nNo best competing model for any of the " + stringArray.length + " remaining hypotheses: ");
                    for (n = 0; n < stringArray.length; ++n) {
                        this.stream.print(stringArray[n]);
                        if (n >= stringArray.length - 1) continue;
                        this.stream.print(" + ");
                    }
                    this.stream.println(", given the current model = " + model.getName());
                    bl3 = false;
                    continue;
                }
                if (bl) {
                    model3 = model4;
                } else {
                    model2 = model4;
                }
                this.stream.println("\nTesting " + stringArray[n2] + " hypothesis");
                this.stream.printf("Null model        = %-8s", model2.getName());
                this.stream.printf("\t-lnL = %6.4f", model2.getLnL());
                this.stream.printf("\nAlternative model = %-8s", model3.getName());
                this.stream.printf("\t-lnL = %6.4f", model3.getLnL());
                this.stream.println();
                double d4 = stringArray[n2].equals("gamma") || stringArray[n2].equals("pinv") ? this.LRTboundary(model2, model3) : this.LRT(model2, model3);
                if (bl) {
                    if (d4 < this.alphaLRT) {
                        model = model3;
                        break block24;
                    } else {
                        this.stream.println("\nThe current model could not be rejected");
                        if (!ModelTest.buildGUI) break;
                        Utilities.toConsoleEnd();
                        break;
                    }
                }
                if (d4 > this.alphaLRT) {
                    model = model2;
                } else {
                    this.stream.println("\nThe current model rejected the null model");
                    if (!ModelTest.buildGUI) break;
                    Utilities.toConsoleEnd();
                    break;
                }
            }
            String[] stringArray2 = new String[stringArray.length - 1];
            int n3 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                if (n < n2) {
                    stringArray2[n3++] = stringArray[n].toString();
                    continue;
                }
                if (n <= n2) continue;
                stringArray2[n3++] = stringArray[n].toString();
            }
            stringArray = stringArray2;
            if (stringArray.length <= 0) {
                bl3 = false;
            }
            if (!ModelTest.buildGUI) continue;
            Utilities.toConsoleEnd();
        }
        ModelTest.setMinDLRT(model);
        this.stream.println("\n Model selected: ");
        ModelTest.getMinDLRT().print(this.stream);
        if (bl2) {
            ModelTest.WritePaupBlock(this.stream, "dLRT", ModelTest.getMinDLRT());
        }
        if (ModelTest.buildGUI) {
            Utilities.toConsoleEnd();
            System.out.println("OK");
        }
    }

    public Model findCompetingModel(Model model, String string, boolean bl) {
        Model model2 = null;
        Model[] modelArray = ModelTest.getCandidateModels();
        int n = modelArray.length;
        for (int i = 0; i < n; ++i) {
            Model model3;
            Model model4 = model3 = modelArray[i];
            boolean bl2 = false;
            int n2 = 0;
            if (bl && model.getK() - model4.getK() >= 0 || !bl && model.getK() - model4.getK() <= 0) continue;
            if (model.ispF() != model4.ispF()) {
                if (string.equals("freq")) {
                    bl2 = true;
                }
                ++n2;
            }
            if (!model.ispT() && model4.ispT() || !model4.ispT() && model.ispT()) {
                if (string.equals("titv")) {
                    bl2 = true;
                }
                if (!model.ispR() && !model4.ispR()) {
                    ++n2;
                }
            }
            if (model.ispG() != model4.ispG()) {
                if (string.equals("gamma")) {
                    bl2 = true;
                }
                ++n2;
            }
            if (model.ispI() != model4.ispI()) {
                if (string.equals("pinv")) {
                    bl2 = true;
                }
                ++n2;
            }
            if (model.ispT() == model4.ispT() && model.ispR() != model4.ispR()) {
                bl2 = false;
            }
            if (ApplicationOptions.getInstance().getSubstTypeCode() == 0) {
                if (Math.abs(model4.getNumTi() - model.getNumTi()) == 1 && Math.abs(model4.getNumTv() - model.getNumTv()) == 3) {
                    if (string.equals("2ti4tv")) {
                        bl2 = true;
                    }
                    ++n2;
                }
            } else if (bl && (model.ispT() || model.ispR()) || !bl && (model4.ispT() || model4.ispR())) {
                if (Math.abs(model4.getNumTi() - model.getNumTi()) == 1) {
                    if (string.equals("2ti")) {
                        bl2 = true;
                    }
                    ++n2;
                }
                if (Math.abs(model4.getNumTv() - model.getNumTv()) == 1) {
                    if (string.equals("2tv")) {
                        bl2 = true;
                    }
                    ++n2;
                } else if (Math.abs(model4.getNumTv() - model.getNumTv()) == 2) {
                    if (string.equals("4tv")) {
                        bl2 = true;
                    }
                    ++n2;
                } else if (Math.abs(model4.getNumTv() - model.getNumTv()) == 3) {
                    bl2 = false;
                }
            }
            if (!bl2 || n2 != 1) continue;
            model2 = model3;
            break;
        }
        return model2;
    }

    public Model BestTIMTPM(Model model) {
        Model model2 = null;
        String string = model.getName();
        String string2 = string.replaceFirst("[0-9]", "1");
        String string3 = string.replaceFirst("[0-9]", "2");
        String string4 = string.replaceFirst("[0-9]", "3");
        model2 = this.findBest(string2, string3, string4);
        return model2;
    }

    public Model findBest(String string, String string2, String string3) {
        Model model = null;
        Model model2 = null;
        Model model3 = null;
        for (Model model4 : ModelTest.getCandidateModels()) {
            if (string.equals(model4.getName())) {
                model3 = model4;
                continue;
            }
            if (string2.equals(model4.getName())) {
                model2 = model4;
                continue;
            }
            if (!string3.equals(model4.getName())) continue;
            model = model4;
        }
        if (model3.getName().startsWith("TIM") && this.TIMnumber > 0) {
            if (this.TIMnumber == 1) {
                return model3;
            }
            if (this.TIMnumber == 2) {
                return model2;
            }
            return model;
        }
        if (model3.getName().startsWith("TPM") && this.TPMnumber > 0) {
            if (this.TPMnumber == 1) {
                return model3;
            }
            if (this.TPMnumber == 2) {
                return model2;
            }
            return model;
        }
        this.stream.println("Selecting first best representative model among:");
        this.stream.println("  " + model3.getName() + " (-lnL = " + model3.getLnL() + ")");
        this.stream.println("  " + model2.getName() + " (-lnL = " + model2.getLnL() + ")");
        this.stream.println("  " + model.getName() + " (-lnL = " + model.getLnL() + ")");
        if (model3.getLnL() <= model2.getLnL() && model3.getLnL() <= model.getLnL()) {
            if (model3.getName().startsWith("TIM")) {
                this.TIMnumber = 1;
            } else {
                this.TPMnumber = 1;
            }
            return model3;
        }
        if (model2.getLnL() <= model3.getLnL() && model2.getLnL() <= model.getLnL()) {
            if (model2.getName().startsWith("TIM")) {
                this.TIMnumber = 2;
            } else {
                this.TPMnumber = 2;
            }
            return model2;
        }
        if (model.getName().startsWith("TIM")) {
            this.TIMnumber = 3;
        } else {
            this.TPMnumber = 3;
        }
        return model;
    }

    private double LRT(Model model, Model model2) {
        double d = 2.0 * (model.getLnL() - model2.getLnL());
        int n = model2.getK() - model.getK();
        double d2 = d == 0.0 ? 1.0 : Statistics.chiSquareProbability(d, n);
        this.stream.printf("2(lnL1-lnL0)      = %6.4f", d);
        if (d2 == 1.0) {
            this.stream.println("\tP-value > 0.999999");
        } else if (d2 < 1.0E-6) {
            this.stream.println("\tP-value < 1.0E-6");
        } else {
            this.stream.printf("\tP-value = %6.4f\n", d2);
        }
        return d2;
    }

    private double LRTboundary(Model model, Model model2) {
        double d = 2.0 * (model.getLnL() - model2.getLnL());
        int n = model2.getK() - model.getK();
        double d2 = d == 0.0 ? 1.0 : (n == 1 ? Statistics.chiSquareProbability(d, n) / 2.0 : (Statistics.chiSquareProbability(d, n - 1) + Statistics.chiSquareProbability(d, n)) / 2.0);
        this.stream.printf("2(lnL1-lnL0)      = %6.4f", d);
        if (d2 == 1.0) {
            this.stream.println("\tP-value > 0.999999");
        } else if (d2 < 1.0E-6) {
            this.stream.println("\tP-value < 1.0E-6");
        } else {
            this.stream.printf("\tP-value = %6.4f\n", d2);
        }
        return d2;
    }
}

