/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.selection;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.selection.InformationCriterion;
import java.util.Random;

public class AICc
extends InformationCriterion {
    public AICc(boolean bl, boolean bl2, boolean bl3, double d) {
        super(bl, bl2, bl3, d);
    }

    @Override
    public void compute() {
        int n;
        double[] dArray = new double[this.options.getNumModels()];
        double d = AICc.computeAicc(this.models[0], this.options);
        if (this.doCheckAgainstULK) {
            this.unconstrainedModel.setAICc(this.computeSingle(this.unconstrainedModel));
        }
        this.minModel = this.models[0];
        for (Model model : this.models) {
            model.setAICc(AICc.computeAicc(model, this.options));
            if (model.getAICc() < d) {
                d = model.getAICc();
                this.minModel = model;
            }
            if (!this.doCheckAgainstULK) continue;
            model.setUAICcd(model.getAICc() - this.unconstrainedModel.getAICc());
        }
        double d2 = 0.0;
        for (n = 0; n < this.numModels; ++n) {
            this.models[n].setAICcd(this.models[n].getAICc() - this.minModel.getAICc());
            d2 += Math.exp(-0.5 * this.models[n].getAICcd());
        }
        for (n = 0; n < this.numModels; ++n) {
            if (this.models[n].getAICcd() > 1000.0) {
                this.models[n].setAICcw(0.0);
            } else {
                this.models[n].setAICcw(Math.exp(-0.5 * this.models[n].getAICcd()) / d2);
            }
            dArray[n] = this.models[n].getAICc();
            this.order[n] = n;
        }
        boolean bl = false;
        int n2 = 1;
        while (!bl) {
            bl = true;
            for (n = 0; n < this.numModels - n2; ++n) {
                if (!(dArray[n] > dArray[n + 1])) continue;
                double d3 = dArray[n + 1];
                dArray[n + 1] = dArray[n];
                dArray[n] = d3;
                int n3 = this.order[n + 1];
                this.order[n + 1] = this.order[n];
                this.order[n] = n3;
                bl = false;
            }
            ++n2;
        }
        double d4 = 0.0;
        for (n = 0; n < this.numModels; ++n) {
            this.models[this.order[n]].setCumAICcw(d4 += this.models[this.order[n]].getAICcw());
        }
        this.buildConfidenceInterval();
        if (this.doImportances || this.doModelAveraging) {
            this.parameterImportance();
        }
        if (this.doModelAveraging) {
            this.averageModels();
        }
    }

    @Override
    public double computeSingle(Model model) {
        return AICc.computeAicc(model, this.options);
    }

    public static double computeAicc(Model model, ApplicationOptions applicationOptions) {
        int n = applicationOptions.countBLasParameters ? model.getK() : model.getK() - applicationOptions.getNumBranches();
        double d = 2.0 * (model.getLnL() + (double)n) + (double)(2 * n * (n + 1)) / (applicationOptions.getSampleSize() - (double)n - 1.0);
        return d;
    }

    public static double computeAicc(double d, int n, ApplicationOptions applicationOptions) {
        int n2 = applicationOptions.countBLasParameters ? n : n - applicationOptions.getNumBranches();
        double d2 = 2.0 * (d + (double)n2) + (double)(2 * n2 * (n2 + 1)) / (applicationOptions.getSampleSize() - (double)n2 - 1.0);
        System.out.println("AICC 2 IS " + d2);
        return d2;
    }

    @Override
    protected void printHeader(TextOutputStream textOutputStream) {
        textOutputStream.println("\n\n\n---------------------------------------------------------------");
        textOutputStream.println("*                                                             *");
        textOutputStream.println("*        CORRECTED AKAIKE INFORMATION CRITERION (AICc)        *");
        textOutputStream.println("*                                                             *");
        textOutputStream.println("---------------------------------------------------------------");
        textOutputStream.println(" ");
        textOutputStream.println(" Sample size: " + this.options.getSampleSize());
    }

    @Override
    protected void printFooter(TextOutputStream textOutputStream) {
        textOutputStream.println("-lnL:\tnegative log likelihod");
        textOutputStream.println(" K:\tnumber of estimated parameters");
        textOutputStream.println(" AICc:\tCorrected Akaike Information Criterion");
        textOutputStream.println(" delta:\tAICc difference");
        textOutputStream.println(" weight:\tAICc weight");
        textOutputStream.println(" cumWeight:\tcumulative AICc weight");
    }

    @Override
    public void buildConfidenceInterval() {
        Model model = this.models[0];
        this.cumWeight = 0.0;
        if (this.confidenceInterval >= 1.0) {
            for (int i = 0; i < this.numModels; ++i) {
                model = this.models[this.order[i]];
                model.setInAICcinterval(true);
                this.confidenceModels.add(model);
            }
            this.cumWeight = 1.0;
        } else {
            for (int i = 0; i < this.numModels && (model = this.models[this.order[i]]).getCumAICcw() <= this.confidenceInterval; ++i) {
                model.setInAICcinterval(true);
                this.confidenceModels.add(model);
                this.cumWeight += model.getAICcw();
            }
            double d = (model.getCumAICcw() - this.confidenceInterval) / model.getAICcw();
            double d2 = 1.0 - d;
            Random random = new Random();
            double d3 = random.nextDouble();
            if (d3 <= d2) {
                model.setInAICcinterval(true);
                if (!this.confidenceModels.contains(model)) {
                    this.confidenceModels.add(model);
                }
                this.cumWeight += model.getAICcw();
            } else {
                model.setInAICcinterval(false);
            }
        }
    }

    @Override
    public double getMinModelValue() {
        return this.minModel.getAICc();
    }

    @Override
    public double getMinModelWeight() {
        return this.minModel.getAICcw();
    }

    @Override
    public double getValue(Model model) {
        return model.getAICc();
    }

    @Override
    public double getWeight(Model model) {
        return model.getAICcw();
    }

    @Override
    public double getDelta(Model model) {
        return model.getAICcd();
    }

    @Override
    public double getUDelta(Model model) {
        return model.getUAICcd();
    }

    @Override
    public double setUDelta(Model model) {
        model.setUAICcd(AICc.computeAicc(model.getLnLIgnoringGaps(), model.getK(), this.options) - AICc.computeAicc(this.unconstrainedModel.getLnL(), this.unconstrainedModel.getK(), this.options));
        return model.getUAICcd();
    }

    @Override
    public double getCumWeight(Model model) {
        return model.getCumAICcw();
    }

    @Override
    public int getType() {
        return 2;
    }
}

