/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.observer;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.observer.ProgressInfo;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;

public class ConsoleProgressObserver
implements Observer {
    private TextOutputStream stream;
    private long startTime = System.currentTimeMillis();
    private int totalModels;
    private int completedModels = 0;
    private boolean threadScheduling;
    private ApplicationOptions options;

    public ConsoleProgressObserver(ApplicationOptions applicationOptions) {
        this.stream = ModelTest.getMainConsole();
        this.threadScheduling = applicationOptions.threadScheduling;
        this.options = applicationOptions;
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        if (object != null) {
            ProgressInfo progressInfo = (ProgressInfo)object;
            switch (progressInfo.getType()) {
                case 1: {
                    this.stream.println(" ");
                    this.stream.println("Estimating a BIONJ-JC tree ... ");
                    break;
                }
                case 2: {
                    this.stream.println("OK");
                    this.stream.println(progressInfo.getModel().getName() + " tree: " + progressInfo.getModel().getTreeString());
                    break;
                }
                case 3: {
                    this.totalModels = this.options.getNumModels();
                    this.stream.println(" ");
                    this.stream.println(" ");
                    this.stream.println("::Progress::");
                    this.stream.println(" ");
                    this.stream.println("Model \t\t Exec. Time \t Total Time \t -lnL");
                    this.stream.println("-------------------------------------------------------------------------");
                    break;
                }
                case 10: {
                    this.stream.println("[Heuristic search] Optimizing " + progressInfo.getModel().getName() + " model");
                    break;
                }
                case 11: {
                    this.stream.println("[Heuristic search] Starting model filtering");
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    ++this.completedModels;
                    this.stream.print(progressInfo.getModel().getName() + "\t");
                    double d = progressInfo.getValue() == 1 ? progressInfo.getModel().getLnL() : progressInfo.getModel().getLnLIgnoringGaps();
                    if (progressInfo.getModel().getName().length() < 8) {
                        this.stream.print("\t");
                    }
                    this.stream.print(progressInfo.getMessage() + "\t" + Utilities.calculateRuntime(this.startTime, System.currentTimeMillis()) + "\t" + String.format(Locale.ENGLISH, "%13.4f", d));
                    if (ModelTest.MPJ_RUN && this.threadScheduling) {
                        this.stream.println(" ");
                        break;
                    }
                    if (progressInfo.isHeuristicSearch() && progressInfo.getValue() == 1) {
                        this.stream.println("\t [" + progressInfo.getHeuristicStage() + "/6] (" + this.completedModels + "/" + progressInfo.getNumModelsInStage() + ")");
                        if (this.completedModels != progressInfo.getNumModelsInStage()) break;
                        this.completedModels = 0;
                        break;
                    }
                    this.stream.println("\t (" + this.completedModels + "/" + this.totalModels + ")");
                    break;
                }
                case 8: {
                    this.totalModels = progressInfo.getValue();
                    this.completedModels = 0;
                    this.startTime = System.currentTimeMillis();
                    this.stream.println(" ");
                    this.stream.println(" ");
                    this.stream.println("Some models should be reoptimized for checking lnL against the unconstrained likelihood");
                    this.stream.println(" ");
                    this.stream.println("Model \t\t Exec. Time \t Total Time\t-lnL w/o gaps");
                    this.stream.println("-------------------------------------------------------------------------");
                    break;
                }
                case 9: {
                    this.stream.println(" ");
                    this.stream.println("  Unconstrained -lnL       = " + this.options.getUnconstrainedLnL());
                    this.stream.println("  Number of patterns found = " + this.options.getNumPatterns());
                    this.stream.println(" ");
                    break;
                }
                case 20: {
                    this.stream.println(" ");
                    this.stream.println("Computation of likelihood scores discontinued ...");
                    break;
                }
                case 21: {
                    this.stream.println(progressInfo.getMessage());
                    this.stream.println(" ");
                    this.stream.println("Computation of likelihood scores discontinued ...");
                    System.exit(-1);
                    break;
                }
                case 22: {
                    this.stream.println("");
                    this.stream.println("ERROR: PhyML binary does not exists: " + progressInfo.getMessage());
                    this.stream.println("");
                    ModelTest.finalize(22);
                    break;
                }
                case 23: {
                    this.stream.println("");
                    this.stream.println("ERROR: PhyML binary does not have execution permission: " + progressInfo.getMessage());
                    this.stream.println("");
                    ModelTest.finalize(23);
                    break;
                }
                case 6: {
                    this.stream.println(" ");
                    for (Model model : ModelTest.getCandidateModels()) {
                        model.print(ModelTest.getMainConsole());
                        ModelTest.getMainConsole().println(" ");
                    }
                    if (this.options.isAmbiguous()) {
                        this.stream.println("  Best-fit models should be reoptimized for comparison with unconstrained likelihood");
                    } else {
                        this.stream.println("  Unconstrained -lnL       = " + this.options.getUnconstrainedLnL());
                        this.stream.println("  Number of patterns found = " + this.options.getNumPatterns());
                    }
                    this.stream.println(" ");
                    this.stream.println("Computation of likelihood scores completed. It took " + Utilities.calculateRuntime(this.startTime, System.currentTimeMillis()) + ".");
                    this.stream.println(" ");
                }
            }
        }
    }
}

