/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.model;

import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import java.io.PushbackReader;
import java.io.Serializable;
import java.io.StringReader;
import pal.tree.ReadTree;
import pal.tree.Tree;
import pal.tree.TreeParseException;

public class Model
implements Serializable {
    private static final long serialVersionUID = 4173257281316945987L;
    private String name;
    private String partition;
    private String treeString;
    private Tree tree;
    private int id;
    private int K;
    private int numTi;
    private int numTv;
    private int numGammaCat;
    private boolean pF;
    private boolean pT;
    private boolean pR;
    private boolean pI;
    private boolean pG;
    private boolean pV;
    private boolean isInAICinterval;
    private boolean isInAICcinterval;
    private boolean isInBICinterval;
    private boolean isInDTinterval;
    private double lnL;
    private double unconstrainedLnL;
    private double lnLIgnoringGaps;
    private double AIC;
    private double AICd;
    private double AICw;
    private double cumAICw;
    private double uAICd;
    private double AICc;
    private double AICcd;
    private double AICcw;
    private double cumAICcw;
    private double uAICcd;
    private double BIC;
    private double BICd;
    private double BICw;
    private double cumBICw;
    private double uBICd;
    private double DT;
    private double DTd;
    private double DTw;
    private double cumDTw;
    private double fA;
    private double fG;
    private double fC;
    private double fT;
    private double titv;
    private double kappa;
    private double Ra;
    private double Rb;
    private double Rc;
    private double Rd;
    private double Re;
    private double Rf;
    private double pinv;
    private double shape;
    private long computationTime;

    public Model(int n, String string, String string2, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n3, int n4) {
        this.id = n;
        this.name = string;
        this.partition = string2;
        this.K = n2;
        this.pF = bl;
        this.pT = bl2;
        this.pV = bl3;
        this.pR = bl4;
        this.pI = bl5;
        this.pG = bl6;
        this.numTi = n3;
        this.numTv = n4;
        this.lnL = 0.0;
        this.pinv = 0.0;
        this.shape = 9999.0;
    }

    public Model(int n, String string, String string2, int n2) {
        this.id = n;
        this.name = string;
        this.partition = string2;
        this.K = n2;
        this.pF = false;
        this.pT = false;
        this.pV = false;
        this.pR = false;
        this.pI = false;
        this.pG = false;
        this.numTi = 0;
        this.numTv = 0;
        this.lnL = 0.0;
        this.pinv = 0.0;
        this.shape = 9999.0;
    }

    public void print(TextOutputStream textOutputStream) {
        textOutputStream.println("   Model = " + this.getName());
        textOutputStream.println("   partition = " + this.getPartition());
        if (this.getLnL() == 0.0) {
            textOutputStream.println(" OPTIMIZATION FAILED!");
        } else {
            textOutputStream.printf("   -lnL = %.4f", this.getLnL());
            textOutputStream.printf("\n   K = %d", this.getK());
            if (this.ispF()) {
                textOutputStream.printf("\n   freqA = %5.4f ", this.getfA());
                textOutputStream.printf("\n   freqC = %5.4f ", this.getfC());
                textOutputStream.printf("\n   freqG = %5.4f ", this.getfG());
                textOutputStream.printf("\n   freqT = %5.4f ", this.getfT());
            }
            if (this.ispT()) {
                textOutputStream.printf("\n   kappa = %.4f", this.getKappa());
                textOutputStream.printf(" (ti/tv = %.4f)", this.getTitv());
            }
            if (this.ispR()) {
                textOutputStream.printf("\n   R(a) [AC] =  %.4f", this.getRa());
                textOutputStream.printf("\n   R(b) [AG] =  %.4f", this.getRb());
                textOutputStream.printf("\n   R(c) [AT] =  %.4f", this.getRc());
                textOutputStream.printf("\n   R(d) [CG] =  %.4f", this.getRd());
                textOutputStream.printf("\n   R(e) [CT] =  %.4f", this.getRe());
                textOutputStream.printf("\n   R(f) [GT] =  %.4f", 1.0);
            }
            if (this.ispI()) {
                textOutputStream.printf("\n   p-inv = %5.4f", this.getPinv());
            }
            if (this.ispG()) {
                textOutputStream.printf("\n   gamma shape = %6.4f", this.getShape());
            }
            textOutputStream.println(" ");
        }
    }

    public String printForTesting() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName() + " ");
        stringBuilder.append(this.ispF() ? this.getfA() + " " + this.getfC() + " " + this.getfG() + " " + this.getfT() + " " : "NA NA NA NA ");
        stringBuilder.append(this.ispT() ? this.getKappa() + " " + this.getTitv() + " " : "NA NA ");
        stringBuilder.append(this.ispR() ? this.getRa() + " " + this.getRb() + " " + this.getRc() + " " + this.getRd() + " " + this.getRe() + " " + this.getRf() + " " : "NA NA NA NA NA NA ");
        stringBuilder.append(this.ispI() ? this.getPinv() + " " : "NA ");
        stringBuilder.append(this.ispG() ? this.getShape() + " " : "NA ");
        stringBuilder.append(this.getPartition());
        return stringBuilder.toString();
    }

    public void setCumBICw(double d) {
        this.cumBICw = d;
    }

    public double getCumBICw() {
        return this.cumBICw;
    }

    public void setLnL(double d) {
        this.lnL = d;
    }

    public double getLnL() {
        return this.lnL;
    }

    public void setLnLIgnoringGaps(double d) {
        this.lnLIgnoringGaps = d;
    }

    public double getLnLIgnoringGaps() {
        return this.lnLIgnoringGaps;
    }

    public double getUnconstrainedLnL() {
        return this.unconstrainedLnL;
    }

    public void setUnconstrainedLnL(double d) {
        this.unconstrainedLnL = d;
    }

    public void setAIC(double d) {
        this.AIC = d;
    }

    public double getAIC() {
        return this.AIC;
    }

    public void setAICd(double d) {
        this.AICd = d;
    }

    public double getAICd() {
        return this.AICd;
    }

    public void setAICw(double d) {
        this.AICw = d;
    }

    public double getAICw() {
        return this.AICw;
    }

    public void setUAICd(double d) {
        this.uAICd = d;
    }

    public double getUAICd() {
        return this.uAICd;
    }

    public void setCumAICw(double d) {
        this.cumAICw = d;
    }

    public double getCumAICw() {
        return this.cumAICw;
    }

    public void setAICc(double d) {
        this.AICc = d;
    }

    public double getAICc() {
        return this.AICc;
    }

    public void setAICcd(double d) {
        this.AICcd = d;
    }

    public double getAICcd() {
        return this.AICcd;
    }

    public void setAICcw(double d) {
        this.AICcw = d;
    }

    public double getAICcw() {
        return this.AICcw;
    }

    public void setCumAICcw(double d) {
        this.cumAICcw = d;
    }

    public void setUAICcd(double d) {
        this.uAICcd = d;
    }

    public double getUAICcd() {
        return this.uAICcd;
    }

    public double getCumAICcw() {
        return this.cumAICcw;
    }

    public void setBICd(double d) {
        this.BICd = d;
    }

    public double getBICd() {
        return this.BICd;
    }

    public void setBIC(double d) {
        this.BIC = d;
    }

    public double getBIC() {
        return this.BIC;
    }

    public void setBICw(double d) {
        this.BICw = d;
    }

    public double getBICw() {
        return this.BICw;
    }

    public void setUBICd(double d) {
        this.uBICd = d;
    }

    public double getUBICd() {
        return this.uBICd;
    }

    public void setDT(double d) {
        this.DT = d;
    }

    public double getDT() {
        return this.DT;
    }

    public void setCumDTw(double d) {
        this.cumDTw = d;
    }

    public double getCumDTw() {
        return this.cumDTw;
    }

    public void setDTw(double d) {
        this.DTw = d;
    }

    public double getDTw() {
        return this.DTw;
    }

    public void setDTd(double d) {
        this.DTd = d;
    }

    public double getDTd() {
        return this.DTd;
    }

    public String getName() {
        return this.name;
    }

    public void setPartition(String string) {
        this.partition = string;
    }

    public String getPartition() {
        return this.partition;
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setTreeString(String string) throws TreeParseException {
        this.treeString = string;
        if (string == null) {
            throw new TreeParseException("Attempting to set a null tree");
        }
        StringReader stringReader = new StringReader(string);
        this.tree = new ReadTree(new PushbackReader(stringReader));
    }

    public String getTreeString() {
        return this.treeString;
    }

    public void setfG(double d) {
        this.fG = d;
    }

    public double getfG() {
        return this.fG;
    }

    public void setfA(double d) {
        this.fA = d;
    }

    public double getfA() {
        return this.fA;
    }

    public void setfC(double d) {
        this.fC = d;
    }

    public double getfC() {
        return this.fC;
    }

    public void setfT(double d) {
        this.fT = d;
    }

    public double getfT() {
        return this.fT;
    }

    public void setTitv(double d) {
        this.titv = d;
    }

    public double getTitv() {
        return this.titv;
    }

    public void setKappa(double d) {
        this.kappa = d;
    }

    public double getKappa() {
        return this.kappa;
    }

    public void setRa(double d) {
        this.Ra = d;
    }

    public double getRa() {
        return this.Ra;
    }

    public void setShape(double d) {
        this.shape = d;
    }

    public double getShape() {
        return this.shape;
    }

    public void setPinv(double d) {
        this.pinv = d;
    }

    public double getPinv() {
        return this.pinv;
    }

    public void setRf(double d) {
        this.Rf = d;
    }

    public double getRf() {
        return this.Rf;
    }

    public void setRe(double d) {
        this.Re = d;
    }

    public double getRe() {
        return this.Re;
    }

    public void setRd(double d) {
        this.Rd = d;
    }

    public double getRd() {
        return this.Rd;
    }

    public void setRc(double d) {
        this.Rc = d;
    }

    public double getRc() {
        return this.Rc;
    }

    public void setRb(double d) {
        this.Rb = d;
    }

    public double getRb() {
        return this.Rb;
    }

    public int getId() {
        return this.id;
    }

    public void setNumGammaCat(int n) {
        this.numGammaCat = n;
    }

    public int getNumGammaCat() {
        return this.numGammaCat;
    }

    public int getK() {
        return this.K;
    }

    public int getNumTi() {
        return this.numTi;
    }

    public boolean ispV() {
        return this.pV;
    }

    public boolean ispG() {
        return this.pG;
    }

    public boolean ispI() {
        return this.pI;
    }

    public boolean ispR() {
        return this.pR;
    }

    public boolean ispT() {
        return this.pT;
    }

    public boolean ispF() {
        return this.pF;
    }

    public void setInDTinterval(boolean bl) {
        this.isInDTinterval = bl;
    }

    public boolean isInDTinterval() {
        return this.isInDTinterval;
    }

    public void setInBICinterval(boolean bl) {
        this.isInBICinterval = bl;
    }

    public boolean isInBICinterval() {
        return this.isInBICinterval;
    }

    public void setInAICcinterval(boolean bl) {
        this.isInAICcinterval = bl;
    }

    public boolean isInAICcinterval() {
        return this.isInAICcinterval;
    }

    public void setInAICinterval(boolean bl) {
        this.isInAICinterval = bl;
    }

    public boolean isInAICinterval() {
        return this.isInAICinterval;
    }

    public int getNumTv() {
        return this.numTv;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.pF ? 1231 : 1237);
        n = 31 * n + (this.pG ? 1231 : 1237);
        n = 31 * n + (this.pI ? 1231 : 1237);
        n = 31 * n + (this.partition == null ? 0 : this.partition.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Model model = (Model)object;
        if (this.pF != model.pF) {
            return false;
        }
        if (this.pG != model.pG) {
            return false;
        }
        if (this.pI != model.pI) {
            return false;
        }
        return !(this.partition == null ? model.partition != null : !this.partition.equals(model.partition));
    }

    public long getComputationTime() {
        return this.computationTime;
    }

    public void setComputationTime(long l) {
        this.computationTime = l;
    }

    public void update(Model model) {
        if (this.equals(model)) {
            this.lnL = model.lnL;
            this.numGammaCat = model.numGammaCat;
            this.shape = model.shape;
            this.pinv = model.pinv;
            this.kappa = model.kappa;
            this.treeString = model.treeString;
            this.tree = model.tree;
            this.computationTime = model.computationTime;
        }
    }
}

