/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.io;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.io.TextInputStream;
import iubio.readseq.BioseqFormats;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.Readseq;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public abstract class AlignmentReader {
    private static ApplicationOptions options = ApplicationOptions.getInstance();

    public static void getHeader(String string) {
        try {
            TextInputStream textInputStream = new TextInputStream(string);
            String string2 = textInputStream.readLine();
            textInputStream.close();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            options.setNumTaxa(Integer.parseInt(stringTokenizer.nextToken()));
            options.setNumSites(Integer.parseInt(stringTokenizer.nextToken()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(new JFrame(), "Could not read the input alignment", "jModelTest error", 0);
        }
        if (options.getNumTaxa() <= 4) {
            JOptionPane.showMessageDialog(new JFrame(), "The number of taxa does not seem to be correct: " + options.getNumTaxa(), "jModelTest error", 0);
        }
        if (options.getNumSites() <= 1) {
            JOptionPane.showMessageDialog(new JFrame(), "The number of sites does not seem to be correct: " + options.getNumTaxa(), "jModelTest error", 0);
        }
    }

    public static boolean readDataFile(File file, File file2) {
        boolean bl = false;
        try {
            int n = BioseqFormats.formatFromName((String)"phylip");
            BioseqWriterIface bioseqWriterIface = BioseqFormats.newWriter((int)n);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            bioseqWriterIface.setOutput((OutputStream)fileOutputStream);
            bioseqWriterIface.writeHeader();
            Readseq readseq = new Readseq();
            readseq.setInputObject((Object)file.getAbsolutePath());
            if (readseq.isKnownFormat() && readseq.readInit() && readseq.getFormat() != 13) {
                readseq.readTo(bioseqWriterIface);
                bioseqWriterIface.writeTrailer();
                TextInputStream textInputStream = new TextInputStream(file2.getAbsolutePath());
                String string = textInputStream.readLine();
                textInputStream.close();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                options.setNumTaxa(Integer.parseInt(stringTokenizer.nextToken()));
                options.setNumSites(Integer.parseInt(stringTokenizer.nextToken()));
                options.setNumBranches(2 * options.getNumTaxa() - 3);
                bl = true;
                if (options.getNumTaxa() < 4) {
                    JOptionPane.showMessageDialog(new JFrame(), "The number of taxa (" + options.getNumTaxa() + ") does not seem to be correct!", "jModeltest error", 0);
                    bl = false;
                }
                if (options.getNumSites() <= 1) {
                    JOptionPane.showMessageDialog(new JFrame(), "The number of sites (" + options.getNumSites() + ") does not seem to be correct!", "jModeltest error", 0);
                    bl = false;
                }
            } else {
                JOptionPane.showMessageDialog(new JFrame(), "Cannot read or import the file: " + file.getName(), "jModeltest error", 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }
}

