/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.gui;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.gui.JModelTestFrame;
import es.uvigo.darwin.jmodeltest.gui.XManager;
import es.uvigo.darwin.jmodeltest.selection.AIC;
import es.uvigo.darwin.jmodeltest.selection.AICc;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.BorderUIResource;

public class Frame_AIC
extends JModelTestFrame {
    private static final long serialVersionUID = 201104031100L;
    private JPanel panelAICSettings = new JPanel();
    private JTextField textTaxaAIC = new JTextField();
    private JTextField textSizeAICc = new JTextField();
    private JButton runButtonAIC = new JButton();
    private JButton cancelButtonAIC = new JButton();
    private JButton buttonDefaultAIC = new JButton();
    private JCheckBox checkBoxAICc = new JCheckBox();
    private JCheckBox checkBoxPAUPblock = new JCheckBox();
    private JCheckBox checkBoxAveraging = new JCheckBox();
    private JCheckBox checkBoxImportance = new JCheckBox();
    private JSlider sliderInterval = new JSlider();
    private AIC myAIC;
    private AICc myAICc;
    private boolean mShown = false;

    public void initComponents() throws Exception {
        this.panelAICSettings.setSize(490, 240);
        this.panelAICSettings.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "AIC Settings", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.panelAICSettings.setLocation(10, 10);
        this.panelAICSettings.setVisible(true);
        this.panelAICSettings.setLayout(null);
        this.runButtonAIC.setVisible(true);
        this.runButtonAIC.setSize(190, 40);
        this.runButtonAIC.setText("Do AIC calculations");
        this.runButtonAIC.setLocation(280, 190);
        this.getRootPane().setDefaultButton(this.runButtonAIC);
        this.buttonDefaultAIC.setVisible(true);
        this.buttonDefaultAIC.setSize(141, 40);
        this.buttonDefaultAIC.setText("Default Settings");
        this.buttonDefaultAIC.setLocation(10, 190);
        this.cancelButtonAIC.setVisible(true);
        this.cancelButtonAIC.setSize(110, 40);
        this.cancelButtonAIC.setText("Cancel");
        this.cancelButtonAIC.setLocation(160, 190);
        this.checkBoxAICc.setVisible(true);
        this.checkBoxAICc.setSize(170, 20);
        this.checkBoxAICc.setText("Use AICc correction");
        this.checkBoxAICc.setLocation(30, 30);
        this.checkBoxAICc.setSelected(false);
        this.textSizeAICc.setEnabled(false);
        this.textSizeAICc.setToolTipText("Enter the sample size you want to use for the AICc correction and click RETURN. By default this is the number of sites in the alignment");
        this.textSizeAICc.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "Sample size", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.textSizeAICc.setVisible(true);
        this.textSizeAICc.setSize(170, 40);
        this.textSizeAICc.setText(Utilities.format(this.options.getSampleSize(), 10, 4, false));
        this.textSizeAICc.setHorizontalAlignment(4);
        this.textSizeAICc.setLocation(300, 20);
        this.checkBoxImportance.setVisible(true);
        this.checkBoxImportance.setSize(260, 20);
        this.checkBoxImportance.setText("Calculate parameter importances");
        this.checkBoxImportance.setLocation(30, 70);
        this.checkBoxImportance.setSelected(true);
        this.checkBoxAveraging.setVisible(true);
        this.checkBoxAveraging.setSize(260, 20);
        this.checkBoxAveraging.setText("Do model averaging");
        this.checkBoxAveraging.setLocation(30, 110);
        this.checkBoxAveraging.setSelected(true);
        this.checkBoxPAUPblock.setVisible(true);
        this.checkBoxPAUPblock.setSize(260, 20);
        this.checkBoxPAUPblock.setText("Write PAUP* block");
        this.checkBoxPAUPblock.setLocation(30, 150);
        this.checkBoxPAUPblock.setSelected(false);
        this.checkBoxPAUPblock.setToolTipText("Writes a block of PAUP* commands implementing the selected model");
        this.sliderInterval.setVisible(true);
        this.sliderInterval.setToolTipText("Set the confidence interval for model averaging and/or parameter importance");
        this.sliderInterval.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "Confidence interval = 100%", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.sliderInterval.setSize(170, 70);
        this.sliderInterval.setLocation(300, 105);
        this.sliderInterval.setMinimum(0);
        this.sliderInterval.setMaximum(100);
        this.sliderInterval.setValue(100);
        this.sliderInterval.setMajorTickSpacing(20);
        this.sliderInterval.setMinorTickSpacing(5);
        this.sliderInterval.setPaintTicks(true);
        this.sliderInterval.setPaintLabels(true);
        this.sliderInterval.setEnabled(true);
        this.sliderInterval.setFont(XManager.FONT_SLIDER);
        this.setLocation(281, 80);
        this.getContentPane().setLayout(null);
        this.setTitle("Akaike Information Criterion (AIC) Settings");
        this.panelAICSettings.add(this.runButtonAIC);
        this.panelAICSettings.add(this.buttonDefaultAIC);
        this.panelAICSettings.add(this.cancelButtonAIC);
        this.panelAICSettings.add(this.checkBoxAICc);
        this.panelAICSettings.add(this.textTaxaAIC);
        this.panelAICSettings.add(this.textSizeAICc);
        this.panelAICSettings.add(this.checkBoxAveraging);
        this.panelAICSettings.add(this.checkBoxImportance);
        this.panelAICSettings.add(this.checkBoxPAUPblock);
        this.panelAICSettings.add(this.sliderInterval);
        this.getContentPane().add(this.panelAICSettings);
        this.setSize(510, 280);
        this.setResizable(false);
        this.checkBoxAICc.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Frame_AIC.this.jCheckBoxAICcStateChanged(changeEvent);
            }
        });
        this.checkBoxAveraging.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Frame_AIC.this.jCheckBoxAveragingStateChanged(changeEvent);
            }
        });
        this.checkBoxImportance.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Frame_AIC.this.jCheckBoxImportanceStateChanged(changeEvent);
            }
        });
        this.sliderInterval.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Frame_AIC.this.JSliderIntervalStateChanged(changeEvent);
            }
        });
        this.buttonDefaultAIC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_AIC.this.JButtonDefaultAICActionPerformed(actionEvent);
            }
        });
        this.cancelButtonAIC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_AIC.this.CancelButtonAICActionPerformed(actionEvent);
            }
        });
        this.runButtonAIC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_AIC.this.RunButtonAICActionPerformed(actionEvent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Frame_AIC.this.thisWindowClosing(windowEvent);
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            this.setSize(dimension);
            Component[] componentArray = this.getLayeredPane().getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
            for (int i = 0; i < componentArray.length; ++i) {
                Point point = componentArray[i].getLocation();
                point.move(point.x, point.y + n);
                componentArray[i].setLocation(point);
            }
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void jCheckBoxAICcStateChanged(ChangeEvent changeEvent) {
        if (this.checkBoxAICc.isSelected()) {
            this.textSizeAICc.setEnabled(true);
            this.runButtonAIC.setText("Do AICc calculations");
        } else {
            this.textSizeAICc.setEnabled(false);
            this.runButtonAIC.setText("Do AIC calculations");
        }
    }

    public void jCheckBoxImportanceStateChanged(ChangeEvent changeEvent) {
        if (this.checkBoxImportance.isSelected()) {
            this.sliderInterval.setEnabled(true);
        } else if (!this.checkBoxAveraging.isSelected()) {
            this.sliderInterval.setEnabled(false);
        }
    }

    public void jCheckBoxAveragingStateChanged(ChangeEvent changeEvent) {
        if (this.checkBoxAveraging.isSelected()) {
            this.sliderInterval.setEnabled(true);
        } else if (!this.checkBoxImportance.isSelected()) {
            this.sliderInterval.setEnabled(false);
        }
    }

    public void JSliderIntervalStateChanged(ChangeEvent changeEvent) {
        this.sliderInterval.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "Confidence interval = " + this.sliderInterval.getValue() + "%", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
    }

    public void JButtonDefaultAICActionPerformed(ActionEvent actionEvent) {
        this.checkBoxAICc.setSelected(false);
        this.textSizeAICc.setEnabled(false);
        this.runButtonAIC.setText("Do AIC calculations");
        ApplicationOptions.getInstance().countBLasParameters = true;
        XManager.getInstance().selectedMenuResultsBLasParameters(true);
        this.checkBoxPAUPblock.setSelected(false);
        this.checkBoxAveraging.setSelected(true);
        this.checkBoxImportance.setSelected(true);
        this.sliderInterval.setValue(100);
    }

    public void CancelButtonAICActionPerformed(ActionEvent actionEvent) {
        try {
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void RunButtonAICActionPerformed(ActionEvent actionEvent) {
        try {
            this.setVisible(false);
            this.dispose();
            boolean bl = this.checkBoxPAUPblock.isSelected();
            this.options.writePAUPblock |= bl;
            boolean bl2 = this.checkBoxImportance.isSelected();
            boolean bl3 = this.checkBoxAveraging.isSelected();
            double d = (double)this.sliderInterval.getValue() / 100.0;
            if (this.checkBoxAICc.isSelected()) {
                this.myAICc = new AICc(bl, bl2, bl3, d);
                this.myAICc.compute();
                this.myAICc.print(ModelTest.getCurrentOutStream());
                ModelTest.setMyAICc(this.myAICc);
                this.options.doAICc = this.myAICc != null;
                XManager.getInstance().resultsFrame.enablePane(2);
                XManager.getInstance().resultsFrame.populate(2);
            } else {
                this.myAIC = new AIC(bl, bl2, bl3, d);
                this.myAIC.compute();
                this.myAIC.print(ModelTest.getCurrentOutStream());
                ModelTest.setMyAIC(this.myAIC);
                this.options.doAIC = this.myAIC != null;
                XManager.getInstance().resultsFrame.enablePane(1);
                XManager.getInstance().resultsFrame.populate(1);
            }
            XManager.getInstance().enableMenuAveraging(!this.options.fixedTopology);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

