/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.exe;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.exe.Distributor;
import es.uvigo.darwin.jmodeltest.exe.PhymlSingleModel;
import es.uvigo.darwin.jmodeltest.exe.RunPhyml;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import mpi.MPI;
import mpi.Request;

public class RunPhymlMPJ
extends RunPhyml {
    private List<Model> myModels = new ArrayList<Model>();
    volatile Model rootModel = null;
    volatile boolean rootModelRequest = false;

    public RunPhymlMPJ(Observer observer, ApplicationOptions applicationOptions, Model[] modelArray) {
        super(observer, applicationOptions, modelArray);
    }

    public void distribute() {
        List<Model> list = Arrays.asList(this.models);
        Distributor distributor = new Distributor(list, this, ModelTest.MPJ_ME, ModelTest.MPJ_SIZE);
        distributor.addObserver(this.progress);
        Thread thread = new Thread(distributor);
        thread.start();
        this.request();
        for (Model model : ModelTest.getCandidateModels()) {
            model.update(list.get(list.indexOf(model)));
        }
        this.notifyObservers(6, this.models.length, null, null);
    }

    public void request() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Model[] modelArray = new Model[1];
        while (true) {
            Object object;
            Model[] modelArray2 = null;
            Model model = null;
            if (ModelTest.MPJ_ME > 0) {
                object = MPI.COMM_WORLD.Isend((Object)modelArray, 0, 1, MPI.OBJECT, 0, 1);
                modelArray2 = new Model[1];
                object.Wait();
                Request request = MPI.COMM_WORLD.Irecv((Object)modelArray2, 0, 1, MPI.OBJECT, 0, 2);
                request.Wait();
                model = modelArray2[0];
            } else {
                this.rootModelRequest = true;
                while (this.rootModelRequest) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new ProtTestInternalException("Thread interrupted");
                    }
                }
                model = this.rootModel;
            }
            if (model == null) break;
            this.myModels.add(model);
            object = new PhymlSingleModel(model, 0, false, false, this.options);
            ((Observable)object).addObserver(this);
            if (!((PhymlSingleModel)object).compute()) {
                throw new ProtTestInternalException("Optimization error");
            }
            arrayList.add(object);
            modelArray[0] = ((PhymlSingleModel)object).getModel();
        }
    }

    @Override
    protected Object doPhyml() {
        return null;
    }

    @Override
    public void execute() {
        Object object;
        if (ModelTest.MPJ_ME == 0) {
            this.printSettings(ModelTest.getMainConsole());
            if (this.options.fixedTopology) {
                this.notifyObservers(1, 0, this.models[0], null);
                object = new PhymlSingleModel(this.models[0], 0, true, false, this.options);
                ((PhymlSingleModel)object).run();
                TextOutputStream textOutputStream = new TextOutputStream(this.options.getTreeFile().getAbsolutePath(), false);
                textOutputStream.print(this.models[0].getTreeString() + "\n");
                textOutputStream.close();
                this.options.setUserTree(this.models[0].getTreeString());
                this.notifyObservers(2, 0, this.models[0], null);
            }
            System.out.println("computing likelihood scores for " + this.models.length + " models with Phyml " + "3.0");
        }
        object = new ApplicationOptions[]{this.options};
        MPI.COMM_WORLD.Bcast(object, 0, 1, MPI.OBJECT, 0);
        this.options = object[0];
        ApplicationOptions.setInstance(this.options);
        if (ModelTest.MPJ_ME == 0) {
            this.notifyObservers(3, 0, this.models[0], null);
            this.distribute();
        } else {
            try {
                this.options.buildWorkFiles();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.request();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
    }
}

