/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.exe;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.exe.MultipleDistributor;
import es.uvigo.darwin.jmodeltest.exe.PhymlParallelModel;
import es.uvigo.darwin.jmodeltest.exe.PhymlSingleModel;
import es.uvigo.darwin.jmodeltest.exe.RunPhyml;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.observer.ProgressInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import mpi.MPI;
import mpi.Request;

public class RunPhymlHybrid
extends RunPhyml {
    private List<Model> myModels = new ArrayList<Model>();
    volatile Model rootModel = null;
    volatile boolean rootModelRequest = false;
    int mpjMe;
    int mpjSize;
    int maxPEs;
    int availablePEs;
    private PhymlParallelModel pme;
    private Model[] computedModels;
    private MultipleDistributor distributor;
    int[] itemsPerProc;
    int[] displs;

    public RunPhymlHybrid(Observer observer, ApplicationOptions applicationOptions, Model[] modelArray) {
        super(observer, applicationOptions, modelArray);
    }

    public RunPhymlHybrid(int n, int n2, Observer observer, ApplicationOptions applicationOptions, Model[] modelArray, int n3) {
        super(observer, applicationOptions, modelArray);
        this.mpjMe = n;
        this.mpjSize = n2;
        this.itemsPerProc = new int[n2];
        this.displs = new int[n2];
        this.availablePEs = this.maxPEs = n3;
        this.pme = new PhymlParallelModel(this.maxPEs);
        this.pme.addObserver(this);
    }

    public void distribute() {
        List<Model> list = Arrays.asList(this.models);
        this.distributor = new MultipleDistributor(list, this, ModelTest.MPJ_ME, ModelTest.MPJ_SIZE);
        this.distributor.addObserver(this.progress);
        this.notifyObservers(3, 0, this.models[0], null);
        Thread thread = new Thread(this.distributor);
        thread.start();
        this.request();
        list = Arrays.asList(this.computedModels);
        for (Model model : this.models) {
            model.update(list.get(list.indexOf(model)));
        }
        this.notifyObservers(6, this.models.length, null, null);
    }

    public void request() {
        Model[] modelArray = new Model[1];
        while (true) {
            Object object;
            Model[] modelArray2 = null;
            Model model = null;
            if (ModelTest.MPJ_ME > 0) {
                object = new int[]{this.availablePEs, this.maxPEs};
                Request request = MPI.COMM_WORLD.Isend(object, 0, 2, MPI.INT, 0, 1);
                modelArray2 = new Model[1];
                boolean[] blArray = new boolean[1];
                request.Wait();
                Request request2 = MPI.COMM_WORLD.Irecv((Object)blArray, 0, 1, MPI.BOOLEAN, 0, 3);
                request2.Wait();
                if (!blArray[0]) break;
                Request request3 = MPI.COMM_WORLD.Irecv((Object)modelArray2, 0, 1, MPI.OBJECT, 0, 2);
                request3.Wait();
                model = modelArray2[0];
            } else {
                this.rootModelRequest = true;
                while (this.rootModelRequest) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException("Thread interrupted");
                    }
                }
                model = this.rootModel;
                if (model == null) break;
            }
            if (model == null) continue;
            this.myModels.add(model);
            this.availablePEs -= MultipleDistributor.getPEs(model, this.maxPEs);
            object = new PhymlSingleModel(model, 0, false, this.options, MultipleDistributor.getPEs(model, this.maxPEs));
            this.pme.execute((PhymlSingleModel)object);
            while (this.availablePEs <= 0) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Thread interrupted");
                }
            }
            modelArray[0] = ((PhymlSingleModel)object).getModel();
        }
        while (this.pme.hasMoreTasks()) {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Thread interrupted");
            }
        }
        if (this.mpjMe > 0) {
            this.gather();
        } else {
            this.computedModels = this.gather();
        }
    }

    @Override
    protected Object doPhyml() {
        return null;
    }

    private Model[] gather() {
        int n = this.models != null ? this.models.length : 1;
        Model[] modelArray = new Model[n];
        if (this.distributor != null) {
            this.itemsPerProc = this.distributor.getItemsPerProc();
            this.displs = this.distributor.getDispls();
        }
        MPI.COMM_WORLD.Bcast((Object)this.itemsPerProc, 0, this.mpjSize, MPI.INT, 0);
        MPI.COMM_WORLD.Gatherv((Object)this.myModels.toArray(new Model[0]), 0, this.myModels.size(), MPI.OBJECT, (Object)modelArray, 0, this.itemsPerProc, this.displs, MPI.OBJECT, 0);
        return modelArray;
    }

    @Override
    public void execute() {
        Object object;
        if (ModelTest.MPJ_ME == 0) {
            this.printSettings(ModelTest.getMainConsole());
            if (this.options.fixedTopology) {
                this.notifyObservers(1, 0, this.models[0], null);
                object = new PhymlSingleModel(this.models[0], 0, true, false, this.options);
                ((PhymlSingleModel)object).run();
                TextOutputStream textOutputStream = new TextOutputStream(this.options.getTreeFile().getAbsolutePath(), false);
                textOutputStream.print(this.models[0].getTreeString() + "\n");
                textOutputStream.close();
                this.options.setUserTree(this.models[0].getTreeString());
                this.notifyObservers(2, 0, this.models[0], null);
            }
            System.out.println("computing likelihood scores for " + this.models.length + " models with Phyml " + "3.0");
        }
        object = new ApplicationOptions[]{this.options};
        MPI.COMM_WORLD.Bcast(object, 0, 1, MPI.OBJECT, 0);
        this.options = object[0];
        ApplicationOptions.setInstance(this.options);
        if (ModelTest.MPJ_ME == 0) {
            this.distribute();
        } else {
            try {
                this.options.buildWorkFiles();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.request();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        ProgressInfo progressInfo;
        if (object != null && (progressInfo = (ProgressInfo)object).getType() == 5) {
            this.availablePEs += MultipleDistributor.getPEs(progressInfo.getModel(), this.maxPEs);
        }
        this.setChanged();
        this.notifyObservers(object);
    }
}

