/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.exe;

import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.gui.XManager;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.selection.InformationCriterion;
import es.uvigo.darwin.jmodeltest.threads.SwingWorker;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import es.uvigo.darwin.prottest.consensus.Consensus;
import es.uvigo.darwin.prottest.facade.TreeFacadeImpl;
import es.uvigo.darwin.prottest.tree.WeightedTree;
import es.uvigo.darwin.prottest.util.FixedBitSet;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import pal.misc.Identifier;
import pal.tree.ReadTree;
import pal.tree.Tree;
import pal.tree.TreeParseException;

public class RunConsense {
    private TextOutputStream stream;
    private Consensus consensus;
    private String consensusType;
    private InformationCriterion criterion;
    private int numModels;
    private Model[] model;
    private int[] order;
    private double confidenceInterval;
    private Vector<Model> confidenceModels;
    private double[] w;
    private double[] cumw;
    private boolean[] isInInterval;
    public static SwingWorker workerConsense;

    public RunConsense(InformationCriterion informationCriterion, String string, double d) {
        this.criterion = informationCriterion;
        this.consensusType = string;
        this.numModels = informationCriterion.getNumModels();
        this.model = ModelTest.getCandidateModels();
        this.order = new int[this.numModels];
        this.confidenceInterval = d;
        this.confidenceModels = new Vector();
        this.w = new double[this.numModels];
        this.cumw = new double[this.numModels];
        this.isInInterval = new boolean[this.numModels];
        this.stream = ModelTest.getMainConsole();
        if (ModelTest.buildGUI) {
            System.out.println("\nComputing model averaged phylogeny ...");
        }
        this.buildConfidenceInterval();
        this.consensus = this.doConsense();
        this.printConsensus();
        if (ModelTest.buildGUI) {
            XManager.getInstance().getPane().setCaretPosition(XManager.getInstance().getPane().getDocument().getLength());
            System.out.println("OK");
        }
    }

    private Consensus doConsense() {
        String string;
        ArrayList<WeightedTree> arrayList = new ArrayList<WeightedTree>();
        for (Model model : this.confidenceModels) {
            try {
                double d;
                string = model.getTreeString();
                StringReader stringReader = new StringReader(string);
                ReadTree readTree = new ReadTree(new PushbackReader(stringReader));
                switch (this.criterion.getType()) {
                    case 1: {
                        d = model.getAICw();
                        break;
                    }
                    case 2: {
                        d = model.getAICcw();
                        break;
                    }
                    case 3: {
                        d = model.getBICw();
                        break;
                    }
                    case 4: {
                        d = model.getDTw();
                        break;
                    }
                    default: {
                        d = 0.0;
                    }
                }
                arrayList.add(new WeightedTree((Tree)readTree, d));
            }
            catch (TreeParseException treeParseException) {
                treeParseException.printStackTrace();
            }
        }
        double d = this.consensusType.equals("strict") ? 0.99999999 : 0.5;
        string = new Consensus(arrayList, d, 2);
        return string;
    }

    private void buildConfidenceInterval() {
        int n;
        Model model = this.model[0];
        this.order = this.criterion.order;
        for (n = 0; n < this.numModels; ++n) {
            model = this.model[this.order[n]];
            this.w[n] = this.criterion.getWeight(model);
            this.cumw[n] = this.criterion.getCumWeight(model);
        }
        if (this.confidenceInterval == 1.0) {
            for (n = 0; n < this.numModels; ++n) {
                model = this.model[this.order[n]];
                this.isInInterval[n] = true;
                this.confidenceModels.add(model);
            }
        } else {
            for (n = 0; n < this.numModels; ++n) {
                model = this.model[this.order[n]];
                if (!(this.cumw[n] <= this.confidenceInterval)) break;
                this.isInInterval[n] = true;
                this.confidenceModels.add(model);
            }
            double d = (model.getCumAICw() - this.confidenceInterval) / model.getAICw();
            double d2 = 1.0 - d;
            Random random = new Random();
            double d3 = random.nextDouble();
            if (d3 <= d2) {
                this.isInInterval[n] = true;
                this.confidenceModels.add(model);
            } else {
                this.isInInterval[n] = false;
            }
        }
    }

    public double getConfidenceInterval() {
        return this.confidenceInterval;
    }

    public String getConsensusType() {
        return this.consensusType;
    }

    public List<Model> getConfidenceModels() {
        return this.confidenceModels;
    }

    public Tree getConsensus() {
        return this.consensus.getConsensusTree();
    }

    private void printConsensus() {
        double d = this.consensusType.equals("50% majority rule") ? 0.5 : 1.0;
        TreeFacadeImpl treeFacadeImpl = new TreeFacadeImpl();
        this.stream.println(" ");
        this.stream.println(" ");
        this.stream.println(" ");
        this.stream.println("---------------------------------------------------------------");
        this.stream.println("*                                                             *");
        this.stream.println("*                    MODEL AVERAGED PHYLOGENY                 *");
        this.stream.println("*                                                             *");
        this.stream.println("---------------------------------------------------------------");
        if (this.criterion.getType() == 4) {
            Utilities.printRed("\nWarning: The DT weights used for this model averaged phylogeny are very gross and should be used with caution. See the program documentation.\n");
        }
        this.stream.println(" ");
        this.stream.println("Selection criterion: . . . . " + this.criterion);
        this.stream.print("Confidence interval: . . . . ");
        this.stream.printf("%4.2f\n", this.confidenceInterval);
        this.stream.println("Consensus type:. . . . . . . " + this.consensusType);
        this.stream.println(" ");
        this.stream.println(" ");
        this.stream.print("Using " + this.confidenceModels.size() + " models in the ");
        this.stream.printf("%4.2f ", this.confidenceInterval);
        this.stream.print("confidence interval = ");
        for (Model serializable2 : this.confidenceModels) {
            this.stream.print(serializable2.getName() + " ");
        }
        this.stream.println(" ");
        Set set = this.consensus.getCladeSupport().keySet();
        ArrayList<FixedBitSet> arrayList = new ArrayList<FixedBitSet>();
        ArrayList<FixedBitSet> arrayList2 = new ArrayList<FixedBitSet>();
        Iterator n = set.iterator();
        while (n.hasNext()) {
            FixedBitSet i = (FixedBitSet)n.next();
            if (i.cardinality() <= 1) continue;
            double identifier = 1.0 * (Double)this.consensus.getCladeSupport().get(i) / 1.0;
            if (identifier < d) {
                arrayList2.add(i);
                continue;
            }
            arrayList.add(i);
        }
        this.stream.println(" ");
        this.stream.println("Species in order:");
        this.stream.println(" ");
        int n2 = this.consensus.getIdGroup().getIdCount();
        for (int tree = 0; tree < n2; ++tree) {
            Identifier string = this.consensus.getIdGroup().getIdentifier(tree);
            this.stream.println("    " + (tree + 1) + ". " + string.getName());
        }
        this.stream.println(" ");
        this.stream.println("Bipartitions included in the consensus tree");
        this.stream.println(" ");
        this.stream.println(this.consensus.getSetsIncluded());
        this.stream.println(" ");
        Tree tree = this.consensus.getConsensusTree();
        this.stream.println(treeFacadeImpl.toASCII(tree));
        this.stream.println(" ");
        String string = treeFacadeImpl.toNewick(tree, true, true, true);
        this.stream.println(string);
        this.stream.println(" ");
        this.stream.println("Note: this tree is unrooted. Branch lengths are the expected number of substitutions per site. Labels next to parentheses represent phylogenetic uncertainty due to model selection (see documentation)");
    }
}

