/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.exe;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.ModelTestConfiguration;
import es.uvigo.darwin.jmodeltest.exe.ProcessManager;
import es.uvigo.darwin.jmodeltest.exe.RunPhyml;
import es.uvigo.darwin.jmodeltest.exe.StreamGobbler;
import es.uvigo.darwin.jmodeltest.io.TextInputStream;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.observer.ProgressInfo;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Observable;
import pal.tree.TreeParseException;

public class PhymlSingleModel
extends Observable
implements Runnable {
    private int verbose = 0;
    private String phymlStatFileName;
    private String phymlTreeFileName;
    private Model model;
    private long startTime;
    private long endTime;
    private String commandLine;
    private int index;
    private boolean justGetJCTree = false;
    private boolean ignoreGaps = false;
    private boolean interrupted = false;
    private ApplicationOptions options;
    private int numberOfThreads = -1;

    public Model getModel() {
        return this.model;
    }

    public PhymlSingleModel(Model model, int n, boolean bl, boolean bl2, ApplicationOptions applicationOptions) {
        this.options = applicationOptions;
        this.model = model;
        this.index = n;
        this.justGetJCTree = bl;
        this.ignoreGaps = bl2;
        this.phymlStatFileName = applicationOptions.getAlignmentFile().getAbsolutePath() + RunPhyml.PHYML_STATS_SUFFIX + model.getName() + ".txt";
        this.phymlTreeFileName = applicationOptions.getAlignmentFile().getAbsolutePath() + RunPhyml.PHYML_TREE_SUFFIX + model.getName() + ".txt";
    }

    public PhymlSingleModel(Model model, int n, boolean bl, ApplicationOptions applicationOptions, int n2) {
        this(model, n, bl, false, applicationOptions);
        this.numberOfThreads = n2;
    }

    public boolean compute() {
        if (this.model.getLnL() < 1.0E-5 || this.ignoreGaps) {
            this.notifyObservers(4, this.index, this.model, null);
            this.startTime = System.currentTimeMillis();
            this.commandLine = PhymlSingleModel.writePhyml3CommandLine(this.model, this.justGetJCTree, this.options, this.ignoreGaps, this.numberOfThreads);
            this.executeCommandLine();
            if (!this.interrupted) {
                this.parsePhyml3Files(this.model);
            }
            this.endTime = System.currentTimeMillis();
            this.model.setComputationTime(this.endTime - this.startTime);
            if (!this.interrupted) {
                int n = 0;
                n = this.ignoreGaps ? 2 : 1;
                this.notifyObservers(5, n, this.model, Utilities.calculateRuntime(this.startTime, this.endTime));
            }
        }
        return !this.interrupted;
    }

    @Override
    public void run() {
        this.compute();
    }

    public static String writePhyml3CommandLine(Model model, boolean bl, ApplicationOptions applicationOptions, boolean bl2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" -i ").append(applicationOptions.getAlignmentFile().getAbsolutePath());
        stringBuilder.append(" -d nt");
        stringBuilder.append(" -n 1");
        stringBuilder.append(" -b 0");
        if (bl2) {
            stringBuilder.append(" --no_gap");
        }
        stringBuilder.append(" --run_id ").append(model.getName());
        stringBuilder.append(" -m ").append(model.getPartition());
        if (model.ispF()) {
            stringBuilder.append(" -f m");
        } else {
            stringBuilder.append(" -f 0.25,0.25,0.25,0.25");
        }
        if (model.ispI()) {
            stringBuilder.append(" -v e");
        }
        if (model.ispG()) {
            stringBuilder.append(" -c ").append(applicationOptions.numGammaCat);
            stringBuilder.append(" -a e");
        } else {
            stringBuilder.append(" -c 1");
        }
        if (n > 0) {
            stringBuilder.append(" --num_threads ").append(n);
        }
        stringBuilder.append(" --no_memory_check");
        if (bl) {
            stringBuilder.append(" -o lr");
        } else if (applicationOptions.userTopologyExists || applicationOptions.fixedTopology) {
            stringBuilder.append(" -u ").append(applicationOptions.getTreeFile().getAbsolutePath());
            stringBuilder.append(" -o lr");
        } else if (!applicationOptions.optimizeMLTopology) {
            stringBuilder.append(" -o lr");
        } else {
            stringBuilder.append(" -o tlr");
            switch (applicationOptions.treeSearchOperations) {
                case SPR: {
                    stringBuilder.append(" -s SPR");
                    break;
                }
                case BEST: {
                    stringBuilder.append(" -s BEST");
                    break;
                }
                default: {
                    stringBuilder.append(" -s NNI");
                }
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommandLine() {
        block12: {
            String[] stringArray = new String[1];
            try {
                if (!ModelTestConfiguration.isGlobalPhymlBinary()) {
                    if (!RunPhyml.phymlBinary.exists()) {
                        this.notifyObservers(22, this.index, this.model, RunPhyml.phymlBinary.getAbsolutePath());
                    } else if (!RunPhyml.phymlBinary.canExecute()) {
                        this.notifyObservers(23, this.index, this.model, RunPhyml.phymlBinary.getAbsolutePath());
                    }
                }
                stringArray[0] = RunPhyml.phymlBinaryStr;
                String[] stringArray2 = this.commandLine.split(" ");
                String[] stringArray3 = Utilities.specialConcatStringArrays(stringArray, stringArray2);
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(stringArray3, null, RunPhyml.PHYML_PATH.equals("") ? null : new File(RunPhyml.PHYML_PATH));
                ProcessManager.getInstance().registerProcess(process);
                StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream(), "ERROR", System.err, ModelTest.getPhymlConsole());
                FileOutputStream fileOutputStream = new FileOutputStream(this.options.getLogFile(), true);
                StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream(), "PHYML", fileOutputStream, ModelTest.getPhymlConsole());
                streamGobbler.start();
                streamGobbler2.start();
                int n = process.waitFor();
                ProcessManager.getInstance().removeProcess(process);
                if (this.verbose > 1) {
                    System.out.println("ExitValue: " + n);
                }
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.println(" ");
                printWriter.println("Command line used for process " + streamGobbler2.getRunId() + ":");
                String string = this.commandLine.replace(this.options.getAlignmentFile().getAbsolutePath(), this.options.getInputFile().getAbsolutePath());
                if (this.options.userTopologyExists) {
                    string = string.replace(this.options.getTreeFile().getAbsolutePath(), this.options.getInputTreeFile().getAbsolutePath());
                }
                printWriter.println("    " + RunPhyml.phymlBinary.getAbsolutePath() + " " + string);
                printWriter.println(" ");
                printWriter.flush();
                printWriter.close();
                if (ModelTest.getPhymlConsole() == null) break block12;
                TextOutputStream textOutputStream = ModelTest.getPhymlConsole();
                synchronized (textOutputStream) {
                    ModelTest.getPhymlConsole().println(" ");
                    ModelTest.getPhymlConsole().println("Command line used for process " + streamGobbler2.getRunId() + ":");
                    ModelTest.getPhymlConsole().println("    " + RunPhyml.phymlBinary.getAbsolutePath() + " " + string);
                    ModelTest.getPhymlConsole().println(" ");
                    ModelTest.getPhymlConsole().flush();
                    ModelTest.getPhymlConsole().close();
                }
            }
            catch (InterruptedException interruptedException) {
                this.notifyObservers(20, this.index, this.model, null);
                this.interrupted = true;
            }
            catch (Throwable throwable) {
                this.notifyObservers(21, this.index, this.model, "Cannot run the Phyml command line for some reason: " + throwable.getMessage());
                this.interrupted = true;
            }
        }
    }

    private void parsePhyml3Files(Model model) {
        TextInputStream textInputStream;
        boolean bl = false;
        try {
            double d;
            textInputStream = new TextInputStream(this.phymlStatFileName);
            if (this.ignoreGaps) {
                String string;
                while ((string = textInputStream.readLine()) != null) {
                    if (string.length() <= 0) continue;
                    if (string.startsWith(". Log-likelihood")) {
                        model.setLnLIgnoringGaps(-1.0 * Double.parseDouble(Utilities.lastToken(string)));
                        continue;
                    }
                    if (!string.contains("Unconstrained likelihood")) continue;
                    d = -1.0 * Double.parseDouble(Utilities.lastToken(string));
                    model.setUnconstrainedLnL(d);
                    if (!(Math.abs(this.options.getUnconstrainedLnL() - d) > 1.0E-10)) continue;
                    this.options.setUnconstrainedLnL(d);
                }
            } else {
                String string;
                while ((string = textInputStream.readLine()) != null) {
                    if (string.length() <= 0) continue;
                    if (string.startsWith(". Log-likelihood")) {
                        model.setLnL(-1.0 * Double.parseDouble(Utilities.lastToken(string)));
                        if (!bl) continue;
                        System.err.println("Reading lnL = " + model.getLnL());
                        continue;
                    }
                    if (string.startsWith(". Discrete gamma model")) {
                        if (!Utilities.lastToken(string).equals("Yes")) continue;
                        string = textInputStream.readLine();
                        model.setNumGammaCat(Integer.parseInt(Utilities.lastToken(string)));
                        if (bl) {
                            System.err.println("Reading numGammaCat = " + model.getNumGammaCat());
                        }
                        string = textInputStream.readLine();
                        model.setShape(Double.parseDouble(Utilities.lastToken(string)));
                        if (!bl) continue;
                        System.err.println("Reading shape = " + model.getShape());
                        continue;
                    }
                    if (string.startsWith(". Nucleotides frequencies")) {
                        string = textInputStream.readLine();
                        while (string.trim().length() == 0) {
                            string = textInputStream.readLine();
                        }
                        model.setfA(Double.parseDouble(Utilities.lastToken(string)));
                        string = textInputStream.readLine();
                        model.setfC(Double.parseDouble(Utilities.lastToken(string)));
                        string = textInputStream.readLine();
                        model.setfG(Double.parseDouble(Utilities.lastToken(string)));
                        string = textInputStream.readLine();
                        model.setfT(Double.parseDouble(Utilities.lastToken(string)));
                        if (!bl) continue;
                        System.err.println("Reading fA = " + model.getfA());
                        System.err.println("Reading fC = " + model.getfC());
                        System.err.println("Reading fG = " + model.getfG());
                        System.err.println("Reading fT = " + model.getfT());
                        continue;
                    }
                    if (string.startsWith(". Proportion of invariant")) {
                        model.setPinv(Double.parseDouble(Utilities.lastToken(string)));
                        if (!bl) continue;
                        System.err.println("Reading pinv = " + model.getPinv());
                        continue;
                    }
                    if (string.contains("Unconstrained likelihood")) {
                        d = -1.0 * Double.parseDouble(Utilities.lastToken(string));
                        if (!this.options.isAmbiguous()) {
                            model.setUnconstrainedLnL(d);
                        } else {
                            model.setUnconstrainedLnL(0.0);
                        }
                        if (Math.abs(this.options.getUnconstrainedLnL()) <= 1.0E-10) {
                            this.options.setUnconstrainedLnL(d);
                        } else if (Math.abs(this.options.getUnconstrainedLnL() - d) > 1.0E-10) {
                            this.options.setUnconstrainedLnL(d);
                        }
                        if (!bl) continue;
                        System.err.println("Reading unconstrained logLK = " + model.getUnconstrainedLnL());
                        continue;
                    }
                    if (!string.startsWith(". GTR relative rate parameters")) continue;
                    string = textInputStream.readLine();
                    while (string.trim().length() == 0) {
                        string = textInputStream.readLine();
                    }
                    model.setRa(Double.parseDouble(Utilities.lastToken(string)));
                    string = textInputStream.readLine();
                    model.setRb(Double.parseDouble(Utilities.lastToken(string)));
                    string = textInputStream.readLine();
                    model.setRc(Double.parseDouble(Utilities.lastToken(string)));
                    string = textInputStream.readLine();
                    model.setRd(Double.parseDouble(Utilities.lastToken(string)));
                    string = textInputStream.readLine();
                    model.setRe(Double.parseDouble(Utilities.lastToken(string)));
                    string = textInputStream.readLine();
                    model.setRf(Double.parseDouble(Utilities.lastToken(string)));
                    if (bl) {
                        System.err.println("Reading Ra = " + model.getRa());
                        System.err.println("Reading Rb = " + model.getRb());
                        System.err.println("Reading Rc = " + model.getRc());
                        System.err.println("Reading Rd = " + model.getRd());
                        System.err.println("Reading Re = " + model.getRe());
                        System.err.println("Reading Rf = " + model.getRf());
                    }
                    if (!model.ispT()) continue;
                    model.setKappa(model.getRb());
                    model.setTitv(model.getKappa() * (model.getfA() * model.getfG() + model.getfC() * model.getfT()) / ((model.getfA() + model.getfG()) * (model.getfC() + model.getfT())));
                }
            }
            textInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.notifyObservers(21, this.index, this.model, "Optimization results file does not exist: " + this.phymlStatFileName);
        }
        catch (NullPointerException nullPointerException) {
            this.notifyObservers(21, this.index, this.model, "Error while parsing result data from " + model.getName());
        }
        try {
            textInputStream = new TextInputStream(this.phymlTreeFileName);
            String string = textInputStream.readLine();
            model.setTreeString(string);
            textInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.notifyObservers(21, this.index, this.model, null);
            System.err.println("Optimized tree file does not exist: " + this.phymlTreeFileName);
        }
        catch (TreeParseException treeParseException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" Please, check the PhyML log");
            if (ModelTest.execMode == ModelTest.ExecMode.GUI) {
                stringBuffer.append(" tab,");
            } else {
                stringBuffer.append(" file at " + this.options.getLogFile());
            }
            stringBuffer.append(" or run PhyML alone for getting more information: ");
            this.notifyObservers(21, this.index, this.model, "ML tree for " + model.getName() + " is invalid." + stringBuffer.toString());
        }
        Utilities.deleteFile(this.phymlStatFileName);
        Utilities.deleteFile(this.phymlTreeFileName);
    }

    private void notifyObservers(int n, int n2, Model model, String string) {
        this.setChanged();
        this.notifyObservers(new ProgressInfo(n, n2, model, string));
    }
}

