/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest;

import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public abstract class ModelTestConfiguration {
    private static final Properties APPLICATION_PROPERTIES;
    public static final boolean DEFAULT_GLOBAL_PHYML = false;
    private static final String JAR_PATH;
    public static final String PATH;
    public static final String DEFAULT_EXE_DIR;
    public static final String DEFAULT_LOG_DIR;
    public static final String HTML_LOG = "html-logging";
    public static final String PHYML_LOG = "phyml-logging";
    public static final String LOG_DIR = "log-dir";
    public static final String EXE_DIR = "exe-dir";
    public static final String GLOBAL_PHYML_EXE = "global-phyml-exe";
    public static final String G_THREADS = "gamma-threads";
    public static final String I_THREADS = "inv-threads";
    public static final String U_THREADS = "uniform-threads";

    private static String convertPathToAbsolute(String string) {
        if (Utilities.isWindows()) {
            string.replace('/', '\\');
        } else {
            File file = new File(string);
            if (!file.isAbsolute()) {
                string = PATH + string;
            }
        }
        return string;
    }

    public static String getProperty(String string) {
        return APPLICATION_PROPERTIES.getProperty(string);
    }

    public static String getExeDir() {
        String string = ModelTestConfiguration.getProperty(EXE_DIR);
        if (string == null) {
            string = DEFAULT_EXE_DIR;
        }
        return ModelTestConfiguration.convertPathToAbsolute(string);
    }

    public static boolean isGlobalPhymlBinary() {
        String string = ModelTestConfiguration.getProperty(GLOBAL_PHYML_EXE);
        return string != null && string.equalsIgnoreCase("true");
    }

    public static boolean isHtmlLogEnabled() {
        return ModelTestConfiguration.getProperty(HTML_LOG).equalsIgnoreCase("enabled");
    }

    public static boolean isPhymlLogEnabled() {
        return ModelTestConfiguration.getProperty(PHYML_LOG).equalsIgnoreCase("enabled");
    }

    public static String getLogDir() {
        String string = ModelTestConfiguration.getProperty(LOG_DIR);
        if (string == null) {
            string = DEFAULT_LOG_DIR;
        }
        return ModelTestConfiguration.convertPathToAbsolute(string);
    }

    public static Properties getProperties() {
        return APPLICATION_PROPERTIES;
    }

    static {
        JAR_PATH = ModelTest.class.getProtectionDomain().getCodeSource().getLocation().getFile().replace("%20", " ");
        PATH = JAR_PATH.replaceFirst(new File(JAR_PATH).getName(), "");
        DEFAULT_EXE_DIR = PATH + "exe" + File.separator + "phyml";
        DEFAULT_LOG_DIR = PATH + "log";
        APPLICATION_PROPERTIES = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(PATH + "conf/jmodeltest.conf");
            APPLICATION_PROPERTIES.load(fileInputStream);
        }
        catch (IOException iOException) {
            System.err.println("Configuration file (" + PATH + "conf/jmodeltest.conf" + ") cannot be resolved");
            System.exit(-1);
        }
    }
}

