\name{crit_fun}
\alias{crit_fun}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Calculate the soft threshold for a target FDR
}
\description{
Calculate the soft threshold for a target FDR
}
\usage{
crit_fun(PPEE, thre)
}
\arguments{
  \item{PPEE}{
The posterior probabilities of being EE.
}
  \item{thre}{
The target FDR.
  }

}
\details{
Regarding a target FDR alpha, both hard threshold and soft threshold could be used. 
If the hard threshold is preferred, user could simply take the transcripts with PP(DE) greater 
than (1-alpha). Using the hard threshold, any DE transcript in the list is with 
FDR <= alpha. 

If the soft threshold is preferred, user could take the transcripts with PP(DE) 
greater than crit_fun(PPEE, alpha). Using the soft threshold, the list of 
DE transcripts is with average FDR alpha.
}
\value{
The adjusted FDR threshold of target FDR.
}
\references{
}
\author{
Ning Leng
}


\seealso{
}
\examples{
data(GeneMat)
str(GeneMat)
Sizes=MedianNorm(GeneMat)
EBOut=EBTest(Data=GeneMat,
			        Conditions=as.factor(rep(c("C1","C2"),each=5)),sizeFactors=Sizes, maxround=5)
PP=GetPPMat(EBOut)
str(PP)
head(PP)
DEfound=rownames(PP)[which(PP[,"PPDE"]>=.95)]
str(DEfound)

SoftThre=crit_fun(PP[,"PPEE"],.05)
DEfound_soft=rownames(PP)[which(PP[,"PPDE"]>=SoftThre)]
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ FDR }
