\name{PolyFitPlot}
\alias{PolyFitPlot}
\title{
Fit the mean-var relationship using polynomial regression
}
\description{
Fit the mean-var relationship using polynomial regression

}
\usage{
PolyFitPlot(X, Y, nterms, xname = "Estimated Mean", yname = "Estimated Var", pdfname = "", xlim =  c(-1,5), ylim = c(-1,7), ChangeXY = F, col = "red")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{X}{
The first group of values want to be fitted by the polynomial regression. ( e.g Mean of the data. )
}
  \item{Y}{
The second group of values want to be fitted by the polynomial regression. ( e.g. variance of the data.) The length of Y should be the same as the length of X.
}
  \item{nterms}{
How many polynomial terms want to be used.
}
  \item{xname}{
Name of the x axis.
}
  \item{yname}{
Name of the y axis.
}
  \item{pdfname}{
Name of the plot.
}
  \item{xlim}{
The x limits of the plot. 
}
  \item{ylim}{
The y limits of the plot.

}
  \item{ChangeXY}{
If ChangeXY is setted to be TRUE, X will be treated as the dependent variable and Y will be treated as the independent one. Default is FALSE.
}
  \item{col}{
Color of the fitted line.
}
}
\details{
%%  ~~ If necessary, more details than the description above ~~
}
\value{
	The PolyFitPlot function provides a smooth scatter plot of two variables and their best fitting line of polynomial regression.
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
Ning Leng
}
\note{
%%  ~~further notes~~
}


\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
data(IsoList)
str(IsoList)
IsoMat=IsoList$IsoMat
str(IsoMat)
IsoNames=IsoList$IsoNames
IsosGeneNames=IsoList$IsosGeneNames
IsoSizes=MedianNorm(IsoMat)
NgList=GetNg(IsoNames, IsosGeneNames)
IsoNgTrun=NgList$IsoformNgTrun
IsoNgTrun[c(1:3,1001:1003,3001:3003)]
IsoEBOut=EBTest(Data=IsoMat, NgVector=IsoNgTrun,
								        Conditions=as.factor(rep(c("C1","C2"),each=5)),sizeFactors=IsoSizes, maxround=5)
par(mfrow=c(2,2))
PolyFitValue=vector("list",3)
for(i in 1:3)
	          PolyFitValue[[i]]=PolyFitPlot(IsoEBOut$C1Mean[[i]],
											                IsoEBOut$C1EstVar[[i]],5)
PolyAll=PolyFitPlot(unlist(IsoEBOut$C1Mean), unlist(IsoEBOut$C1EstVar),5)
lines(log10(IsoEBOut$C1Mean[[1]][PolyFitValue[[1]]$sort]),
	  PolyFitValue[[1]]$fit[PolyFitValue[[1]]$sort],col="yellow",lwd=2)
lines(log10(IsoEBOut$C1Mean[[2]][PolyFitValue[[2]]$sort]),
	  PolyFitValue[[2]]$fit[PolyFitValue[[2]]$sort],col="pink",lwd=2)
lines(log10(IsoEBOut$C1Mean[[3]][PolyFitValue[[3]]$sort]),
	  PolyFitValue[[3]]$fit[PolyFitValue[[3]]$sort],col="green",lwd=2)
legend("topleft",c("All Isoforms","Ng = 1","Ng = 2","Ng = 3"),
	   col=c("red","yellow","pink","green"),lty=1,lwd=3,box.lwd=2)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
