\name{GetMultiFC}
\alias{GetMultiFC}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Calculate the Fold Changes for each pair of conditions in 
a multiple condition study.
}
\description{
}
\usage{
GetMultiFC(EBMultiout, SmallNum=.01)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{EBMultiout}{
The output of EBMultiTest function.
}
\item{SmallNum}{A small number will be added for each transcript in each condition to avoid Inf and NA.
Default is .01.}
}
\details{
Provide the FC (adjusted by the normalization factors) for each pair of comparisons.
A small number will be added for each transcript in each condition to avoid Inf and NA.
Default is .01.
}
\value{
\item{FCMat}{The FC of each pair of comparison}
\item{Log2FCMat}{The log 2 FC of each pair of comparison}
\item{CondMean}{The mean of each transcript within each condition.(adjusted by the normalization factors)}
\item{ConditionOrder}{The condition assignment
	    for C1Mean, C2Mean etc}
}


\references{
}
\author{
Ning Leng
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
}
\examples{
data(MultiGeneMat)
str(MultiGeneMat)
Conditions=c("C1","C1","C2","C2","C3","C3")
PosParti=GetPatterns(Conditions)
PosParti
Parti=PosParti[-3,]
Parti
MultiSize=MedianNorm(MultiGeneMat)
MultiOut=EBMultiTest(MultiGeneMat,NgVector=NULL,Conditions=Conditions,
			                       AllParti=Parti, sizeFactors=MultiSize, maxround=5)
MultiPP=GetMultiPP(MultiOut)
names(MultiPP)
MultiPP$PP[1:10,]
MultiPP$MAP[1:10]
MultiPP$Patterns
MultiFC=GetMultiFC(MultiOut)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ Posterior Probability }
