\name{EBTest}
\alias{EBTest}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Using EM algorithm to calculate the posterior probabilities of being DE
}
\description{
Base on the assumption of NB-Beta Empirical Bayes model, the EM algorithm is used to get the posterior probability of being DE.
}
\usage{
EBTest(Data, NgVector=NULL, Vect5End=NULL, Vect3End=NULL, Conditions, sizeFactors, maxround,tau=NULL,CI=NULL,CIthre=NULL, Pool=F, NumBin=1000)
}
%- maybe also 'usage' for other objects documented here.
\arguments{

  \item{Data}{
A data matrix contains expression values for each transcript (gene or isoform level). In which rows should be transcripts and columns should be samples.
}
  \item{NgVector}{
A vector indicates the uncertainty group assignment of each isoform. 
e.g. if we use number of isoforms in the host gene to define the uncertainty groups, 
suppose the isoform is in a gene with 2 isoforms, Ng of this isoform should be 2. 
The length of this vector should be the same as the number of rows in Data.
If it's gene level data, Ngvector could be left as NULL.
	}

  \item{Conditions}{
A factor indicates the condition each sample belongs to. 
}


  \item{sizeFactors}{
The normalization factors.
It should be a vector with lane specific numbers (the length of the vector should be the same as the number of samples, 
with the same order as the columns of Data)
}
  \item{maxround}{
Number of iterations. The default value is 5. 
Users should always check the convergency by looking at the Alpha and 
Beta in output. If the hyper-parameter estimations are not converged 
in 5 iterations, larger number is suggested.
}
\item{Pool, NumBin}{
While working without replicates, user could define the Pool=T in the
 EBTest function to enable pooling.
By defining NumBin = 1000, EBSeq will group the genes with similar means
together into 1,000 bins.
With the assumption that no more than 50\% genes are DE in the data set,
We take genes whose FC are in the 25\% - 75\% quantile of the FC's  as the
candidate genes.
For each bin, the bin-wise variance estimation is defined as the median of the
cross condition variance estimations of the candidate genes within that bin.
We use the cross condition variance estimations for the candidate genes
and the bin-wise variance estimations of the host bin for the non-candidate genes.
}

}

\details{
For each transcript gi within condition, the model assumes:
X_{gis}|mu_{gi} ~ NB (r_{gi0} * l_s, q_{gi})
q_gi|alpha, beta^N_g ~ Beta (alpha, beta^N_g)
In which the l_s is the sizeFactors of sample s.

The function will test:
H0: q_{gi}^{C1} = q_{gi}^{C2}
H1: q_{gi}^{C1} != q_{gi}^{C2}


}
\value{
\item{Alpha }{Fitted parameter alpha of the prior beta distribution. Rows are the values for each iteration.}
\item{Beta }{Fitted parameter beta of the prior beta distribution. Rows are the values for each iteration.}
\item{P, PFromZ }{ The bayes estimator of being DE. Rows are the values for each iteration.}
\item{Z, PoissonZ}{ The Posterior Probability of being DE for each transcript(Maybe not in the same order of input). }
\item{RList}{ The fitted values of r for each transcript.}
\item{MeanList}{The mean of each transcript. (across conditions)}
\item{VarList}{The variance of each transcript. (across conditions)}
\item{QListi1}{The fitted q values of each transcript within condition 1.}
\item{QListi2}{The fitted q values of each transcript within condition 2.}
\item{C1Mean}{The mean of each transcript within Condition 1 (adjusted by normalization factors)}
\item{C2Mean}{The mean of each transcript within Condition 2 (adjusted by normalization factors)}
\item{C1EstVar}{The estimated variance of each transcript within Condition 1(adjusted by normalization factors)}
\item{C2EstVar}{The estimated variance of each transcript within Condition 2(adjusted by normalization factors)}
\item{PoolVar}{The variance of each transcript. (The pooled value of within condition EstVar)}
\item{DataList}{A List of data that grouped with Ng.}
\item{PPDE}{The Posterior Probability of being DE for each transcript. (The same order of input)}
\item{f0,f1}{The likelihood of the prior predictive distribution of being 
EE or DE (in log scale)}
\item{AllZeroIndex}{The transcript with expression 0 for all samples 
	(which are not tested).}
\item{PPMat}{A matrix contains posterior probabilities of being EE (the first column)
or DE (the second column). Rows are transcripts. Transcripts with expression 
0 for all samples are not shown in this matrix.}
\item{PPMatWith0}{A matrix contains posterior probabilities of being EE (the first column)
or DE (the second column). Rows are transcripts. 
Transcripts with expression  
0 for all samples are shown as PP(EE)=PP(DE)=NA in this matrix.
The transcript order is exactly the same as the order of the input data}
\item{ConditionOrder}{The condition assignment 
	for C1Mean, C2Mean etc}
\item{Conditions}{The input conditions}
}
\references{
}
\author{
Ning Leng
}
\note{
}


\seealso{
}
\examples{
data(GeneMat)
str(GeneMat)
Sizes=MedianNorm(GeneMat)
EBOut=EBTest(Data=GeneMat,
						        Conditions=as.factor(rep(c("C1","C2"),each=5)),sizeFactors=Sizes, maxround=5)
PP=GetPPMat(EBOut)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
