\name{EBMultiTest}
\alias{EBMultiTest}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Using EM algorithm to calculate the posterior probabilities 
of interested patterns in a multiple condition study
}
\description{
Base on the assumption of NB-Beta Empirical Bayes model, the EM algorithm is used to get the posterior probability of interested patterns.
}
\usage{
EBMultiTest(Data,NgVector=NULL,Conditions,AllParti=NULL, sizeFactors, maxround, tau=NULL,CI=NULL,CIthre=NULL, Pool=F, NumBin=1000, Approx=10^-10,PoolLower=.25, PoolUpper=.75)
}
%- maybe also 'usage' for other objects documented here.
\arguments{

  \item{Data}{
A data matrix contains expression values for each transcript (gene or isoform level). In which rows should be transcripts and columns should be samples.

	}
  \item{NgVector}{
A vector indicates the uncertainty group assignment of each isoform.
e.g. if we use number of isoforms in the host gene to define the uncertainty groups,
suppose the isoform is in a gene with 2 isoforms, Ng of this isoform should be 2.
The length of this vector should be the same as the number of rows in Data.
If it's gene level data, Ngvector could be left as NULL.

	}
  \item{Conditions}{
A vector indicates the condition each sample belongs to. 
}

\item{AllParti}{
	A matrix indicates the interested patterns. Columns shoule be conditions and rows should be patterns. 
	The matrix could be obtained by the GetPatterns function. If AllParti=NULL, all possible patterns will be used.
}

  \item{sizeFactors}{
The normalization factors.
It should be a vector with lane specific numbers (the length of the vector should be the same as the number of samples,
with the same order as the columns of Data)

	}
  \item{maxround}{
Number of iterations. The default value is 5.
Users should always check the convergency by looking at the Alpha and
Beta in output. If the hyper-parameter estimations are not converged
in 5 iterations, larger number is suggested.

	}
\item{Pool, NumBin}{
Working without replicates, we should define the Pool=T in the
 EBTest function to enable pooling.
By defining NumBin = 1000, EBSeq will group the genes with similar means
together into 1,000 bins.
With the assumption that no more than 50\% genes are DE in the data set,
We take genes whose FC are in the 25\% - 75\% quantile of the FC's  as the
candidate genes.
For each bin, the bin-wise variance estimation would be the median of the
cross condition variance estimations of the candidate genes within that bin.
We use the cross condition variance estimations for the candidate genes
and the bin-wise variance estimations of the host bin for the non-candidate genes.
}

}

\details{

}
\value{
\item{Alpha }{Fitted parameter alpha of the prior beta distribution. Rows are the values for each iteration.}
\item{Beta }{Fitted parameter beta of the prior beta distribution. Rows are the values for each iteration.}
\item{P, PFromZ }{ The bayes estimator of following each pattern of interest. 
	Rows are the values for each iteration.}
\item{Z, PoissonZ}{ The Posterior Probability of following each pattern of interest
 	for each transcript. (Maybe not in the same order of input)}
\item{RList}{ The fitted values of r for each transcript.}
\item{MeanList}{The mean of each transcript. (across conditions)}
\item{VarList}{The variance of each transcript. (across conditions)}
\item{QList}{The fitted q values of each transcript within each condition.}
\item{SPMean}{The mean of each transcript within each condition.(adjusted by the normalization factors)}
\item{SPEstVar}{The estimated variance of each transcript within each condition.(adjusted by the normalization factors)}
\item{PoolVar}{The variance of each transcript. (The pooled value of within condition EstVar)}
\item{DataList}{A List of data that grouped with Ng and bias.}
\item{PPpattern}{The Posterior Probability of following each pattern (columns)
	for each transcript (rows). 
Transcripts with expression
0 for all samples are not shown in this matrix.}
\item{f}{The likelihood of likelihood of prior predictive distribution of being each pattern for each transcript. }
\item{AllParti}{The matrix describe the patterns}
\item{PPpatternWith0}{The Posterior Probability of following each pattern (columns)  for each transcript (rows). 
Transcripts with expression
0 for all samples are shown in this matrix with PP(any_pattrn)=NA.}
\item{ConditionOrder}{The condition assignment
	  for C1Mean, C2Mean etc}
}
\references{
}
\author{
Ning Leng
}
\note{
}


\seealso{
}
\examples{
data(MultiGeneMat)
str(MultiGeneMat)
Conditions=c("C1","C1","C2","C2","C3","C3")
PosParti=GetPatterns(Conditions)
PosParti
Parti=PosParti[-3,]
Parti
MultiSize=MedianNorm(MultiGeneMat)
MultiOut=EBMultiTest(MultiGeneMat,NgVector=NULL,Conditions=Conditions,
				                    AllParti=Parti, sizeFactors=MultiSize, maxround=5)
MultiPP=GetMultiPP(MultiOut)
names(MultiPP)
MultiPP$PP[1:10,]
MultiPP$MAP[1:10]
MultiPP$Patterns


}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
