# falseColorChimera.py
# Jonathan Galazka
# Usage: cat model.cmm | python ~/03_falseColorChimera.py > colored_model.cmm
# Be sure that chimera model and ChIP track resolution matches

import sys
import numpy as np
from matplotlib import cm
import matplotlib.pyplot as plt


cen_array = np.transpose(np.loadtxt('/Volumes/HD/HiC2/ChIP_tracks/h3k9_klocko/H3K9me3_LGVII_50kb.txt'))

sorted = np.sort(cen_array)
norm_cen_array = cen_array / sorted[-1]
plt.plot(norm_cen_array)
plt.show()




position1 = 0
position2 = 0

for line in sys.stdin:

	line = line.strip()
	
	if(line[0:11] == '<marker_set'):
		print(line)
		
	elif(line[0:7] == '<marker'):
		
		elements = line.split(' ')
		
		cen_value = norm_cen_array[position1]
		r_value = cen_value * 256
		
		rgb = cm.YlOrRd(int(r_value))
		
		r_string = 'r=\"' + str(rgb[0]) + '\"'
		elements[5] = r_string
		
		g_string = 'g=\"' + str(rgb[1]) + '\"'
		elements[6] = g_string
		
		b_string = 'b=\"' + str(rgb[2]) + '\"'
		elements[7] = b_string
		
		print(' '.join(elements))
		
		position1 = position1 + 1
		
	elif(line[0:5] == '<link'):
		
		elements = line.split(' ')
		
		cen_value = norm_cen_array[position2]
		r_value = cen_value * 256
		
		rgb = cm.YlOrRd(int(r_value))
		
		r_string = 'r=\"' + str(rgb[0]) + '\"'
		elements[3] = r_string
		
		g_string = 'g=\"' + str(rgb[1]) + '\"'
		elements[4] = g_string
		
		b_string = 'b=\"' + str(rgb[2]) + '\"'
		elements[5] = b_string
		
		print(' '.join(elements))
		
		position2 = position2 + 1
		
	else:
		print(line)

