#!/usr/bin/env python
# Jonathan M Galazka, Oregon State University
# Takes a .bcf file produced from samtools mpileup and 'fixes' it by
# filing every empty positon with a zero
# Usage: cat <file.bcf> | ./bcfFixer.py

import sys
import re

chr1 = dict()
chr2 = dict()
chr3 = dict()
chr4 = dict()
chr5 = dict()
chr6 = dict()
chr7 = dict()

chromosomes = (chr1,chr2,chr3,chr4,chr5,chr6,chr7)

chromosome_lengths = (9798893,4478683,5274802,6000761,6436246,4218384,4255303)

# make list of zero's with length equal to number of bases in chromosome
counter = 0
for chromosome in chromosomes:
	chr_length = chromosome_lengths[counter]
	counter = counter + 1
	for i in range(0,chr_length):
		chromosome[i] = 0

# replace all zero's in list produced above with coverage values if they exist
# otherwise zero's remain
for line in sys.stdin:
	stripped_line = line.strip()
	elements = line.split('\t')
	chr = elements[0]
	pos = elements[1]
	cov = elements[3]
	chr_num = chr[3:5]
	chr_int = int(chr_num)
	if(chr_int > 7):
		pass
	else: 
		chromosome = chromosomes[chr_int - 1]
		chromosome[int(pos) - 1] = cov
	
# output
counter = 0
for chromosome in chromosomes:

	chr_length = chromosome_lengths[counter]
	supercontig = 'Supercontig_12.' + str(counter + 1)
	counter = counter + 1
	
	for i in range(0, chr_length):
		cov = chromosome[i]
		print(supercontig + '\t' + str(cov))




