# binsWith1000.py
# Jonathan M. Galazka, Andrew D. Klocko
# 2015
# Usage: python ./binsWith1000.py
#
# Use to output the percent of bins with at least 1000 total observations.

import numpy as np

datasets = ['dim-3']

for dataset in datasets:

	percents = list()

	resolutions = [50000,40000,35000,30000,25000,20000,17500,15000,12500,10000,7500,5000,2500]
	
	for resolution in resolutions:
	
		# read dataset. note these are uncorrected datasets
		unpacked_folder = '/Volumes/HD/HiC2/' + dataset + '/' + dataset + '-' + str(resolution) + '-txt'
		
		tab_file = unpacked_folder + '/heatmap'
		array = np.loadtxt(tab_file, delimiter=' ')
		
		row_sums = np.sum(array, axis=1) # calculate the number of observations for each row
		
		num_atleast_1000 = float((row_sums > 999).sum()) # calculate number of rows over 999
		
		percent_over_1000 = 100 * (num_atleast_1000 / row_sums.size) # calculate percent
		
		percents.append(percent_over_1000)
				
	# output for current dataset
	print(dataset)
	for percent in percents:
		print(percent)







