# binaryCoverage.py
# Jonathan M. Galazka, Andrew D. Klocko
# 2015
# Usage: binaryCoverage.py
#
# Use to make binary heatmaps showing which bins do and do not have data


import matplotlib.pyplot as plt
import matplotlib.cm as cm
import numpy as np
import subprocess
from mirnylib import genome
from mirnylib import h5dict
from mirnylib import plotting
from hiclib import binnedData
from hiclib.binnedData import binnedDataAnalysis

datasets = ['NMF39_1']

counter = 1

for dataset in datasets:

	resolutions = [60000, 50000, 40000, 30000, 20000, 10000]
	
	for resolution in resolutions:
	
		plt.subplot(2,3,counter)

		unpacked_folder = '/Volumes/HD/HiC2/' + dataset + '/' + dataset + '_ic-' + str(resolution) + '-diag-txt'
		
		heatmap = unpacked_folder + '/heatmap'
		
		array = np.loadtxt(heatmap, delimiter=' ')
		
		array[array > 0] = 1
		
		cmap = cm.gray_r
		plt.imshow(array, interpolation="none", cmap=cmap)
		
		counter = counter + 1

			
	plt.savefig('/Volumes/HD/plot.eps', dpi=600)

	plt.show()






