# plotHetLimited.py
# Jonathan M. Galazka, Andrew D. Klocko
# Usage: python ./plotHetLimited.py
#
# Plots selected examples of heterochromatic foci +10 adjacent bins to the desktop.
# Works on one strain at a time.

import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm

# Import array
dataset = 'NMF39'
resolution = 10000
res_string = str(resolution)
chr_starts_path = '/Volumes/HD/HiC2/NMF39/NMF39_ic-' + res_string + '-diag-txt/ChromosomeStarts'
chr_starts_array = np.loadtxt(chr_starts_path, delimiter=' ')
chr_starts = np.transpose(chr_starts_array.astype(int)[0:7])
chr_ends = np.transpose(chr_starts_array.astype(int)[1:8])
dataset_path = '/Volumes/HD/HiC2/' + dataset + '/' + dataset + '_ic-hm-' + res_string + '-diag-txt/heatmap'	
array = np.loadtxt(dataset_path, delimiter=' ')
array = array + 0.1
array = array + np.mean(array)

het_file = '/Users/galazkaj/Dropbox/hicScripts/Figure4/het_limited.txt'
het_filehandle = open(het_file, 'r')

lgs = []
starts = []
ends = []
for line in het_filehandle:
	line = line.strip()
	elements = line.split('\t')
	lg, start, stop = int(elements[0]), int(elements[1]), int(elements[2]) + 1
	lgs.append(lg)
	starts.append(start)
	ends.append(stop)
	
for i in range(0, len(lgs)):

	lg = lgs[i]
	chr_start = chr_starts[lg]
	start = starts[i]
	end = ends[i]
	size = start - end
	
	actual_start = chr_start + start
	actual_end = chr_start + end
	
	display = array[actual_start-10:actual_end+10,actual_start-10:actual_end+10]
	
	f, ax1 = plt.subplots(1)
	heat = ax1.imshow(np.log2(display), interpolation='nearest', cmap=cm.coolwarm)
	heat.set_clim(3,7)
	f.colorbar(heat)
	savename = '/Users/galazkaj/Desktop/het_' + dataset + '_lg-' + str(lg) + '_' + str(start) + '-' + str(end) + '.tiff'
	#plt.show()
	plt.savefig(savename)
	
