# plotHetChipSignal.py
# Jonathan M Galazka, Andrew D Klocko
# 2015
# Usage: python ./plotHetChipSignal.py
# Plot the H3K9me3 signal associated with interspersed heterochromatin loci
# Also plots an average signal from all loci

import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm

# Import chromosome starts and stops
dataset = 'NMF39'
resolution = 10000
res_string = str(resolution)
chr_starts_path = '/Volumes/HD/HiC2/NMF39/NMF39_ic-' + res_string + '-diag-txt/ChromosomeStarts'
chr_starts_array = np.loadtxt(chr_starts_path, delimiter=' ')
chr_starts = np.transpose(chr_starts_array.astype(int)[0:7])
chr_ends = np.transpose(chr_starts_array.astype(int)[1:8])

# Open file containing coordinates (in bins) of heterochromatin loci
het_file = '/Users/galazkaj/Dropbox/hicScripts/Figure4/heterochromatin_all.txt'
het_filehandle = open(het_file, 'r')

# Make lists of chromosome, start and end positions from heterochromatin file.
lgs = []
starts = []
ends = []
for line in het_filehandle:
	line = line.strip()
	elements = line.split('\t')
	lg, start, stop = int(elements[0]), int(elements[1]), int(elements[2]) + 1
	lgs.append(lg)
	starts.append(start)
	ends.append(stop)
	
# Open ChIP file with H3K9me3 levels at 10 kb resolution
chipfile = '/Volumes/HD/HiC2/ChIP_tracks/h3k9_klocko/k9_all_chr_10k_array.txt'
h3k9 = np.transpose(np.loadtxt(chipfile))

# Get H3K9me3 levels from ChIP file
displays = []
for i in range(0, len(lgs)):

	lg = lgs[i]
	chr_start = chr_starts[lg]
	start = starts[i]
	end = ends[i]
	size = end - start
	to_add = 25 - size
	to_add_1 = np.floor(to_add / 2.0)
	to_add_2 = np.ceil(to_add / 2.0)
	
	actual_start = chr_start + start
	actual_end = chr_start + end
	
	display = h3k9[actual_start - to_add_1 : actual_end + to_add_2]
	display = display / np.max(display)
	displays.append(display)

# Plot each region individually and also add them together to get a total	
total = np.zeros((25,))
counter = 0
for display in displays:

	total += display

	f1, ax1 = plt.subplots(1, figsize=(10,3), frameon=False)
	xs = range(0, display.size)
	ax1.autoscale(axis='x', tight=True)
	ax1.bar(xs, display, color='black')
	ax1.set_xticks([])
	ax1.set_yticks([])
	savename = '/Users/galazkaj/Desktop/chip_' + str(counter) + '.pdf'
	#plt.savefig(savename)
	plt.show()
	counter += 1
	

# Calculate average from total and plot	
total = total / np.max(total)
f2, ax2 = plt.subplots(1, figsize=(10,3), frameon=False)
xs = range(0, display.size)
ax2.autoscale(axis='x', tight=True)
ax2.bar(xs, total, color='black')
ax2.set_xticks([])
ax2.set_yticks([])
savename = '/Users/galazkaj/Desktop/chip_total.pdf'
#plt.savefig(savename)
plt.show()

	
