# matrix2Circos_K27_Intra_Network.py
# Jonathan M. Galazka, Andrew D. Klocko
# 2015
# Usage: python ./matrix2Circos_K27_Intra_Network.py

import sys
import numpy as np


# Process K27 track into 1 (enriched) or 0 (not enriched) by calculating which positions are above 2x the median
k27_path = '/Volumes/HD/HiC/ChIP_tracks/h3k27/k27_10k.txt'
k27_array = np.transpose(np.loadtxt(k27_path))
k27_median = np.median(k27_array)
k27_median_plus = k27_median + (k27_median * 1)
for i in range(0, k27_array.size):
	if(k27_array[i] < k27_median_plus):
		k27_array[i] = 0
	else:
		k27_array[i] = 1


dataset = 'dataset1'
resolution = 10000

# get chromosome start and ends
res_string = str(resolution)
chr_starts_path = '/Volumes/HD/HiC/' + dataset + '/' + dataset + '-ic-hm-' + res_string + '-txt/ChromosomeStarts'
chr_starts_array = np.loadtxt(chr_starts_path, delimiter=' ')
chr_starts = np.transpose(chr_starts_array.astype(int)[0:7])
chr_ends = np.transpose(chr_starts_array.astype(int)[1:8])

# load hic array and reduce to that corresponding to the seven chromsomes
dataset_path = '/Volumes/HD/HiC/' + dataset + '/' + dataset + '-ic-hm-' + res_string + '-txt/obs-exp.txt'
array = np.loadtxt(dataset_path, delimiter=' ')
lg_array = array[chr_starts[0]:chr_ends[6],chr_starts[0]:chr_ends[6]]
array_x_dim, array_y_dim = lg_array.shape

# got through each datapoint in the hic array and determine what chromosomes
# it is associate with and get the value.
for i in range(0, array_y_dim):

	if(i >= chr_starts[0] and i < chr_ends[0]):
		lg_string1 = 'LGI'
		start1 = (i - chr_starts[0]) * resolution
		end1 = start1 + resolution
		
	elif(i >= chr_starts[1] and i < chr_ends[1]):
		lg_string1 = 'LGII'
		start1 = (i - chr_starts[1]) * resolution
		end1 = start1 + resolution
		
	elif(i >= chr_starts[2] and i < chr_ends[2]):
		lg_string1 = 'LGIII'
		start1 = (i - chr_starts[2]) * resolution
		end1 = start1 + resolution
		
	elif(i >= chr_starts[3] and i < chr_ends[3]):
		lg_string1 = 'LGIV'
		start1 = (i - chr_starts[3]) * resolution
		end1 = start1 + resolution
		
	elif(i >= chr_starts[4] and i < chr_ends[4]):
		lg_string1 = 'LGV'
		start1 = (i - chr_starts[4]) * resolution
		end1 = start1 + resolution
		
	elif(i >= chr_starts[5] and i < chr_ends[5]):
		lg_string1 = 'LGVI'
		start1 = (i - chr_starts[5]) * resolution
		end1 = start1 + resolution
		
	elif(i >= chr_starts[6] and i < chr_ends[6]):
		lg_string1 = 'LGVII'
		start1 = (i - chr_starts[6]) * resolution
		end1 = start1 + resolution
	
	for j in range(0, array_x_dim):
	
		if(j >= chr_starts[0] and j < chr_ends[0]):
			lg_string2 = 'LGI'
			start2 = (j - chr_starts[0]) * resolution
			end2 = start2 + resolution
			
		elif(j >= chr_starts[1] and j < chr_ends[1]):
			lg_string2 = 'LGII'
			start2 = (j - chr_starts[1]) * resolution
			end2 = start2 + resolution
			
		elif(j >= chr_starts[2] and j < chr_ends[2]):
			lg_string2 = 'LGIII'
			start2 = (j - chr_starts[2]) * resolution
			end2 = start2 + resolution
			
		elif(j >= chr_starts[3] and j < chr_ends[3]):
			lg_string2 = 'LGIV'
			start2 = (j - chr_starts[3]) * resolution
			end2 = start2 + resolution
			
		elif(j >= chr_starts[4] and j < chr_ends[4]):
			lg_string2 = 'LGV'
			start2 = (j - chr_starts[4]) * resolution
			end2 = start2 + resolution
			
		elif(j >= chr_starts[5] and j < chr_ends[5]):
			lg_string2 = 'LGVI'
			start2 = (j - chr_starts[5]) * resolution
			end2 = start2 + resolution
			
		elif(j >= chr_starts[6] and j < chr_ends[6]):
			lg_string2 = 'LGVII'
			start2 = (j - chr_starts[6]) * resolution
			end2 = start2 + resolution

		value = float(lg_array[i,j])
		
		# filter out nan, -inf, +inf, 0.00 or position not starting and ending in k27me3 enriched regions
		if(
				np.isnan(value) == True or
				np.isposinf(value) == True or
				np.isneginf(value) or
				value == 0.00 or
				k27_array[i] == 0 or
				k27_array[j] == 0):
				
			pass
		
		else:
		
			value = np.log2(value)
	
			if(value >= 2.0):
	
				thickness = 3
				
				color = 'dpurple'
						
				if(lg_string1 == lg_string2):
				
					print(lg_string1+'\t'+str(start1)+'\t'+str(end1)+'\t'+lg_string2+'\t'+str(start2)+'\t'+str(end2))