# 03_correctBatch.py
# Jonathan M Galazka
#
# A simple modification of the Mirny Lab 03_03_heatmap_processing.py script available
# at https://bitbucket.org/mirnylab/hiclib
#
# Requires Mirny Lab scripts available at https://bitbucket.org/mirnylab/hiclib and all of their dependencies.
# 
# Usage: python ./03_correctBatch.py
# Use after 02_filterBatch.py to filter datasets and produce uncorrected heatmaps.
# Be sure to use a matching directory structure as in 01_mapBatch.py



import matplotlib.pyplot as plt
import numpy as np
import subprocess

from mirnylib import genome
from mirnylib import h5dict
from mirnylib import plotting
from hiclib import binnedData
from hiclib.binnedData import binnedDataAnalysis

datasets = ['dataset1']

for dataset in datasets:

	resolutions = [50000, 40000, 20000, 10000]
	
	for resolution in resolutions:
	
		res_string = str(resolution)
	
		genome_db = genome.Genome('/Users/galazkaj/genome/chromosomes/', readChrms=['#'])
	
		heatmap_path = '/Volumes/HD/HiC/' + dataset + '/' + dataset + '-hm-' + res_string + '.hdf5'
		
		export_path = '/Volumes/HD/HiC/' + dataset + '/' + dataset + '-ic-hm-' + res_string + '.hdf5'
		
		raw_heatmap = h5dict.h5dict(heatmap_path, mode='r') 
		BD = binnedData.binnedData(resolution, genome_db)
		BD.simpleLoad(heatmap_path, 'HindIII_GM_1')
		BD.removeDiagonal()
		BD.removeBySequencedCount(0.5)
		BD.removePoorRegions(cutoff=1)
		BD.truncTrans(high=0.0005)
		BD.iterativeCorrectWithoutSS(M=50)
	
		BD.export('HindIII_GM_1', export_path)

		unpacked_folder = '/Volumes/HD/HiC2/' + dataset + '/' + dataset + '-ic-hm-' + res_string + '-txt'
		h5dict_unpack_command = 'python ~/mirnylib/mirnylib/h5dictUtils/h5dictToTxt.py ' + export_path + ' ' + unpacked_folder
		subprocess.call(h5dict_unpack_command, shell=True)

	plt.show()
		