#!/usr/bin/python
#$ -e sim.div.log
#$ -o sim.div.log
#$ -S /usr/bin/python
#$ -cwd
#$ -r yes
#$ -l h_rt=240:00:00
#$ -t 1-2500
#$ -l arch=linux-x64
#$ -l mem_free=3G
#$ -l netapp=1G

# this code simulates 20 genes under the gravel demographic model, with selection
# on nonsynonymous sites according to the distribution of selection coefficients
# from Boyko et al (2008, Plos Genetics)

# first import some useful code from sfs_coder, os, and random
from sfscoder import command
import os
from random import randint

# initialize a new SFS_CODE command and put the simulations in a new directory, 'gravel.pathway'
com = command.SFSCommand(prefix='gravel.pathway')

# build the command line for the gravel model
# adding a simple selection model with a single selection coefficient on all selected sites
# to simulate, tennessen, simply replace 'gravel' with 'teennessen'

com.three_pop(N=7000,nsam=[5000,5000,0],nsim=2,model='gravel',L=['-L','20','1650'],sel=['-W','2','0','0','0','0.184','0.00040244'],rho=0.031,event=['-l','g','0.5','R'])

# set the location of sfs_code, will need to reset to the path on your machine
com.sfs_code_loc = 'path/to/sfs_code'

# execute the command, using a random seed generated by this random integer
com.execute(rand=randint(1,100000))
