#!/usr/bin/python
#$ -e sim.div.log
#$ -o sim.div.log
#$ -S /usr/bin/python
#$ -cwd
#$ -r yes
#$ -l h_rt=240:00:00
#$ -t 1-46
#$ -l arch=linux-x64
#$ -l mem_free=1G
#$ -l netapp=1G
 

# first, import the command module from sfscoder
# to run any of this code, you will first need to obtain bpth sfs_code and
# sfs_coder, available at:
#  http://sfscode.sourceforge.net/SFS_CODE/index/index.html
from sfscoder import command

# initialize a new command object
# the 'outdir' tells the command object how to name the simulation files
com = command.SFSCommand(outdir='gravel_TE')

# These parameters are useful for running this on a cluster, where we can use the job id to set the 
# end time for the simulation in coalescent units, which is stored in the variable TE.
# If you're not using SGE, the job id defaults to 1, but you could reset the id variable from the standard input
id = com.task_id
TE = (float(id)-1.)/100.

# this next line sets up the command line, with all the parameters as described in the text of Uricchio et a (2016) in Genome Research
com.line= ['1', '100', '-N', '2500', '-L', '50', '2000','-n', '250', '-A', '-t', '0.001', '-l','g','0.5', '-TE', str(TE), '-Td', '0', 'P', '0', '1.982738', '-Td', '0.265753', 'P', '0', '0.128575', '-Td', '0.342466', 'P', '0', '0.554541', '-Tg', '0.342466', 'P', '0', '55.48','-W','1','2.92','0','1']

# this just tells the script where sfs_code's binary is located on the machine
com.sfs_code_loc = 'path/to/sfs_code'

# execute the simulation
com.execute()


