#!/usr/bin/python
#$ -e sim.div.log
#$ -o sim.div.log
#$ -S /usr/bin/python
#$ -cwd
#$ -r yes
#$ -l h_rt=240:00:00
#$ -t 1-1
#$ -l arch=linux-x64
#$ -l mem_free=300M
#$ -l netapp=1G

# for more documentation on this and other methods, visit http://uricchio.github.io/sfs_coder/

# first we import some useful code

from sfscoder import sfs
import sys
import os

if len(sys.argv) != 4:
    print "usage: python pathway.gravel.py <sfs_code_simulation_file> <rho> <tau>"
    exit()

# next we tell the program where the sfs_code output is that we want to use to simulate our phenotypes is located 
sfs_code_sim = sys.argv[1]
rho=float(sys.argv[2])
tau=float(sys.argv[3])

# we initialize an sfs_coder data object and tell it where the SFS_CODE output is
data = sfs.SFSData(file=sfs_code_sim)

# now we have sfs_coder load all the simulation data into a data object
data.get_sims()

# for each simulation in the sfs_code data object, generate a random phenotype and print it out
for sim in data.sims:
    # varfile will contain the variance explained for each simulated gene, with the first column being the gene number
    # the second column contains the variance explained in population 0, which corresponds to the African continental group
    # the third column contains the variance explained in population 1, which corresponds to the European continental group
    # note that if there is more than one simulation in the file, you would need to use a different varfile for each one because
    # this script will currently overwrite this file with each iteration of this for-loop.
    varfile='varfile'
    
    # p is a dictionary of lists, indexed by population
    # p[0] is a list of the phenotypes of the individuals in population 0 (Africans)
    # p[1] is a list of the phenotypes of the individuals in population 1 (Europeans)
    
    # sim_pheno takes several parameters
    # method = 'SIMONS' corresponds to our generalized version of Simons et al's model
    # h_sq = 0.5 sets the overall heritability to 0.5
    # causal_pop=1 tells the software that Europeans will be used to set the heritability (heritability in Africans will hence be a radom variable)
    # rho is the value of rho as defined in our phenotype model 
    # tau is the value of tau as defined in our phenotype model 
    # loci tells the simulation which loci to use for generating the phenotypes.  In this case it is simply all the simulated loci
    # pops=[0,1] tells it to simulate for both Europeans and Africans
    # varfile=varfile tells it where to print store the values of variance explained for each gene on disk
    
    p = sim.sim_pheno(method='SIMONS',h_sq=0.5,causal_pop=1,rho=rho,loci=range(0,len(sim.command.L)),pops=[0,1],opp=0.5,tau=tau,printvars=True,varfile=varfile)
    
    # now we loop through the phenotype list for population 0 and print out each individual's value
    for pheno in p[0]:
        print pheno,
    print


