#This code calculates the site frequency as a function of time for a demographic model

# first import some libraries we will need
from sfscoder import wf
import sys

# below we specify the demographic events as a  list
# each event is series of three values, with the first number being the time of the event in coalescent units
# the second paramter is the size or rate of expansion or contraction, and the last is the type of event
# ("nu" is for step-wise chnages, "E" is for exponential growth)
# Note that time runs forward, so time "0" in this example is the first demographic event to occur

if len(sys.argv) != 2:
    print "usage: python calc_sfs.py <gamma>"
    print "gamma=2Ns is the population scaled selection coeffecient.  Note that the sign will be flipped in the script"
    exit()

demog_events=[[0.,1.982738,"nu"],[0.265753,0.128575,"nu"],[0.342466,0.554541,"nu"],[0.342466,55.48,"E"]]

# the value of a population scaled selection coefficient, given at the command line
gam = -1.*float(sys.argv[1])

# initialize a Wright-Fisher rescaled calculation .. . note that this does NOT account for linkage
# n is the number of samples
# N is the size of the ancestral population (meaning that the state space on the frequency throughout the calcuation is in discrete jumps of 1/(2N)
# t_print=True tells the program to print at each time step
# rowFac is used internally to the computation. Larger rowFac will have slightly higher accuracy but be more computationally expensive
# tMax is the end time in coalescent units
# demog_events is the list of demographic events, defined above
# gam is the value of the selection coefficient, given in units of 2Ns
# burnin is a burn-in time, which allows the computation to reach the ancestral steady-state before the calculation is performed
mywf = wf.WrightFish(n=250,eurG=False,N=1000,t_print=True,tMax=0.45,rowFac=10,demog_events=demog_events,gam=gam,burnin=0.1)

# run the calculation
mywf.calcSFS(gam=gam)

# the output prints to screen and is space delimited 
# the first column in the is the time in coalescent units
# the remaining columns correspond to the value of the site frequency spectrum for frequency 1/2N, 2/2N, 3/2N ... (2N-1)/2N

