#!/usr/bin/python
# -*- coding: utf-8 -*-

import re


def scorePostDel(pathAnc,name):
   score=[]
   ids=[]
   fileIn=open(pathAnc+name+'.postdel','r')
   chromoRef=0
   for line in fileIn:
      ls=line.split()
      chromo=ls[1]
      if chromo!=chromoRef:
         score.append([])
         ids.append([])
         chromoRef=chromo
         score[-1].append(float(ls[6]))
      score[-1].append(float(ls[7]))
      ids[-1].append(int(ls[5]))
   return ids,score

def interBlockScore(listConsPC,blocs,blocs1,blocs2,ids1,score1,ids2,score2):
   res=[]
   for i,ch in enumerate(listConsPC):
      res.append([])
      for j in range(-1,len(ch)):
         if j==-1:
            s1=s2=-1
         else:
            jB=abs(ch[j])-1
            if ch[j]>0:                        # pos as in G1
               lastG1=blocs1[jB][-1][1]
            else:                              # pos inversed compare to G1
               lastG1=blocs1[jB][0][0]
            if (ch[j]>0 and blocs[jB][1]) or (ch[j]<0 and not blocs[jB][1]):   # pos as in G2
               lastG2=blocs2[jB][-1][1]
            else:
               lastG2=blocs2[jB][0][0]
            s1=ids1[i].index(lastG1)
            s2=ids2[i].index(lastG2)
         if j==len(ch)-1:
            e1=len(score1[i])-1
            e2=len(score2[i])-1
         else:
            j1B=abs(ch[j+1])-1
            if ch[j+1]>0:                        # pos as in G1
               firstG1=blocs1[j1B][0][0]
            else:                                # pos inversed compare to G1
               firstG1=blocs1[j1B][-1][1]
            if (ch[j+1]>0 and blocs[j1B][1]) or (ch[j+1]<0 and not blocs[j1B][1]):  # pos as in G2
               firstG2=blocs2[j1B][0][0]
            else:
               firstG2=blocs2[j1B][-1][1]
            e1=ids1[i].index(firstG1)
            e2=ids2[i].index(firstG2)
         sf=min(min(score1[i][min(s1,e1)+1:max(s1,e1)+1]),min(score2[i][min(s2,e2)+1:max(s2,e2)+1]))
         res[-1].append(sf)
   return res

def reWrite(pathAnc4,pathAnc5,ancestralName,name1,name2,listConsPC,microScore,blocs,blocs1,blocs2,new2old1,new2old2,old2news1,dicoOrthos1,dicoOrthos2):
   # fileName = pathAnc+'5Ancestor/'+ancestralName+'.'+name1+'.'+name2
   # listCons : list des blocs ds l'ordre [1, 2, 3, 4, -5, 6, 8, 9, 11, 10, 12, -13]
   # blocs : [(chr,sign,%sim,len)]
   # blocs1 : [[newIDinS start : newIDinS end]]
   # new2old1 : {newIDinS 1 : oldID 1}
   # old2news1 : {oldID : [(name,newchr,newstd,newID/gene,newID/genome,samestd)]}
   # dicoOrthos1 : dico des ortho {newIDinS 1 : newIDinS 2}

   newfile=open(pathAnc5+ancestralName+'.'+name1+'.'+name2+'.def','w')
   newfile.write('chr\tid1\tid2\tstrand\t\tnewid\tscMacro\tscMicro\n')
   res=[]
   newid=1
   ids1,score1=scorePostDel(pathAnc4,name1)
   ids2,score2=scorePostDel(pathAnc4,name2)
   interBScore=interBlockScore(listConsPC,blocs,blocs1,blocs2,ids1,score1,ids2,score2)
   for k,ch in enumerate(listConsPC):
      newidChr=1
      for i in range(len(ch)):
         b=abs(ch[i])-1
         signB=ch[i]/abs(ch[i])
         signAbs=blocs[b][1]
         chromo=blocs[b][0]
         genes=[]
         if signB==1:
            for sb in blocs1[b]:
               for j in range(sb[0],sb[1]+1):
                  id1=new2old1[j]
                  if old2news1[id1][0][2]=='+':
                     s=1
                  else:
                     s=-1
                  ind=ids1[k].index(j)
                  if sb==blocs1[b][0] and j==sb[0]:
                     sp=interBScore[k][i]
                     sp_m=microScore[k][i]
                  else:
                     sp=score1[k][ind]
                     sp_m=1.01
                  if sb==blocs1[b][-1] and j==sb[1]:
                     sn=interBScore[k][i+1]
                     sn_m=microScore[k][i+1]
                  else:
                     sn=score1[k][ind+1]
                     sn_m=1.01
                  genes.append([id1,s,sp,sn,sp_m,sn_m])
         else:
            for sb in range(len(blocs1[b])-1,-1,-1):
               for j in range(blocs1[b][sb][1],blocs1[b][sb][0]-1,-1):
                  id1=new2old1[j]
                  if old2news1[id1][0][2]=='+':
                     s=-1
                  else:
                     s=1
                  ind=ids1[k].index(j)
                  if sb==len(blocs1[b])-1 and j==blocs1[b][sb][1]:
                     sp=interBScore[k][i]
                     sp_m=microScore[k][i]
                  else:
                     sp=score1[k][ind+1]
                     sp_m=1.01
                  if sb==0 and j==blocs1[b][sb][0]:
                     sn=interBScore[k][i+1]
                     sn_m=microScore[k][i+1]
                  else:
                     sn=score1[k][ind]
                     sn_m=1.01
                  genes.append([id1,s,sp,sn,sp_m,sn_m])
         if (signB==1 and signAbs) or (signB==-1 and not signAbs):
            ind=0
            for sb in blocs2[b]:
               for j in range(sb[0],sb[1]+1):
                  genes[ind].append(new2old2[j])
                  ind+=1
         else:
            ind=0
            for sb in range(len(blocs2[b])-1,-1,-1):
               for j in range(blocs2[b][sb][1],blocs2[b][sb][0]-1,-1):
                  genes[ind].append(new2old2[j])
                  ind+=1
         for g in genes:
            #print g
            newfile.write('%.3d\t%.5d\t%.5d\t%d\t%.5d\t%.5d\t(%.2f,%.2f)\t(%.2f,%.2f)\n'
            %(k+1,g[0],g[6],g[1],newidChr,newid,g[2],g[3],g[4],g[5]))
            newidChr+=1
            newid+=1
      res.append(newidChr-1)
   newfile.close() 
   return res

## outFile: S7.LAKL.prt (for the ancestor)
## inFile1: LAKL.prt (from the actual LAKL)
## inFile2: LAKL.ZYRO.def (the ancestor)
def writeNewprt(outFile,inFile1,inFile2,g):
   old2news1={}
   ligne=inFile1.readline()
   while ligne!='':
      ll=re.split("\t",ligne)
      old2news1[ll[8]]=[ll[0]]
      trad=''
      ligne=inFile1.readline()
      while not(re.match('>',ligne) or (ligne=='')):
         trad+=ligne
         ligne=inFile1.readline()
      old2news1[ll[8]].append(trad)
   dico2={}
   ligne=inFile2.readline()
   ligne=inFile2.readline()
   while ligne!='':
      ll=ligne.split()
      #dico2[ll[g]]=[ll[0],ll[3],ll[4],ll[5]]
      old=old2news1[ll[g]+'\n']
      if ll[3]=='-1':
         strand='-\tf\t'
      else:
         strand='+\tt\t'
      outFile.write(old[0]+"\t"+ll[0]+"\t0\t0\t"+strand+ll[4]+"\t"+ll[5]+"\t"+ll[5]+'\n'+old[1])
      ligne=inFile2.readline()

## inFile: S7.LAKL.prt 
## outFile1: S7.LAKL.def 
## outFile2: S7.LAKL.ch 
def writeNewdefch(prtFile,defFile,chFile):
   defFile.write('type\tname\t\tchr\tstart\tend\tstrand\tsens\tIDg/chr\tIDg/all\tIDf/all\n')
   Hdligne=prtFile.readline()
   ch=0
   endChromo=[]
   ec='000'
   while Hdligne!='':
      ll=re.split("\t",Hdligne)
      if ch!=ll[1]:
         ch=ll[1]
         chFile.write(str(int(ch))+'\t')
         endChromo.append(ec[:-1])
      ec=ll[8]
      ligne=prtFile.readline()
      while not(re.match('>',ligne) or (ligne=='')):
         ligne=prtFile.readline()
      defFile.write('gene\t'+Hdligne[1:])
      Hdligne=ligne
   endChromo.append(ec[:-1])
   chFile.write('\n'+'\t'.join(endChromo[1:])+'\t')
   chFile.write('\n'+'\t'.join(endChromo[1:])+'\t')
   print('fini')

def writeNewFiles(pathPart2,pathGenome,aName,name1,name2):

   outFile=open(pathPart2+aName+'.'+name1+'.prt','w')
   inFile1=open(pathGenome+name1+'.prt','r')
   inFile2=open(pathPart2+aName+'.'+name1+'.'+name2+'.def','r')
   writeNewprt(outFile,inFile1,inFile2,1)
   outFile.close(),inFile1.close(),inFile2.close()
   inFile=open(pathPart2+aName+'.'+name1+'.prt','r')
   outFile1=open(pathPart2+aName+'.'+name1+'.def','w')
   outFile2=open(pathPart2+aName+'.'+name1+'.ch','w')
   writeNewdefch(inFile,outFile1,outFile2)
   inFile.close(),outFile1.close(),outFile2.close()

   outFile=open(pathPart2+aName+'.'+name2+'.prt','w')
   inFile1=open(pathGenome+name2+'.prt','r')
   inFile2=open(pathPart2+aName+'.'+name1+'.'+name2+'.def','r')
   writeNewprt(outFile,inFile1,inFile2,2)
   outFile.close(),inFile1.close(),inFile2.close()
   inFile=open(pathPart2+aName+'.'+name2+'.prt','r')
   outFile1=open(pathPart2+aName+'.'+name2+'.def','w')
   outFile2=open(pathPart2+aName+'.'+name2+'.ch','w')
   writeNewdefch(inFile,outFile1,outFile2)
   inFile.close(),outFile1.close(),outFile2.close()

