#!/usr/bin/python
# -*- coding: utf-8 -*-
## Etudie les differentes inversions possibles



#######    combi    ################

def combi(dicosList1,dicosList2,blocs,blocs1,blocs2,new2old1,new2old2,path):
   blocs,blocs1,blocs2=fusion(blocs,blocs1,blocs2)
   list1,list2=listBlocsOrdered(blocs,blocs1,blocs2)
   
   print '\nFinally, there are',len(blocs),'blocks after fusion of successive blocks'
   print 'and they are ordered as follow in G2:\n',list2
   lost=onlyInversion(blocs,list1,list2)
   print 'We delete all small blocs (',lost,'genes) that disordered the blocs, now, ordered as follow in G2:\n',list2
   
   fileO=open(path+'MicroBlocks.txt','w')
   fileO.write("id\t[chr,sign,%sim,len]\t[bornes of G1's genes]\t[bornes of G2's genes] \n")
   for i in range(len(blocs)):
      fileO.write(str(i+1)+'\t'+str(blocs[i])+'\t'+str(blocs1[i])+'\t'+str(blocs2[i])+'\n')
   fileO.close()

## reecrire les .def
    
   fileO=open(path+'MicroDetails.txt','w')
   nbInv,listCons,microScore=consensus(list1,list2,blocs,blocs1,blocs2,dicosList1,dicosList2,new2old1,new2old2,fileO)
   fileO.close()
   print "There are",len(nbInv[0]),"micro-inversions from the ancestor to G1 of length:",nbInv[0]
   print "There are",len(nbInv[1]),"micro-inversions from the ancestor to G2 of length:",nbInv[1]
   print "There are",len(nbInv[2])," unlocalized micro-inversions (localized arbitrary in G2) of length:",nbInv[2]
   return listCons,microScore,nbInv
      
## Fusion of the small blocks following each other
def fusion(blocs,blocs1,blocs2):
   genes1=[]
   for b in blocs1:
      for born in b:
         for x in range(born[0],born[1]+1):
            genes1.append(x)
   genes2=[]
   for b in blocs2:
      for born in b:
         for x in range(born[0],born[1]+1):
            genes2.append(x)
   i=0
   while i<len(blocs)-1:
      bi=blocs[i]
      bi1=blocs[i+1]
      if bi[0]==bi1[0] and bi[1]==bi1[1]: # same chrom and same sign
         if bi[1]==1:   # positif
            if blocs2[i][-1][1]>blocs2[i+1][0][0]:
               nogene=0
            else:
               nogene=1
               for g in range(blocs2[i][-1][1]+1,blocs2[i+1][0][0]):
                  if g in genes2:
                     nogene=0
                     break
            if nogene:
               newbloc2=blocs2[i]+blocs2[i+1]
               del blocs2[i],blocs2[i]
               blocs2.insert(i,newbloc2)

         else:   # negatif
            if blocs2[i+1][-1][1]>blocs2[i][0][0]:
               nogene=0
            else:
               nogene=1
               for g in range(blocs2[i+1][-1][1]+1,blocs2[i][0][0]):
                  if g in genes2:
                     nogene=0
                     break
            if nogene:
               newbloc2=blocs2[i+1]+blocs2[i]
               del blocs2[i],blocs2[i]
               blocs2.insert(i,newbloc2)
         if nogene:
            newbloc=[bi[0],bi[1],(bi[2]*bi[3]+bi1[2]*bi1[3])/(bi[3]+bi1[3]),bi[3]+bi1[3]]
            del blocs[i],blocs[i]
            blocs.insert(i,newbloc)
            newbloc1=blocs1[i]+blocs1[i+1]
            del blocs1[i],blocs1[i]
            blocs1.insert(i,newbloc1)
         else:
            i+=1
      else:
         i+=1
   return blocs,blocs1,blocs2

def listBlocsOrdered(blocs,blocs1,blocs2):
   list1=[]
   list2=[]
   chromo=0
   for i,bloc in enumerate(blocs):
      if bloc[0]!=chromo:
         list1.append([])
         list2.append([])
         chromo=bloc[0]
      list1[-1].append(i+1)
      if bloc[1]:
         signe=1
      else:
         signe=-1
      ins=0
      for j,b in enumerate(list2[-1]):
         if blocs2[i][0][0]<blocs2[abs(b)-1][0][0]:
            list2[-1].insert(j,(i+1)*signe)
            ins=1
            break
      if not ins:
         list2[-1].append((i+1)*signe)
   return list1,list2

def onlyInversion(blocs,list1,list2):
   lost=0
   for ch1,ch2 in zip(list1,list2):
      i=0
      while i<len(ch1):
         n1=ch1[i]
         n2=ch2[i]
         if abs(n1)==abs(n2):
            i+=1
         else:
            b1=blocs[abs(n1)-1]
            b2=blocs[abs(n2)-1]
            if b1[3]<b2[3] or (b1[3]==b2[3] and b1[2]<=b2[2]):
               lost+=b1[3]
               ch1.remove(n1)
               if n1 in ch2:
                  ch2.remove(n1)
               else:
                  ch2.remove(-1*n1)
            else:
               lost+=b2[3]
               ch2.remove(n2)
               if n2 in ch1:
                  ch1.remove(n2)
               else:
                  ch1.remove(-1*n2)
   return lost
################################################
# cycle version
################################################
class Brkpt(object):
   "Definition of a breakpoint"
   def __init__(self,g,left,right):
      self.genome=g
      self.left=left
      self.right=right
      self.leftBrk=0
      self.rightBrk=0
      self.score=0
   def getScore(self):
      return min(1,self.score/100.)
   def __eq__(self,other):
      return (self.genome==other.genome and self.left==other.left 
      and self.right==other.right)
   def __repr__(self):
      return str((self.left,self.right))
def list2brk(g,liste):
   res=[]
   res.append(Brkpt(g,0,liste[0]))
   for i in range(len(liste)-1):
      res.append(Brkpt(g,liste[i],liste[i+1]))
   res.append(Brkpt(g,liste[-1],0))
   return res
def leftRigthBrk(liste1,liste2):
   for b1 in liste1:
      for b2 in liste2:
         if b1.left and (b1.left==b2.left or b1.left==-1*b2.right):
            b1.leftBrk=b2
         if b1.right and (b1.right==b2.right or b1.right==-1*b2.left):
            b1.rightBrk=b2
         if b2.left and (b1.left==b2.left or b1.right==-1*b2.left):
            b2.leftBrk=b1
         if b2.right and (b1.left==-1*b2.right or b1.right==b2.right):
            b2.rightBrk=b1
def brk2cycle(liste1,liste2):
   liste1=[liste1[-1]]+liste1[:len(liste1)-1]
   res=[]
   treated=[]
   for i in range(len(liste1)):
      b1=liste1[i]
      if b1 not in treated:
         treated.append(b1)
         l1=[b1]
         l2=[]
         if b1.left==0 or b1.right==0:
            if b1.left==0:
               b2=b1.rightBrk
               l2.append(b2)
            else:
               b2=b1.leftBrk
               l2.append(b2)
            while b2.left!=0 and b2.right!=0:
               if b2.leftBrk!=b1:
                  b1=b2.leftBrk
               else:
                  b1=b2.rightBrk
               l1.append(b1)
               treated.append(b1)
               if b1.leftBrk!=b2:
                  b2=b1.leftBrk
               else:
                  b2=b1.rightBrk
               l2.append(b2)
               if not b2:
                  liste2=[liste2[-1]]+liste2[:len(liste2)-1]
                  return [(liste1,liste2)]
         else:
            b2=b1.rightBrk
            l2.append(b2)
            if b2.leftBrk!=b1:
               b1=b2.leftBrk
            else:
               b1=b2.rightBrk
            while b1 not in treated:
               l1.append(b1)
               treated.append(b1)
               if b1.left and b1.leftBrk!=b2:
                  b2=b1.leftBrk
               else:
                  b2=b1.rightBrk
               l2.append(b2)
               if b2.leftBrk!=b1:
                  b1=b2.leftBrk
               else:
                  b1=b2.rightBrk
         res.append((l1,l2))
   return res
def score1(l1,blocs1,dicoList1,new2old1):
   nbG3=len(dicoList1)
   for b1 in l1:
      left=b1.left
      right=b1.right
      if left and right:
         sl=left/abs(left)*-1
         sr=right/abs(right)
         p1i=listFirstOrths(blocs1[abs(left)-1],dicoList1,new2old1,sl)
         a1i=listFirstOrths(blocs1[abs(right)-1],dicoList1,new2old1,sr)
         inv1=0
         noi1=0
         for g3 in range(nbG3):#pour chaque outgroup
            i,n=maxClose(p1i[g3],a1i[g3])
            inv1=max(inv1,i)
            noi1=max(noi1,n)
         b1.score=noi1
      else:
         b1.score=0
def score2(l2,blocs,blocs2,dicoList2,new2old2):
   nbG3=len(dicoList2)
   for b2 in l2:
      left=b2.left
      right=b2.right
      if left and right:
         sl=left/abs(left)*-1*(1 if blocs[abs(left)-1][1] else -1)
         sr=right/abs(right)*(1 if blocs[abs(right)-1][1] else -1)
         p2i=listFirstOrths(blocs2[abs(left)-1],dicoList2,new2old2,sl)
         a2i=listFirstOrths(blocs2[abs(right)-1],dicoList2,new2old2,sr)
         inv2=0
         noi2=0
         for g3 in range(nbG3):#pour chaque outgroup
            i,n=maxClose(p2i[g3],a2i[g3])
            inv2=max(inv2,i)
            noi2=max(noi2,n)
         b2.score=noi2
      else:
         b2.score=0
def scoreV(l):
   for b in l:
      b.score=1.01
def brl2list(liste):
   liste=liste[1:]+[liste[0]]
   res=[]
   score=[]
   p=0
   while liste:
      #print p,liste
      i=0
      b=liste[i]
      while b.left!=p and b.right*-1!=p:
         i+=1
         b=liste[i]
      if b.left==p:
         res.append(b.right)
         p=b.right
      else:
         res.append(b.left*-1)
         p=b.left*-1
      score.append(b.getScore())
      liste.remove(b)
   score=[1.01]+score[1:len(score)-1]+[1.01]
   return res[:len(res)-1],score


def consensus(list1,list2,blocs,blocs1,blocs2,dicoList1,dicoList2,new2old1,new2old2,fileO):
   fileO.write('')
   listCons=[]
   microScore=[]
   invG1,invG2,invG=[],[],[]
   for k in range(len(list1)):
      brkList1=list2brk(1,list1[k])
      brkList2=list2brk(2,list2[k])
      leftRigthBrk(brkList1,brkList2)
      if not len(filter(lambda x:x<0,list2[k])): # all pos
         lC,mS=brl2list(brkList1)
      elif not len(filter(lambda x:x>0,list2[k])): # all neg
         l1=brkList1
         l2=brkList2
         score1(l1,blocs1,dicoList1,new2old1)
         score2(l2,blocs,blocs2,dicoList2,new2old2)
         sum1=sum(map(lambda x:x.score,l1))
         sum2=sum(map(lambda x:x.score,l2))
         if sum1>=sum2:
            lC,mS=brl2list(l1)
            l2.sort(key=lambda x:abs(x.left))
            if sum1>sum2:
               for i in range(len(l2)-1):
                  li=blocs[abs(l2[i].right)-1][3]
                  invG2.append(li)
            else:
               for i in range(len(l2)-1):
                  li=blocs[abs(l2[i].right)-1][3]
                  invG.append(li)
         elif sum1<sum2:
            lC,mS=brl2list(l2)
            l1.sort(key=lambda x:abs(x.left))
            for i in range(len(l1)-1):
               li=blocs[abs(l1[i].right)-1][3]
               invG1.append(li)
      else:
         cycle=brk2cycle(brkList1,brkList2)
         validated=[]
         for c in cycle:
            l1,l2=c
            if len(l1)==1:
               validated.append(l1[0])
               scoreV(l1+l2)
            else:
               score1(l1,blocs1,dicoList1,new2old1)
               score2(l2,blocs,blocs2,dicoList2,new2old2)
               sum1=sum(map(lambda x:x.score,l1))
               sum2=sum(map(lambda x:x.score,l2))
               if sum1>=sum2:
                  validated.extend(l1)
                  l2.sort(key=lambda x:abs(x.left))
                  if sum1>sum2:
                     if len(l2)==2:
                        fileO.write('1 inv in G2, the bloc '+str(abs(l2[0].right)))
                        fileO.write(' ('+str(blocs[abs(l2[0].right)-1][3])+' genes): ')
                        fileO.write(str(sum1)+'>'+str(sum2)+'\n')
                     for i in range(len(l2)-1):
                        li=blocs[abs(l2[i].right)-1][3]
                        invG2.append(li)
                  else:
                     for i in range(len(l2)-1):
                        li=blocs[abs(l2[i].right)-1][3]
                        invG.append(li)
               elif sum1<sum2:
                  validated.extend(l2)
                  l1.sort(key=lambda x:abs(x.left))
                  if len(l1)==2:
                     fileO.write('1 inv in G1, the bloc '+str(abs(l1[0].right)))
                     fileO.write(' ('+str(blocs[abs(l1[0].right)-1][3])+' genes): ')
                     fileO.write(str(sum1)+'<'+str(sum2)+'\n')
                  for i in range(len(l1)-1):
                     li=blocs[abs(l1[i].right)-1][3]
                     invG1.append(li)
         lC,mS=brl2list(validated)
      microScore.append(mS)
      listCons.append(lC)
      
   # et on recommence
   print 'and the ancestral order is:\n',listCons
   return [invG1,invG2,invG],listCons,microScore


def maxClose(list1,list2):
   close=[0,0]
   for (g,s) in list1:
      for (gg,ss) in list2:
         if abs(gg-g)<10:
            if s==ss:
               close[1]+=10-abs(gg-g)
            else:
               close[0]+=10-abs(gg-g)
   return close

#######
# les 5 1er genes chez l'outgroup pour chacun
def listFirstOrths(bornes,dicoG3,new2old,signe):
   res=[]#list de lists d'ortho for each outgroup
   for d in dicoG3:
      res.append([])
   if signe==1:
      for borne in bornes:
         for i in range(borne[0],borne[1]+1):
            g=new2old[i]
            for d,dic in enumerate(dicoG3):
               if g in dic.keys():
                  if len(res[d])<5:
                     res[d].extend(dic[g])
   else:
      for borne in sorted(bornes,reverse=True):
         for i in range(borne[1],borne[0]-1,-1):
            g=new2old[i]
            for d,dic in enumerate(dicoG3):
               if g in dic.keys():
                  if len(res[d])<5:
                     res[d].extend(dic[g])
   return res












      
