#!/usr/bin/env python
# -*- coding: utf-8 -*-
## Cree le fichier orth.pairs

import re

def orthPairsCh(group,pathPart1,pathPart2,name1,name2):
    
   old_sign1=oldChRead('../../'+group+'/01Genomes/'+name1+'.def')
   old_sign2=oldChRead('../../'+group+'/01Genomes/'+name2+'.def')
   ## dico1={oldID:[(name,newchr,+/-,newID/chr,newID,mme signe ou pas),...]} from the ancestral .def
   old2news1,macro_score1=chRead(pathPart2+name1+'.def',old_sign1)
   old2news2,macro_score2=chRead(pathPart2+name2+'.def',old_sign2)

   ch1ch2pairs=open(pathPart2+name1+'.'+name2+'.orth.pairs','w')
   pairsFile=open(pathPart1+'.orth.pairs','r')
   for line in pairsFile:
      lineList=re.split(' ',line)
      if int(lineList[4]) in old2news1.keys() and int(lineList[9]) in old2news2.keys():
         for g1 in old2news1[int(lineList[4])]:
            for g2 in old2news2[int(lineList[9])]:
               if g1[1]==g2[1]:    # meme chr
                  ch1ch2pairs.write(g1[0]+' %.3d'%int(g1[1])+
                  " %.5d " %(int(lineList[4]))+g1[3]+" %.5d " %(g1[4])+
                  g2[0]+' %.3d'%int(g2[1])+" %.5d " %(int(lineList[9]))+
                  g2[3]+" %.5d " %(g2[4])+lineList[10]+' '+
                  str(int(g1[2]==g2[2]))+'\n')
   print len(old2news1.keys()),'genes in',name1+'.def'
   print len(old2news2.keys()),'genes in',name2+'.def\n'
   ch1ch2pairs.close()
   pairsFile.close()
   return old_sign1,old_sign2,old2news1,old2news2,macro_score1,macro_score2

## return the sign of a given gene (ID) in the actual genome
def oldChRead(nameFile):
   fileCh=open(nameFile,'r')
   fileCh.readline()
   old_sign={}
   for line in fileCh:
      lineList=re.split('\t',line)
      old_sign[int(lineList[9])]=lineList[5]
   fileCh.close()
   return old_sign
    
## read the ancestral genome
## old2news = { old_ID = [(name,chr,strand,newID_gene,newID_genome,same_strand?)..] }
## macro_score = { old_ID = (prev_sc, post_sc) }
def chRead(nameFile,signe):
   fileCh=open(nameFile,'r')
   old2news={}
   macro_score={}
   for line in fileCh:
      lineList=re.split('\t',line)
      if int(lineList[7]) in old2news.keys():
         old2news[int(lineList[7])].append((lineList[1],lineList[2],lineList[5],lineList[8],
         int(lineList[9]),signe[int(lineList[7])]==lineList[5]))
         if lineList[5]=='+':
            macro_score[int(lineList[7])].append((float(lineList[10]),float(lineList[11]))) 
         else:
            macro_score[int(lineList[7])].append((float(lineList[11]),float(lineList[10]))) 
      else:
         old2news[int(lineList[7])]=[(lineList[1],lineList[2],lineList[5],lineList[8],
         int(lineList[9]),signe[int(lineList[7])]==lineList[5])]
         if lineList[5]=='+':
            macro_score[int(lineList[7])]=[(float(lineList[10]),float(lineList[11]))]
         else:
            macro_score[int(lineList[7])]=[(float(lineList[11]),float(lineList[10]))]
   fileCh.close()
   return old2news,macro_score


## les genes ancestraux sont renumerotés en prenant en compte que ceux qui ont
## un ortho ds les 2 versions
def modifDico(pathPart2,name1,name2,old2news1,old2news2):
   ch1ch2pairs=open(pathPart2+name1+'.'+name2+'.orth.pairs','r')
   old1=[]
   temp1={}
   old2=[]
   temp2={}
   for line in ch1ch2pairs:
      lineList=re.split(' ',line)
      #old=int(lineList[2])
      old1.append(int(lineList[2]))
      old2.append(int(lineList[7]))
      #newBis=int(lineList[3])
      temp1[int(lineList[4])]=int(lineList[3]) # temp[new]=newBis
      temp2[int(lineList[9])]=int(lineList[8]) 
   ch1ch2pairs.close()
   for g in old2news1.keys():
      if g in old1:
         for i in range(len(old2news1[g])-1,-1,-1):
            o=old2news1[g][i]
            if o[4] in temp1:
               old2news1[g][i]=(o[0],o[1],o[2],o[3],temp1[o[4]],o[5])
            else:
               del old2news1[g][i]
      else:
         del old2news1[g]
   for g in old2news2.keys():
      if g in old2:
         for i in range(len(old2news2[g])-1,-1,-1):
            o=old2news2[g][i]
            if o[4] in temp2:
               old2news2[g][i]=(o[0],o[1],o[2],o[3],temp2[o[4]],o[5])
            else:
               del old2news2[g][i]
      else:
        del old2news2[g]

def rewriteDef(pathMacro,pathMicro,name1,name2):
   orthPairs=open(pathMacro+name1+'.'+name2+'.orth.pairs','r')
   oldnew2new1={}
   oldnew2new2={}
   for line in orthPairs:
      ls=line.split()
      oldnew2new1[int(ls[4])]=int(ls[3]) # oldnew2new[oldnew]=newBis
      oldnew2new2[int(ls[9])]=int(ls[8])
   orthPairs.close()
  
   for name,dico in zip([name1,name2],[oldnew2new1,oldnew2new2]):
      defFile=open(pathMacro+name+'.def','r')
      chOldnewScore=[]
      for line in defFile:
         ls=line.split()
         chOldnewScore.append([int(ls[2]),int(ls[9]),float(ls[10]),float(ls[11])]) 
      defFile.close()
      nbDel=0
      i=0
      while i<len(chOldnewScore):
         (ch,oldNew,scPrev,scNext)= chOldnewScore[i]
         if oldNew in dico:
            i+=1
         else:
            if i!=0 and chOldnewScore[i-1][0]==ch:
               chOldnewScore[i-1][3]=min(scPrev,scNext)
            if i!=len(chOldnewScore)-1 and chOldnewScore[i+1][0]==ch:
               chOldnewScore[i+1][2]=min(scPrev,scNext)
            del chOldnewScore[i]
      oldnew2score={}
      for (ch,oldNew,scPrev,scNext) in chOldnewScore:
         oldnew2score[oldNew]=(scPrev,scNext)
      newdef=open(pathMicro+name+'.predel','w')
      defFile=open(pathMacro+name+'.def','r')
      for line in defFile:
         ls=line.split()
         if int(ls[9]) in oldnew2score:
            newdef.write(ls[1]+'\t'+ls[2]+'\t'+ls[5]+'\t'+ls[7]+'\t'+ls[9]+
            '\t%.5d\t%.2f\t%.2f\n'%(dico[int(ls[9])],oldnew2score[int(ls[9])][0],
            oldnew2score[int(ls[9])][1]))
      defFile.close()
      newdef.close()
  


