#!/usr/bin/python
# -*- coding: utf-8 -*-
## n09ChromoConstruct
## Compare the linkedBlocs found for 2 genomes to a outgroup


from n00Objets import *


def constructChromo(brkpts,brkptsCrees,blocsNonValides,blocsValides,path):
   #print "BREAK"
   #for b in brkpts:
      #print b,b.valScore

   blocs1,blocs2=blocsValides
   ## find the order of the chromosome
   #### CONSTRUCTION OF CHROMO  
   print "\n\nCONTIGS ASSEMBLY :",  
   listeResult=[]
   l=[]
   cass,bloc,(sign1,sign2),s=leftest(brkpts,brkptsCrees)

   # le 1er brkpt
   if cass==0:
      l.append(0)
   else:
      sb=sInv(cass.name[-1])
      if 'G1' in cass.name:
         bGV=blocs2[blocs1.index(cass)]
         sV=sInv(bGV.name[-1])
         l.append((cass,sign1*sb,bGV,sign1*cass.sign*bGV.sign*sV,s))
      else:
         bGV=blocs1[blocs2.index(cass)] 
         sV=sInv(bGV.name[-1])
         l.append((bGV,sign1*cass.sign*bGV.sign*sV,cass,sign1*sb,s))

   sb=sInv(bloc.name[-1])
   if 'G1' in bloc.name:
      bGV=blocs2[blocs1.index(bloc)]
      sV=sInv(bGV.name[-1])
      l.append((bloc,sign2*sb,bGV,sign2*bloc.sign*bGV.sign*sV,s))
   else:
      bGV=blocs1[blocs2.index(bloc)]
      sV=sInv(bGV.name[-1])
      l.append((bGV,sign2*bloc.sign*bGV.sign*sV,bloc,sign2*sb,s))

   # le reste
   while brkpts!=[] or brkptsCrees!=[]:
      res=0
      for b in brkpts:
         s=b.valScore
         if ((b.gauche!=0 and (b.gauche==bloc or b.gauche.blockG==bloc))
            or (b.droit!=0 and (b.droit.blockG==bloc or b.droit==bloc))):
            brkpts.remove(b)
            res=1
            if ((b.gauche!=0 and (b.gauche==bloc or b.gauche.blockG==bloc)) and b.droit!=0): 
               sb=sInv(b.droit.name[-1])
               if 'G1' in b.droit.name:
                  bGV=blocs2[blocs1.index(b.droit)]
                  sV=sInv(bGV.name[-1])
                  l.append((b.droit,1*sb,bGV,b.droit.sign*bGV.sign*sV,s))
               else:
                  bGV=blocs1[blocs2.index(b.droit)]
                  sV=sInv(bGV.name[-1])
                  l.append((bGV,b.droit.sign*bGV.sign*sV,b.droit,1*sb,s))
               bloc=b.droit

            elif (((b.droit!=0) and (b.droit.blockG==bloc or b.droit==bloc)) and (b.gauche!=0)):
               sb=sInv(b.gauche.name[-1])
               if 'G1' in b.gauche.name:
                  bGV=blocs2[blocs1.index(b.gauche)]
                  sV=sInv(bGV.name[-1])
                  l.append((b.gauche,-1*sb,bGV,-1*b.gauche.sign*bGV.sign*sV,s))
               else:
                  bGV=blocs1[blocs2.index(b.gauche)]
                  sV=sInv(bGV.name[-1])
                  l.append((bGV,-1*b.gauche.sign*bGV.sign*sV,b.gauche,-1*sb,s))
               bloc=b.gauche
            ## un TELO de fin, new breakpoint
            else:
               l.append(0)  
               listeResult.append(l)
               if brkpts!=[]:
                  l=[]
                  cass,bloc,(sign1,sign2),ss=leftest(brkpts,brkptsCrees)
                  if cass==0:
                     l.append(0) 
                  else:
                     sb=sInv(cass.name[-1])
                     if 'G1' in cass.name:
                        bGV=blocs2[blocs1.index(cass)]
                        sV=sInv(bGV.name[-1])
                        l.append((cass,sign1*sb,bGV,sign1*cass.sign*bGV.sign*sV,ss))
                     else:
                        bGV=blocs1[blocs2.index(cass)] 
                        sV=sInv(bGV.name[-1])
                        l.append((bGV,sign1*cass.sign*bGV.sign*sV,cass,sign1*sb,ss))
                  sb=sInv(bloc.name[-1])
                  if 'G1' in bloc.name:
                     bGV=blocs2[blocs1.index(bloc)]
                     sV=sInv(bGV.name[-1])
                     l.append((bloc,sign2*sb,bGV,sign2*bloc.sign*bGV.sign*sV,ss))
                  else:
                     bGV=blocs1[blocs2.index(bloc)]
                     sV=sInv(bGV.name[-1])
                     l.append((bGV,sign2*bloc.sign*bGV.sign*sV,bloc,sign2*sb,ss))    
            break
    
      if res==0:        ### on test les nouveaux breakpoints
         for bCree in brkptsCrees:
            (bG,bD),s=bCree
            if bD==0:
               if bG[0]==bloc or bG[2]==bloc:
                  res=0
                  l.append(0)
                  brkptsCrees.remove(bCree)
        
            else:
               (bG1,sG1,bG2,sG2)=bG
               (bD1,sD1,bD2,sD2)=bD
               if bG1==bloc or bG2==bloc:
                  res=2
                  ssD1=sInv(bD1.name[-1])
                  ssD2=sInv(bD2.name[-1])
                  l.append((bD1,sD1*ssD1,bD2,sD2*ssD2,s))
                  bloc=bD1
                  brkptsCrees.remove(bCree)

               elif bD1==bloc or bD2==bloc:
                  res=2
                  ssG1=sInv(bG1.name[-1])
                  ssG2=sInv(bG2.name[-1])
                  l.append((bG1,sG1*ssG1,bG2,sG2*ssG2,s))
                  bloc=bG1
                  brkptsCrees.remove(bCree)    

      if res==0:
         listeResult.append(l)
         if brkpts!=[] or brkptsCrees!=[]:
            l=[]
            cass,bloc,(sign1,sign2),ss=leftest(brkpts,brkptsCrees)

            # le 1er brkpt
            if cass==0:
               l.append(0)    
            else:
               sb=sInv(cass.name[-1])
               if 'G1' in cass.name:
                  bGV=blocs2[blocs1.index(cass)]
                  sV=sInv(bGV.name[-1])
                  l.append((cass,sign1*sb,bGV,sign1*cass.sign*bGV.sign*sV,ss))
               else:
                  bGV=blocs1[blocs2.index(cass)]
                  sV=sInv(bGV.name[-1])
                  l.append((bGV,sign1*cass.sign*bGV.sign*sV,cass,sign1*sb,ss))
            sb=sInv(bloc.name[-1])  
            if 'G1' in bloc.name:
               bGV=blocs2[blocs1.index(bloc)]
               sV=sInv(bGV.name[-1])
               l.append((bloc,sign2*sb,bGV,sign2*bloc.sign*bGV.sign*sV,ss))
            else:
               bGV=blocs1[blocs2.index(bloc)]
               sV=sInv(bGV.name[-1])
               l.append((bGV,sign2*bloc.sign*bGV.sign*sV,bloc,sign2*sb,ss))
   if l not in listeResult:
      listeResult.append(l)
   for i in range(len(blocsNonValides[1])):
      b1=blocsNonValides[0][i]
      s1=sInv(b1.name[-1])
      b2=blocsNonValides[1][i]
      s2=sInv(b2.name[-1])
      listeResult.append([(b1,b1.sign*s1,b2,b2.sign*s2,0)])
   #print 'brkpts',brkpts 

   listeResult.sort(key=lambda x:sum(map(lambda c:len(c[0].genes)+len(c[2].genes) if c else 0,x)),reverse=True)

   print len(listeResult), 'ANCESTRAL CONTIGS'
   fileO=open(path+'MacroBlocks.txt','w')
   for ch in listeResult:
      fileO.write('[\n')
      for c in ch:
         if c==0:
            fileO.write('  0\n')
         else:
            fileO.write(('-' if c[1]==-1 else '')+c[0].name)
            fileO.write(' chr'+str(c[0].chromo)+' '+str(c[0].bornes))
            fileO.write(' , '+('-' if c[3]==-1 else '')+c[2].name)
            fileO.write(' chr'+str(c[2].chromo)+' '+str(c[2].bornes)+' : sc='+str(c[4])+'\n')
      fileO.write(']\n')
   fileO.close()
   return listeResult

## find the breakpoint with start to
# the new contig/chromo among brkpts (even created)
def leftest(brkpts,brkptsCrees):
   circular=[]
   ## look for telomere
   for b in brkpts:
      s=b.valScore
      if b.gauche==0:
         brkpts.remove(b)
         return 0,b.droit,(1,1),s
      elif b.droit==0:
         brkpts.remove(b)
         return 0,b.gauche,(-1,-1),s
   for brk in brkptsCrees:
      (b1,b2),s=brk
      if b2==0:
         brkptsCrees.remove(brk)
         return 0,b1[0],(-1*b1[1],b1[1]),s
   i=0
   ## look for another start (no more telomere)
   if brkpts!=[]:
      b=brkpts[i]
      s=b.valScore
      bg=b.gauche
      bd=b.droit
      bGauche=b.gauche#realBl(b.gauche)
      bDroit=b.droit#realBl(b.droit)
   else:
      (b1,b2),s=brkptsCrees[0]
      if len(brkptsCrees[0])==1:
         brkptsCrees.remove(brk)
         return b1[0],b2[0],(-1*b1[1],b2[1]),s
      else:
         bg=b1[0]
         bd=b2[0]
   while (1):
      res=[0,0,0]
      # in normal breakpoint
      for j in range(len(brkpts)):
         bb=brkpts[j]
         ss=bb.valScore
         if bb!=b:
            ## for A1 in (A1,B1) we look for (C1,A1) or (C2,A2) or (A2,B2)
            if (bg==bb.droit or bGauche==bb.droit.blockG
               or bGauche==bb.gauche.blockG):
               res[1]+=1
            ## for B1 in (A1,B1) we look for (B1,C1) or (C2,B2) or (B2,C2)
            if (bd==bb.gauche or bDroit==bb.droit.blockG
                  or bDroit==bb.gauche.blockG):
               res[0]-=1
      # in created breakpoint
      for (bb1,bb2),ss in brkptsCrees[:]:
         ## for A1 in (A1,B1) we look for A1
         if (bg==bb1[0] or bg==bb1[2] or
               bg==bb2[0] or bg==bb2[2]):
            res[1]+=1
            res[2]+=1
         if (bd==bb1[0] or bd==bb1[2] or
               bd==bb2[0] or bd==bb2[2]):
            res[0]-=1
            res[2]+=1
      if (res[0]+res[1]==1 or
         (brkpts==[] and 2==res[2]) or
         (res[0]==0 and res[1]==1)):  #le droit est seul ou une seule adjacence
         if brkpts!=[]:
            brkpts.remove(b)
            return b.droit,b.gauche,(-1,-1),s
         else:
            brkptsCrees.remove(((b1,b2),s))
            return b2[0],b1[0],(-1*b2[1],b1[1]),s
      elif res[0]+res[1]==-1:
         if brkpts!=[]:
            brkpts.remove(b)
            return b.gauche,b.droit,(1,1),s
         else:
            brkptsCrees.remove(((b1,b2),s))
            return b1[0],b2[0],(-1*b1[1],b2[1]),s
      i+=1
      if brkpts==[]:
         if i==len(brkptsCrees):
            if res[0]==-1:# circular
               circular.append(brkptsCrees[i-1])
               circular.sort(key=lambda x:x[1])
               print "\none circular -> we remove ",circular[0][0]
               if circular[0] in brkpts:
                  brkpts.remove(circular[0])
               else:
                  print "\none circular -> we remove ",circular[0][0][0],circular[0][0][2]
                  brkptsCrees.remove(circular[0])
               return leftest(brkpts,brkptsCrees)
            else:
               b,s=brkptsCrees[i-1]
               brkptsCrees.remove(brkptsCrees[i-1])
               return b1[0],b2[0],(b1[1],b2[1]),s
         else:
            if res[0]==-1:# circular
               circular.append(brkptsCrees[i-1])
            (b1,b2),s=brkptsCrees[i]
            bg=b1[0]
            bd=b2[0]
      else:
         if i==len(brkpts):
            if res[0]==-1:# circular
               circular.append(brkpts[i-1])
               circular.sort(key=lambda x:x.valScore)
               print "\none circular -> we remove ",circular[0]
               if circular[0] in brkpts:
                  brkpts.remove(circular[0])
               else:
                  brkptsCrees.remove(circular[0])
               return leftest(brkpts,brkptsCrees)
            else:
               b=brkpts[i-1]
               s=b.valScore
               brkpts.remove(brkpts[i-1])
               return b.gauche,b.droit,(1,1),s
         else:
            if res[0]==-1:# circular
               circular.append(brkpts[i-1])
            b=brkpts[i]
            s=b.valScore
            bg=b.gauche
            bd=b.droit
            bGauche=b.gauche#realBl(b.gauche)
            bDroit=b.droit#realBl(b.droit)


#pour prendre en compte les inclus inverse ds les chromos
def sInv(lettre):
   if lettre=='-':
      return -1
   else:
      return 1

# small fonction to have Block instead of Blockv
def realBl(b):
   if b==0:
      return 0
   else:
      if 'v' in b.name:
         return b.block
      else:
         return b

