#!/usr/bin/env python
# -*- coding: utf-8 -*-
## n08WriteBrkpts
## Compare the linkedBlocs found for 2 genomes to a outgroup

from n00Objets import *


## fonction qui ecrit les breakpoints d'un cycle
def writeBrkpts(fileBrkpt,c):
   for k in [0,1]:
      if not k:
         brkpts=c.breakpoints1
      else:
         brkpts=c.breakpoints2
      for br in [b for b in brkpts if b.valid==1]:
         writeBrkpt(fileBrkpt,br,'NON')
      for br in [b for b in brkpts if b.valid==-1]:
         writeBrkpt(fileBrkpt,br,'POST')
      for br in [b for b in brkpts if b.valid==0]:
         writeBrkpt(fileBrkpt,br,'NorP')
   fileBrkpt.write('\n')

## fonction qui ecrit les breakpoints en contradiction
def writeContradict(fileContradict,b,bList):
   for bl in bList:
      writeBrkpt(fileContradict,b,'',contradict=1)
      for i in range(len(b.outgroups)): 
         fileContradict.write('\t'+b.outgroups[i]+'\t'+str(b.score)+'\n')
      writeBrkpt(fileContradict,bl,'',contradict=1)
      for i in range(len(bl.outgroups)): 
         fileContradict.write('\t'+bl.outgroups[i]+'\t'+str(bl.score)+'\n')
      fileContradict.write('\n')

## fonction qui ecrit un breakpoint
def writeBrkpt(fileBrkpt,brk,nonPost,contradict=0):  ##brk,'non',s1List[0],genome1
   chrom=(brk.gauche if brk.gauche!=0 else brk.droit).chromo
   if brk.gauche==0 or brk.droit==0:  ## no overlap: (0,Bloc)
      if brk.gauche!=0:
         bg=brk.gauche.block if 'v' in brk.gauche.name else brk.gauche
         bgBN=('' if bg.sign==1 else '-')+bg.name+('v' if 'v' in brk.gauche.name else '')
         bgB=str(bg.bornes[1])
         bgGN=bg.lastGene().name
         genome=bg.firstGene().gene.genome.name
         bgE=bg.lastGene().startEnd[1]
      else:
         bgBN=str(0)
         bgB=str(0)
         bgGN=str(0)
         bgE=str(0)
      if brk.droit!=0:
         bd=brk.droit.block if 'v' in brk.droit.name else brk.droit
         bdBN=('' if bd.sign==1 else '-')+bd.name+('v' if 'v' in brk.droit.name else '')
         bdB=str(bd.bornes[0])
         bdGN=bd.firstGene().name
         genome=bd.firstGene().gene.genome.name
         bdS=bd.firstGene().startEnd[0]
      else:
         bdBN=str(0)
         bdB=str(0)
         bdGN=str(0)
         bdS=str(0)

   else:
      bg=brk.gauche.block if 'v' in brk.gauche.name else brk.gauche
      bgBN=('' if bg.sign==1 else '-')+bg.name+('v' if 'v' in brk.gauche.name else '')
      bd=brk.droit.block if 'v' in brk.droit.name else brk.droit
      bdBN=('' if bd.sign==1 else '-')+bd.name+('v' if 'v' in brk.droit.name else '')
      genome=bg.firstGene().gene.genome.name
      if ('v' in brk.gauche.name and 'v' in brk.droit.name):
         if (brk.gauche.block in brk.droit.block.including or   ## (V,v)
             brk.droit.block in brk.gauche.block.including):   ## (v,V) with v included in V
            gG,gD=breakIncluded(brk.gauche,brk.droit)
         elif brk.gauche.block.overlapR==brk.droit.block:
            gG,gD=breakOverlap(brk.gauche,brk.droit)
         else:
            if (brk.droit.next!=0 and 'v' in brk.droit.next.name and
            brk.droit.next.block in brk.droit.block.including): ## (b,v),V
               gD=brk.droit.next.block.genes[0]
            else:
               gD=brk.droit.block.genes[0]
            if (brk.gauche.previous!=0 and 'v' in brk.gauche.previous.name and
            brk.gauche.previous.block in brk.gauche.block.including): ## V,(v,b)
               gG=brk.gauche.previous.block.genes[-1]
            else:
               gG=brk.gauche.block.genes[-1]

      else: 
         if 'v' in brk.gauche.name:
            if (brk.gauche.previous!=0 and 'v' in brk.gauche.previous.name and
            brk.gauche.previous.block in brk.gauche.block.including): ## V,(v,b)
               gG=brk.gauche.previous.block.genes[-1]
            else:
               gG=brk.gauche.block.genes[-1]
         else:
            gG=brk.gauche.genes[-1]
         if 'v' in brk.droit.name:
            if (brk.droit.next!=0 and 'v' in brk.droit.next.name and
            brk.droit.next.block in brk.droit.block.including): ## (b,v),V
               gD=brk.droit.next.block.genes[0]
            else:
               gD=brk.droit.block.genes[0]
         else:
            gD=brk.droit.genes[0]
      bgB=str(gG.position)
      bgGN=gG.name
      bgE=gG.startEnd[1] 
      bdB=str(gD.position)
      bdGN=gD.name
      bdS=gD.startEnd[0] 
   if not contradict:
      fileBrkpt.write(nonPost+'\t'+str(brk.valScore)+'('+str(brk.score)+')\t'+
         genome+'\t'+str(chrom)+'\t('+bgBN+','+bdBN+')\t'+
         '('+bgB+','+bdB+')\t'+'('+bgGN+','+bdGN+')\t'+
         '('+bgE+','+bdS+')\n')
   else:
      fileBrkpt.write(genome+'\t'+str(chrom)+'\t('+bgBN+','+bdBN+')\t'+
         '('+bgB+','+bdB+')\t'+'('+bgGN+','+bdGN+')\t'+
         '('+bgE+','+bdS+')\n')


  


## fonctions that for a given breakpoint give the good interval
def breakOverlap(gauche,droit):
   gba=gauche.block.ancres[:]
   gba.sort(lambda x,y:cmp(x.position,y.position))
   dba=droit.block.ancres[:]
   dba.sort(lambda x,y:cmp(x.position,y.position))
## genom=gauche.block.genes[0].genome
## genomG=gauche.blockG.genes[0].genome

   bornesOverlap=(dba[0].position,gba[-1].position)
   ## list des position et de gc des ancres de G et D ds cet interval
   posListG=[]
   gcListG=[]
   posListD=[]
   gcListD=[]
   ## on remplit les listes
   #print gauche.block
   for g in gba:
      if bornesOverlap[0]<=g.position and g.position<=bornesOverlap[1]:
         posListG.append(g.position)
         gcListG.append(g)
   #print droit.block,droit.block.ancres
   for g in dba:
      if bornesOverlap[0]<=g.position and g.position<=bornesOverlap[1]:
         posListD.append(g.position)
         gcListD.append(g)

   ## 1er cas: bien spares
   if max(posListD)<min(posListG):
      return gcListD[-1],gcListG[0]
   ## 2eme cas: un seul gene est respo et homo 30%
   elif len(posListG)==1 and  posListG[0] in posListD:
      i=0
      while gba[i].position<bornesOverlap[0]:
         i+=1
      return gba[i-1],gcListD[0]
   elif len(posListD)==1 and  posListD[0] in posListG:
      i=0
      while dba[i].position<=bornesOverlap[1]:
         i+=1
      return gcListG[-1],dba[i]
   ## 3eme cas: c plus complex on prend l'interval
   else:
      i=0
      while gba[i].position<bornesOverlap[0]:
         i+=1

      j=0
      while dba[j].position<=bornesOverlap[1]:
         j+=1
      return gba[i-1],dba[j]


## fonctions that for a given breakpoint give the good interval 
def breakIncluded(gauche,droit):
   genom=gauche.block.genes[0].genome
   g2=gauche.block.genes[0].genomeC.name
   feat=genom.features
   if droit.block in gauche.block.including: #gauche inclus
      if droit.block.genes[0]==gauche.block.genes[0]:
         gG=gauche.block.genes[-1]
         i=-1
         while droit.block.genes[i] in gauche.block.genes:
            i-=1
         gD=droit.block.genes[i+1]
      else:
         gD=gauche.block.genes[0]
         i=0
         while droit.block.genes[i] not in gauche.block.genes:
            i+=1
         gG=droit.block.genes[i-1]

   else: #droit inclus
      if droit.block.genes[-1]==gauche.block.genes[-1]:
         gD=droit.block.genes[0]
         i=0
         while gauche.block.genes[i] not in droit.block.genes:
            i+=1
         gG=gauche.block.genes[i-1]
      else:
         gG=droit.block.genes[-1]
         i=-1
         while gauche.block.genes[i] not in droit.block.genes:
            i-=1
         gD=gauche.block.genes[i+1]
   return gG,gD
