#!/usr/bin/python
# -*- coding: utf-8 -*-
## n07CompareOutgroup
## Compare the linkedBlocs of 2 genomes to an outgroup

from n00Objets import *
from n08WriteBrkpts import writeBrkpt,writeBrkpts,writeContradict
import n06CalculScore

##return 56 given this [0.2,-2,56,'12']
def maxL(l):
  return max(map(lambda x:0 if isinstance(x,str) else x, l))
  
##############################################
## Compare with the outgroup genomes
## using fonction defined in calculScore
## outgroupComparison(cycles,genomes,blocs1,blocs2,pathDir)
## blocs1 : la liste des listes des blocs ds G[i] ds sa comparaison avec G1
def outgroupComparison(cycles,genomes,blocs1,blocs2,pathDir,fileR):

   ################ STAT ###############
   ## nombre sur G1, sur G2, sur G1ouG2
   NBREAR=[0,0,0] ## nombre sur G1, sur G2, sur G1ouG2
   
   ################ FILE ###############
   fileBrkpt=open(fileR+'.rea.txt','w')
   fileContradict=open(fileR+'.contr.txt','w')
   fileDetails=open(fileR+'.details.txt','w')

   print '\nTHE SCORES'
   ## on garde les breakpoints en contradiction ou non retrouv de part et d'autre
   brkptsCrees=[]  # liste de ((b1,signe1,b2,signe2),(b1,signe1,b2,signe2))

   blocs=[[],[]]  # list de couple (blocs1,blocs2)
   blocsDeleted=[[],[]]  # liste des blocs sup car "telomere" ou circulaire

   ## conservedTelomeres
   conservedTelomeres=[c for c in cycles if (c.isPath() and c.length==1)]
   for c in conservedTelomeres:
      if c.breakpoints1!=[] and c.breakpoints2!=[]:
         completeBlocs(c,blocs)
         c.breakpoints1[0].valScore=1
         c.breakpoints1[0].score=-1
         c.breakpoints1[0].valid=1

   ## oddPath
   oddPath=[c for c in cycles if (c.isPath() and c.length>1 and c.length%2)]
   [involvingTB,leReste]=involvesTelomericBlocks(oddPath,blocs)
   f=1
   while involvingTB!=[]:
      treatOddPath(involvingTB,blocs,genomes,blocs1,blocs2,fileBrkpt,
                  fileContradict,fileDetails,cycles,brkptsCrees,blocsDeleted,NBREAR,f)
      f=0
      [involvingTB,leReste]=involvesTelomericBlocks(leReste,blocs)
   treatOddPath(leReste,blocs,genomes,blocs1,blocs2,fileBrkpt,
               fileContradict,fileDetails,cycles,brkptsCrees,blocsDeleted,NBREAR,f)
   ## conservedAdjacencies
   conservedAdjacencies=[c for c in cycles if (not c.isPath() and c.length==2)]
   for c in conservedAdjacencies:
      if c.breakpoints1!=[] and c.breakpoints2!=[]:
         completeBlocs(c,blocs)
         c.breakpoints1[0].valScore=1
         c.breakpoints1[0].score=-1
         c.breakpoints1[0].valid=1

   ## evenPath
   evenPath=[c for c in cycles if (c.isPath() and c.length>1 and not c.length%2)]
   treatEvenPath(evenPath,blocs,genomes,blocs1,blocs2,fileBrkpt,
               fileContradict,fileDetails,cycles,brkptsCrees,blocsDeleted,NBREAR)

   ## cycle
   cycle=[c for c in cycles if (not c.isPath() and c.length>2)]
   treatCycle(cycle,blocs,genomes,blocs1,blocs2,fileBrkpt,
            fileContradict,fileDetails,cycles,brkptsCrees,blocsDeleted,NBREAR)
   
   print '\nThere are ',NBREAR[0],' rea from ancestor to ',genomes[0].name
   print 'There are ',NBREAR[1],' rea from ancestor to ',genomes[1].name
   print 'There are ',NBREAR[2],' unlocalized rea\n'
   
   fileBrkpt.close()
   fileContradict.close()
   fileDetails.close()
   
   blocsValides,blocsNonValides=singleton(blocs,brkptsValides(cycles),brkptsCrees,blocsDeleted)  # liste de couples (b1,b2)
   return brkptsValides(cycles),brkptsCrees,blocsNonValides,blocsValides,NBREAR

## renvoie les blocs adajecents et les solos (diff de deleted)
def singleton(blocs,brkptsValides,brkptsCrees,blocsDeleted):
   blocs1,blocs2=blocs
   blocsValides=[[],[]]
   blocsNonValides=[[],[]]
   for i,b1 in enumerate(blocs1):
      found=0
      b2=blocs2[i]
      for b in brkptsValides:
         g=b.gauche
         d=b.droit
         if b1==g or b2==g or b1==d or b2==d:
            blocsValides[0].append(b1)
            blocsValides[1].append(b2)
            found=1
            break
      if not found:
         for brkpt in brkptsCrees:
            ((b,bb),sc)=brkpt
            if b1==b[0] or b2==b[2] or (bb!=0 and (b1==bb[0] or b2==bb[2])):
               blocsValides[0].append(b1)
               blocsValides[1].append(b2)
               found=1
               break
      if not found:
         if b1 in map((lambda x:x[0]),blocsDeleted[0]):
            print b1.name[:-2],'has been deleted (as telomeric block)'
         elif b1 in map((lambda x:x[0]),blocsDeleted[1]):
            print b1.name[:-2],'has been deleted (as small transposed block: ',len(b1.genes),'genes)'
         else:
            blocsNonValides[0].append(b1)
            blocsNonValides[1].append(b2)
   
   print '\n',len(blocsNonValides[1]),'blocks are involve in none validated adjacency'
   for i in range(len(blocsNonValides[1])):
      print '\t',blocsNonValides[0][i].name[:-2]
   return blocsValides,blocsNonValides

## revoie TRUE si le bloc a ete valide comme telomere et le supprime
def validatedAsTelo(blsNV,brkptsValides):
   for brk in brkptsValides:
      if (brk.gauche==0 and (brk.droit==blsNV[0] or brk.droit==blsNV[2]) or
         brk.droit==0 and (brk.gauche==blsNV[0] or brk.gauche==blsNV[2])):
         brk.valid=-1
         return True
   return False

## analysele test des newbrkpoints
def analyse(c,newBrkpts,brkptsCrees,fileContradict,fileDetails):
   for b in newBrkpts[1]:
      b.valScore=0.4
      b.valid=1
      unvalidate([b],c.breakpoints2,fileContradict)
   for b in newBrkpts[2]:
      b.valScore=0.4
      b.valid=1
      unvalidate([b],c.breakpoints1,fileContradict)
   for b in newBrkpts[0]:
      brkptsCrees.append((b,0.3))
   if len(newBrkpts[0])+len(newBrkpts[1])+len(newBrkpts[2])==0:
      fileDetails.write('No tested brkpts found\n')

## trie les existant des news
def trieBrkpts(newBrk,blsNV,blocsDeleted,brkList1,brkList2,fileDetails):
   res=[[],[],[]]
   ## estce que le brkpoint est new
   (brk1,g1)=b1ORb2(newBrk,brkList1,brkList2,fileDetails)
   if g1==0 and almostNotnew(newBrk,brkList1,brkList2,fileDetails)[1]!=0:
      ## to avoid circular contigs (constituted of 2 blocks)
      return res,0
   else:
      transpo=0
      res[g1].append(brk1)
      ## est ce que le deuxieme l'est
      bs=[]
      for b in blsNV:
         if b!=newBrk[0] and b!=newBrk[1]:
            bs.append(b)
      if bs[0][0]==bs[1][0]:
         ## we have 1 circular block (we delete it) (in addition to the 1 new ancestral brkpt)
         blocsDeleted[1].append((bs[0][0],bs[0][2]))
         transpo=bs[0][0].name[:-2]
         #print 'We delete the transposed block',bs[0][0]
      else:
         toprint='which imply that '+('(-' if bs[0][0].sign*bs[0][1]==1 else '(')+bs[0][0].name
         fileDetails.write(toprint+(',' if bs[1][0].sign*bs[1][1]==1 else ',-')+bs[1][0].name+') is also validated\n')
         (brk2,g2)=b1ORb2((bs[0],bs[1]),brkList1,brkList2,fileDetails)
         res[g2].append(brk2)
      return res,transpo
## pour eviter les contigs circulaire a 2 blocks
#return (brkpt,0 or 1 or 2) for new, in brkList1 and in brkList2
def almostNotnew((b1,b2),brkList1,brkList2,fileDetails):
   for brk1 in brkList1:
      if (brk1.gauche!=0 and brk1.droit!=0 and
        (b1[0]==brk1.gauche and b1[1]==1 and
              b2[0]==brk1.droit and b2[1]==-1) or
            (b2[0]==brk1.gauche and b2[1]==1 and 
              b1[0]==brk1.droit and b1[1]==-1)):
         fileDetails.write(brk1.droit.name+' '+brk1.gauche.name+'\n')
         return (brk1,1)
   for brk1 in brkList2:
      if (brk1.gauche!=0 and brk1.droit!=0 and
         (b1[2]==brk1.gauche and b1[3]==1 and
          b2[2]==brk1.droit and b2[3]==-1) or
        (b2[2]==brk1.gauche and b2[3]==1 and 
          b1[2]==brk1.droit and b1[3]==-1)):
         return (brk1,2)
   return ((b1,b2),0)
## return (brkpt,0 or 1 or 2) for new, in brkList1 and in brkList2
def b1ORb2((b1,b2),brkList1,brkList2,fileDetails):
   for brk1 in brkList1:
      if (brk1.gauche!=0 and brk1.droit!=0 and
         (b1[0]==brk1.gauche and b1[1]==-1 and
              b2[0]==brk1.droit and b2[1]==1) or
            (b2[0]==brk1.gauche and b2[1]==-1 and 
              b1[0]==brk1.droit and b1[1]==1)):
         fileDetails.write("which is a brkpt of G1\n")
         return (brk1,1)
   for brk1 in brkList2:
      if (brk1.gauche!=0 and brk1.droit!=0 and
         (b1[2]==brk1.gauche and b1[3]==-1 and
          b2[2]==brk1.droit and b2[3]==1) or
         (b2[2]==brk1.gauche and b2[3]==-1 and 
          b1[2]==brk1.droit and b1[3]==1)):
         fileDetails.write("which is a brkpt of G2\n")
         return (brk1,2)
   fileDetails.write("which is a new bkrpt\n")
   return ((b1,b2),0)
# for a telo
## return (brkpt,0 or 1 or 2) for new, in brkList1 and in brkList2
def b1ORb2T(b,brkList1,brkList2,fileDetails):
   for brk1 in brkList1:
      if ((brk1.gauche!=0 and brk1.droit==0 and
        b[0]==brk1.gauche and b[1]==-1) or
        (brk1.gauche==0 and brk1.droit!=0 and
          b[0]==brk1.droit and b[1]==1)):
         fileDetails.write("which is a telomere of G1\n")
         return (brk1,1)
   for brk1 in brkList2:
      if ((brk1.gauche!=0 and brk1.droit==0 and
        b[2]==brk1.gauche and b[3]==-1) or
        (brk1.gauche==0 and brk1.droit!=0 and
          b[2]==brk1.droit and b[3]==1)):
         fileDetails.write("which is a telomere of G2\n")
         return (brk1,2)
   return ((b,0),0)

### fonction qui test et cree des nouveaux breakpoints si on a la preuve
def testNewBrkpt(brkpts,blocsDeleted,genomes3,blocs1,blocs2,fileDetails):
   fileDetails.write('We test all potential brkpts (6 for 4 blocks, 3 for 3)\n')
   (brkList1,brkList2)=brkpts
   blsNV=reUsedBlock(brkpts)
   bestSc=0
   newBrk=0
   res=[[],[],[]]
   for i,bNV in enumerate(blsNV):
      (bNV1,sens1,bNV2,sens2)=bNV
      for rebNV in range(i+1,len(blsNV)):
         (rebNV1,resens1,rebNV2,resens2)=blsNV[rebNV]
         if bNV1!=rebNV1:
            sc1=n06CalculScore.brScore2(genomes3,(bNV1,sens1,rebNV1,resens1),blocs1)
            sc2=n06CalculScore.brScore2(genomes3,(bNV2,sens2,rebNV2,resens2),blocs2)
            sc=sc1+sc2
            fileDetails.write(('\t(-' if bNV1.sign*sens1==1 else '\t(')+bNV1.name+(',' if rebNV1.sign*resens1==1 else ',-')+rebNV1.name+')_ScFromG1: '+str(sc1)+';')
            fileDetails.write(('(-' if bNV2.sign*sens2==1 else '(')+bNV2.name+(',' if rebNV2.sign*resens2==1 else ',-')+rebNV2.name+')_ScFromG2: '+str(sc2)+'\n')
            if sc>bestSc:
               toprint=('(-' if bNV1.sign*sens1==1 else '(')+bNV1.name+(',' if rebNV1.sign*resens1==1 else ',-')+rebNV1.name+')'
               toprint+='is one of the pairs getting the best score (sc1+sc2='+str(sc)+')'
               newBrk=(bNV,blsNV[rebNV])
               bestSc=sc
         elif len(blsNV)==3:
            # we have 1 circular block (we delete it)
            fileDetails.write('we delete the bloc '+bNV1.name[:-2]+' and conserve the block ')
            blocsDeleted[1].append((bNV1,bNV2))
            # + 1 telomeric block (we create a telomere)
            for b in blsNV:
               if b!=bNV and b!=blsNV[rebNV]: #le 3eme larron
                  fileDetails.write(b[0].name[:-2]+' ')
                  (brk1,g1)=b1ORb2T(b,brkList1,brkList2,fileDetails)
                  res[g1].append(brk1)
                  return res,bNV1.name[:-2]
   if newBrk!=0:
      fileDetails.write(toprint+'\n')
      if len(blsNV)==3:
         # we have 1 telomeric block (we create a telomere)
         (brk1,g1)=b1ORb2((newBrk[0],newBrk[1]),brkList1,brkList2,fileDetails)
         res[g1].append(brk1)
         for b in blsNV:
            if b!=newBrk[0] and b!=newBrk[1]: #le 3eme bloc
               (brk1,g1)=b1ORb2T(b,brkList1,brkList2,fileDetails)
               res[g1].append(brk1)
               break
      elif len(blsNV)==4:
         return trieBrkpts(newBrk,blsNV,blocsDeleted,brkList1,brkList2,fileDetails)
      else:
         print "Error in 'testNewBrkpt'",len(blsNV),blsNV
   return res,0

## le signe est -1 s'il est a gauche ds le brkpoint qui le concerne ds G1 or G2 * son signe 
def reUsedBlock((brkList1,brkList2)):
   blocs=[]
   for b1 in brkList1:
      (b1g,b1d)=(b1.gauche,b1.droit)
      #print b1g,b1d,b1g.blockG,b1d.blockG,n06CalculScore.realB(b1)[0],n06CalculScore.realB(b1)[1]
      for b2 in brkList2:
         (b2g,b2d)=(b2.gauche,b2.droit)
         if b1g!=0:
            if b2g!=0 and b1g==b2g.blockG and b1g.sign*b2g.sign==1:
               blocs.append((b1g,-1,b2g,-1))
            elif b2d!=0 and b1g==b2d.blockG and b1g.sign*b2d.sign==-1:
               blocs.append((b1g,-1,b2d,1))
         if b1d!=0:
            if b2g!=0 and b1d==b2g.blockG and b1d.sign*b2g.sign==-1:
               blocs.append((b1d,1,b2g,-1))
            elif b2d!=0 and b1d==b2d.blockG and b1d.sign*b2d.sign==1:
               blocs.append((b1d,1,b2d,1))
   return blocs

# fonction qui retourne true si le breakpoint est peu tre reutilis (on n'a pas retrouv les 2 adjacences)
def reUsed(brk1,brkList2):
   if brk1.droit==0 or brk1.gauche==0:
      return len(contradiction(brk1,brkList2))!=1
   else:
      return len(contradiction(brk1,brkList2))!=2

## renvoie la liste des [brkpts1,brkpoints2] dont un block n'a pas d'ajacence valide
def creeReusedList(c):
   reUsedLists=([],[])
   for  i,brr in enumerate(c.breakpoints1):
      if brr.valid!=1:  
         if reUsed(brr,valC(c,1)):
            reUsedLists[0].append(brr)
   for  i,brr in enumerate(c.breakpoints2):
      if brr.valid!=1:  
         if reUsed(brr,valC(c,2)):
            reUsedLists[1].append(brr)
   return reUsedLists

## revoie la liste des brk en contradict si brk1 est en contradiction avec brkList2
def contradiction(brk1,brkList2):
   contr=[]
   (b1g,b1d)=brk1.realB()
   for j,b2 in enumerate(brkList2):
      (b2g,b2d)=b2.realB()
      if ((b1g!=0 and b2g!=0 and brk1.gauche==b2g.blockG and b1g.sign*b2g.sign==1)
        or (b1d!=0 and b2d!=0 and brk1.droit==b2d.blockG and b1d.sign*b2d.sign==1)
        or (b1g!=0 and b2d!=0 and brk1.gauche==b2d.blockG and b1g.sign*b2d.sign==-1)
        or (b1d!=0 and b2g!=0 and brk1.droit==b2g.blockG and b1d.sign*b2g.sign==-1)):
         contr.append(j)
   return contr

### fonction qui pour un score max donn valide tous les brkpts de categorie
def EGscoreMax(maxiSc,c,fileContradict,fileDetails):
   # on recupere les breakpoints ayant ce score
   toBeVal1=[b for b in c.breakpoints1 if b.valid==0]
   upToVal1=[]
   for b in toBeVal1:
      if b.score==maxiSc:
         upToVal1.append(b)
   toBeVal2=[b for b in c.breakpoints2 if b.valid==0]
   upToVal2=[]
   for b in toBeVal2:
      if b.score==maxiSc:
         upToVal2.append(b)

   # if there are validatable b in both genome
   # we check that there is no contradiction between them
   # if so we do not validate them, and string their score
   if len(upToVal1) and len(upToVal2):
      contrS=[]
      # in G1
      for j in range(len(upToVal1)-1,-1,-1):
         contr=contradiction(upToVal1[j],upToVal2)
         # on supprime les breakpoints en contradict
         if contr: 
            fileDetails.write('Some brkpts with the same score ('+str(maxiSc)+') are in contraction,\
we cannot say anything and pass to a lower score >0.4 (or >0.6 if only 2 brkpts remainds)\n')
            upToVal1[j].score=str(upToVal1[j].score)
            upToVal1.remove(upToVal1[j])
            for k in contr:
               if k not in contrS:
                  contrS.append(k)
      # in G2
      contrS.sort()
      contrS.reverse()
      for k in contrS:
         upToVal2[k].score=str(upToVal2[k].score)
         upToVal2.remove(upToVal2[k])
   # then we validate the other ones
   for b in upToVal1:
      b.valScore=b.score
      b.valid=1
   for b in upToVal2:
      b.valScore=b.score
      b.valid=1
   # and we unvalidate the one in contradiction
   toBeVal1=[b for b in toBeVal1 if b not in upToVal1]
   toBeVal2=[b for b in toBeVal2 if b not in upToVal2]
   unvalidate(upToVal2,toBeVal1,fileContradict)
   unvalidate(upToVal1,toBeVal2,fileContradict)
    

def unvalidate(listeVal,listeToUnval,fileContradict):
   for b in listeToUnval:
      contr=contradiction(b,listeVal)
      if contr:
         b.valid=-1
         b.valScore=0
         if b.score>0.3:
            writeContradict(fileContradict,b,[listeVal[k] for k in contr])

## calcul un score pour chacun des breakpoints de c
def scoreAndstr(c,genomes,blocs1,blocs2,fileDetails):
   strP='['
   for br1 in c.breakpoints1:
      strP+=br1.__str__()
      maxi=0
      for i in range(2,len(genomes)):
         sgi=n06CalculScore.brScore(br1,genomes[i],blocs1[i-2])
         if sgi[0]>maxi:
            br1.outgroups=[sgi[1]]
            maxi=sgi[0]
         elif sgi[0]==maxi:
            br1.outgroups.append(sgi[1])
      strP+='_'+str(maxi)+' '
      br1.score=maxi
   strP+=';\n'
   for br2 in c.breakpoints2:
      strP+=br2.__str__()
      maxi=0
      for i in range(2,len(genomes)):
         sgi=n06CalculScore.brScore(br2,genomes[i],blocs2[i-2])
         if sgi[0]>maxi:
            br2.outgroups=[sgi[1]]
            maxi=sgi[0]
         elif sgi[0]==maxi:
            br2.outgroups.append(sgi[1])
      strP+='_'+str(maxi)+' '
      br2.score=maxi
   strP+=']'
   fileDetails.write(strP+'\n')

def brkptsValides(cycles):
   brkptsValidesL=[]
   for c in cycles:
      brkptsValidesL.extend([b for b in c.breakpoints1 if b.valid==1])
      brkptsValidesL.extend([b for b in c.breakpoints2 if b.valid==1])
   return brkptsValidesL
def valC(c,g):
   if g==1:
      return [b for b in c.breakpoints1 if b.valid==1]
   else:
      return [b for b in c.breakpoints2 if b.valid==1]
def unvalC(c,g):
   if g==1:
      return [b for b in c.breakpoints1 if b.valid==-1]
   else:
      return [b for b in c.breakpoints2 if b.valid==-1] 
def scoreC(c,g):
   if g==1:
      res=[b.score for b in c.breakpoints1 if b.valid==0]
   else:
      res=[b.score for b in c.breakpoints2 if b.valid==0]
   if res:
      return res
   else:
      return [0]

########################################
## PATH 
#############################
## Path IMPAIR de taille 3, 5, 7 ...
def treatOddPath(oddPaths,blocs,genomes,blocs1,blocs2,fileBrkpt,
                fileContradict,fileDetails,cycles,brkptsCrees,blocsDeleted,NBREAR,f):
   genome1=genomes[0].name
   genome2=genomes[1].name
   if f:
      print '\nPATH Impair ['+genome1+';'+genome2+']'
      fileDetails.write('PATH Impair ['+genome1+';'+genome2+']\n')
   for c in oddPaths:
      completeBlocs(c,blocs)
      scoreAndstr(c,genomes,blocs1,blocs2,fileDetails)
      l1=len(c.breakpoints1)*1.
      l2=len(c.breakpoints2)*1.

      maxiSc=max(maxL(scoreC(c,1)),maxL(scoreC(c,2)))
      transpo=0

      #identification of the telomeres
      for brkV in c.breakpoints1:
         if brkV.gauche==0 or brkV.droit==0:
            telo1=brkV
            break
      for brkV in c.breakpoints2:
         if brkV.gauche==0 or brkV.droit==0:
            telo2=brkV
            break

      ## on valide toutes les adjacences ancestrales (sauf telo)
      while maxiSc>0.4 and (maxiSc>0.9 and len(valC(c,1))+len(valC(c,2))<(l1-1) or
      (maxiSc<=0.9 and len(valC(c,1))+len(valC(c,2))<(l1-3))):
         EGscoreMax(maxiSc,c,fileContradict,fileDetails)
         maxiSc=max(maxL(scoreC(c,1)),maxL(scoreC(c,2)))

      ## on cree la liste des blocs pas encore localises
      reUsedLists=creeReusedList(c)
      telo1NotContr=(telo1.valid!=-1)*telo1.score
      telo2NotContr=(telo2.valid!=-1)*telo2.score

      if len(valC(c,1))+len(valC(c,2))==int(l1)-1:
         if len(valC(c,1))==int(l1)-1: 
            fileDetails.write("From the n-1 validated G1 brkpts, we validate the G1 telomere:")
            telo1.valScore=0.4
            telo1.valid=1
         elif len(valC(c,2))==int(l1)-1:
            fileDetails.write("From the n-1 validated G2 brkpts, we validate the G2 telomere:")
            telo2.valScore=0.4
            telo2.valid=1
         else:
            # on cree le telo
            blsNV=reUsedBlock(reUsedLists)
            brkptsCrees.append(((blsNV[0],0),0.3))
            fileDetails.write("From the n-1 validated brkpts, we create the ancestral telo"+blsNV[0][0].name+":")

      ## tous ceux de G1 ou G2 ont ete validated or unvalidated:
      elif len(unvalC(c,1))==int(l1):
         fileDetails.write('All G1 breakpoints have been unvalidated, we validated the last G2 breakpoints:')
         for brkV in c.breakpoints2:
            if brkV.valid==0:
               brkV.valScore=0.35
               brkV.valid=1
      elif len(unvalC(c,2))==int(l2):
         fileDetails.write('All G2 breakpoints have been unvalidated, we validated the last G1 breakpoints:')
         for brkV in c.breakpoints1:
            if brkV.valid==0:
               brkV.valScore=0.35
               brkV.valid=1

      elif len(valC(c,1))+len(valC(c,2))==int(l1)-2:
         ## ONLY ONE TELO
         if (not(telo1NotContr and telo2NotContr)
             and (telo1NotContr or telo2NotContr)):
            if telo1NotContr:
               telo1.valScore=telo1.score
               telo1.valid=1
               unvalidate([telo1],c.breakpoints2,fileContradict)
               if len(valC(c,1))==int(l1)-1:
                  fileDetails.write("From the n-2 validated G1 brkpts + the G1 telo, we validate the nieme G1 brkpt:")
                  for brkV in c.breakpoints1:
                     if brkV.valid!=1:
                        brkV.valScore=0.2
                        brkV.valid=1
                        unvalidate([brkV],c.breakpoints2,fileContradict)
                        break
               else:
                  reUsedLists[0].remove(telo1)
                  blsNV=reUsedBlock(reUsedLists)
                  if blsNV[0][0]!=blsNV[1][0]:
                     brkptsCrees.append(((blsNV[0],blsNV[1]),0.3))
                     fileDetails.write("From the n-2 validated brkpts + the G1 telo, we create a new ancestral brkpt ("+blsNV[0][0].name+','+blsNV[1][0].name+') :')
                  else:
                     blocsDeleted[1].append((blsNV[0][0],blsNV[0][2]))
                     transpo=blsNV[0][0].name[:-2]
                     fileDetails.write('We delete the bloc '+transpo+' that we cannot localized:')
            else:
               telo2.valScore=telo2.score
               telo2.valid=1
               unvalidate([telo2],c.breakpoints1,fileContradict)
               if len(valC(c,2))==int(l2)-1:
                  fileDetails.write("From the n-2 validated G1brkpts + the G1 telo, we validate the nieme G1 brkpt:")
                  for brkV in c.breakpoints2:
                     if brkV.valid!=1:
                        brkV.valScore=0.2
                        brkV.valid=1
                        unvalidate([brkV],c.breakpoints1,fileContradict)
                        break
               else:
                  reUsedLists[1].remove(telo2)
                  blsNV=reUsedBlock(reUsedLists)
                  if blsNV[0][0]!=blsNV[1][0]:
                     brkptsCrees.append(((blsNV[0],blsNV[1]),0.3))
                     fileDetails.write("From the n-2 validated brkpts + the G2 telo, we create a new ancestral brkpt ("+blsNV[0][0].name+','+blsNV[1][0].name+')')
                  else:
                     blocsDeleted[1].append((blsNV[0][0],blsNV[0][2]))
                     transpo=blsNV[0][0].name[:-2]
                     fileDetails.write('We delete the bloc '+transpo+' that we cannot localized:')
         ## BOTH or NONE
         else:
            ## BOTH
            if telo1NotContr and telo2NotContr:
               reUsedLists[0].remove(telo1)
               reUsedLists[1].remove(telo2)
               blsNV=reUsedBlock(reUsedLists)
               if validatedAsTelo(blsNV[0],brkptsValides(cycles)):
                  telo1.valScore=telo1.score
                  telo2.valScore=telo2.score
                  telo1.valid=1
                  telo2.valid=1 
                  blocsDeleted[0].append((blsNV[0][0],blsNV[0][2]))
                  transpo=blsNV[0][0].name[:-2]
                  fileDetails.write('We validate both telos and delete the bloc '+transpo+' that we cannot localized:')
               else:
                  reUsedLists[0].append(telo1)
                  reUsedLists[1].append(telo2)
                  newBrkpts,transpo=testNewBrkpt(reUsedLists,blocsDeleted,genomes[2:],blocs1,blocs2,fileDetails)
                  analyse(c,newBrkpts,brkptsCrees,fileContradict,fileDetails)
            ## NONE
            else:
               # on test
               newBrkpts,transpo=testNewBrkpt(reUsedLists,blocsDeleted,genomes[2:],blocs1,blocs2,fileDetails)
               analyse(c,newBrkpts,brkptsCrees,fileContradict,fileDetails)

      elif len(valC(c,1))+len(valC(c,2))==int(l1)-3:
         ## ONLY ONE TELO
         if (not(telo1NotContr and telo2NotContr)
             and (telo1NotContr or telo2NotContr)):
            if telo1NotContr:
               telo1.valScore=telo1.score
               telo1.valid=1
               fileDetails.write('We validate G1 telo')
               reUsedLists[0].remove(telo1)
            if telo2NotContr:
               telo2.valScore=telo2.score
               telo2.valid=1
               fileDetails.write('We validate G2 telo')
               reUsedLists[1].remove(telo2) 
            # on test
            newBrkpts,transpo=testNewBrkpt(reUsedLists,blocsDeleted,genomes[2:],blocs1,blocs2,fileDetails)
            analyse(c,newBrkpts,brkptsCrees,fileContradict,fileDetails)

      else:
         fileDetails.write('We cannot identified all ancestral brkpts, only'+str(len(valC(c,1))+len(valC(c,2)))+':')

      if not transpo:
         n1=max(len([b for b in c.breakpoints1 if b.valid==-1])-1,0)
         NBREAR[0]+=n1
         n2=max(len([b for b in c.breakpoints2 if b.valid==-1])-1,0)
         NBREAR[1]+=n2
         n12=int(l1)-1-n1-n2
         NBREAR[2]+=n12
         head2='\n'
      else:
         n1=max(len([b for b in c.breakpoints1 if b.valid==-1])-2,0)
         NBREAR[0]+=n1
         n2=max(len([b for b in c.breakpoints2 if b.valid==-1])-2,0)
         NBREAR[1]+=n2
         n12=max(int(l1)-3-n1-n2,0)
         NBREAR[2]+=n12
         head2=' ('+transpo+' deleted)\n'
      head=''
      if n1:
         head+=str(n1)+' rea to '+genome1+', '
      if n2:
         head+=str(n2)+' rea to '+genome2+', '
      if n12>0:
         head+=str(n12)+' rea to '+genome1+' or '+genome2+', '
      head=head[:-2]+head2
      fileDetails.write(head+'\n')
      fileBrkpt.write('P'+str(c.length)+'\t'+head)
      writeBrkpts(fileBrkpt,c)

########################################
## PATH 
#############################
## Path PAIR de taille 2, 4, 6, 8 ...
def treatEvenPath(evenPaths,blocs,genomes,blocs1,blocs2,fileBrkpt,
                 fileContradict,fileDetails,cycles,brkptsCrees,blocsDeleted,NBREAR):
   genome1=genomes[0].name
   genome2=genomes[1].name

   print 'PATH Pair ['+genome1+';'+genome2+']'
   fileDetails.write('\nPATH Pair ['+genome1+';'+genome2+']\n')
   for c in evenPaths:
      completeBlocs(c,blocs)
      scoreAndstr(c,genomes,blocs1,blocs2,fileDetails)
      l1=len(c.breakpoints1)*1.
      l2=len(c.breakpoints2)*1.

      maxiSc=max(maxL(scoreC(c,1)),maxL(scoreC(c,2)))
    
    ## on valide toutes les adjacences ancestrales (sauf telo)
      while maxiSc>0.4 and (maxiSc>0.9 and len(valC(c,1))+len(valC(c,2))<max(l1,l2) or
                          (maxiSc<=0.9 and len(valC(c,1))+len(valC(c,2))<max(l1,l2)-2)):
            EGscoreMax(maxiSc,c,fileContradict,fileDetails)
            maxiSc=max(maxL(scoreC(c,1)),maxL(scoreC(c,2)))

      ## on cree la liste des blocs pas encore localises
      reUsedLists=creeReusedList(c)
      transpo=0
      fusorfiss=0
      telosIn1=int(l1)>int(l2)
      telo1=0
      if telosIn1:
         for brkV in c.breakpoints1:
            if brkV.gauche==0 or brkV.droit==0:
               if not telo1:
                  telo1=brkV
               else:
                  telo2=brkV
                  break
      else:
         for brkV in c.breakpoints2:
            if brkV.gauche==0 or brkV.droit==0:
               if not telo1:
                  telo1=brkV
               else:
                  telo2=brkV
                  break
      telo1NotContr=(telo1.valid!=-1)*telo1.score
      telo2NotContr=(telo2.valid!=-1)*telo2.score

      ## Tous ont ete VALIDES
      if len(valC(c,1))==int(l1):
         fileDetails.write('All G1 brkpts have been found in outgroup(s):')
         fusorfiss=-1
      elif len(valC(c,2))==int(l2):
         fileDetails.write('All G2 brkpts have been found in outgroup(s):')
         fusorfiss=-1
    
      ## On deduit le nieme
      elif len(valC(c,1))+len(valC(c,2))==max(int(l1),int(l2))-2:
         if len(valC(c,2))==0:
            if not telosIn1:
               if maxiSc!=0 and maxiSc in scoreC(c,1):
                  fileDetails.write("From the n-1 validated G1 brkpts, we validate the nieme brkpt:")
                  fusorfiss=-1
                  for brkV in c.breakpoints1:
                     if brkV.valid!=1:
                        brkV.valScore=0.4
                        brkV.valid=1
                        unvalidate([brkV],c.breakpoints1,fileContradict)
                        break
               else:
                  fileDetails.write("We do not validate the nieme G1 brkpt (it could be telomeres):")
            else:
               if telo1NotContr or telo2NotContr:
                  fileDetails.write("All G1 brkpts (whose telo) have been found in outgroup(s):")
                  telo1.valScore=0.4
                  telo2.valScore=0.4
               else:
                  fileDetails.write("From the n-1 validated G1 brkpts, we validate both telomere (which could be one brkpt in the ancestor):")
                  telo1.valScore=0
                  telo2.valScore=0
               telo1.valid=1
               telo2.valid=1
               fusorfiss=1
         elif len(valC(c,1))==0: 
            if telosIn1:
               if maxiSc!=0 and maxiSc in scoreC(c,2):
                  fileDetails.write('From the n-1 validated G2 brkpts, we validate the nieme brkpt:')
                  fusorfiss=-1
                  for brkV in c.breakpoints2:
                     if brkV.valid!=1:
                        brkV.valScore=0.4
                        brkV.valid=1
                        unvalidate([brkV],c.breakpoints1,fileContradict)
                        break
               else:
                  fileDetails.write("We do not validate the nieme G2 brkpt (it could be telomeres)")
            else:
               if telo1NotContr or telo2NotContr:
                  fileDetails.write("All G2 brkpts (whose telo) have been found in outgroup(s):")
                  telo1.valScore=0.4
                  telo2.valScore=0.4
               else:
                  fileDetails.write("From the n-1 validated G2 brkpts, we validate both telomere (which could be one brkpt in the ancestor):")
                  telo1.valScore=0
                  telo2.valScore=0
                  fusorfiss=1
               telo1.valid=1
               telo2.valid=1
               fusorfiss=1
         else:
            fusorfiss=1
            blsNV=reUsedBlock(reUsedLists)
            if blsNV[0][0]!=blsNV[1][0]:
               # on cree un ou 2 telo (fusion telo) if needed
               if telosIn1:
                  iru=0
               else:
                  iru=2
               if telo1.valid!=-1:
                  if telo1NotContr:
                     telo1.valScore=0.4
                  else:
                     telo1.valScore=0
                  telo1.valid=1
                  fileDetails.write("We validate 1 telomere,")
               elif telo2.valid!=-1:
                  if telo2NotContr:
                     telo2.valScore=0.4
                  else:
                     telo2.valScore=0
                  telo2.valid=1
                  fileDetails.write("We validate 1 telomere,")
               if not((telo1.gauche==blsNV[0][0+iru] and -1==blsNV[0][1+iru]) or
               (telo1.droit==blsNV[0][0+iru] and 1==blsNV[0][1+iru]) or
               (telo2.gauche==blsNV[0][0+iru] and -1==blsNV[0][1+iru]) or
               (telo2.droit==blsNV[0][0+iru] and 1==blsNV[0][1+iru])):
                  brkptsCrees.append(((blsNV[0],0),0.3))
                  fileDetails.write("We create a new 'ancestral telomere' "+blsNV[0][0].name+",")
               if not((telo1.gauche==blsNV[1][0+iru] and -1==blsNV[1][1+iru]) or
               (telo1.droit==blsNV[1][0+iru] and 1==blsNV[1][1+iru]) or
               (telo2.gauche==blsNV[1][0+iru] and -1==blsNV[1][1+iru]) or
               (telo2.droit==blsNV[1][0+iru] and 1==blsNV[1][1+iru])):
                  brkptsCrees.append(((blsNV[1],0),0.3))
                  fileDetails.write("We create a new 'ancestral telomere' "+blsNV[1][0].name+",")
            else: ## sinon bloc circulaire
                  blocsDeleted[1].append((blsNV[0][0],blsNV[0][2]))
                  transpo=blsNV[0][0].name[:-2]
                  fileDetails.write('We delete the bloc '+transpo+' that we cannot localized:')

      ## On cree ou test
      elif len(valC(c,1))+len(valC(c,2))==max(int(l1),int(l2))-3:
            ## ONLY ONE TELO
            if (not(telo1NotContr and telo2NotContr)
            and (telo1NotContr or telo2NotContr)):
               if telo1NotContr:
                  telo1.valScore=telo1.score
                  telo1.valid=1
                  if telosIn1:
                     unvalidate([telo1],c.breakpoints2,fileContradict)
                     reUsedLists[0].remove(telo1)
                  else:
                     unvalidate([telo1],c.breakpoints1,fileContradict)
                     reUsedLists[1].remove(telo1)
               else:
                  telo2.valScore=telo2.score
                  telo2.valid=1
                  if telosIn1:
                     unvalidate([telo2],c.breakpoints2,fileContradict)
                     reUsedLists[0].remove(telo2)
                  else:
                     unvalidate([telo2],c.breakpoints1,fileContradict)
                     reUsedLists[1].remove(telo2)
               # on test
               newBrkpts,transpo=testNewBrkpt(reUsedLists,blocsDeleted,genomes[2:],blocs1,blocs2,fileDetails)
               analyse(c,newBrkpts,brkptsCrees,fileContradict,fileDetails) 
            ## BOTH or NONE
            else:
               ## BOTH
               if telo1NotContr and telo2NotContr:
                  telo1.valScore=telo1.score
                  telo2.valScore=telo2.score
                  telo1.valid=1
                  telo2.valid=1
                  if telosIn1:
                     unvalidate([telo1,telo2],c.breakpoints2,fileContradict)
                     reUsedLists[0].remove(telo1)
                     reUsedLists[0].remove(telo2)
                  else:
                     unvalidate([telo1,telo2],c.breakpoints1,fileContradict)
                     reUsedLists[1].remove(telo1)
                     reUsedLists[1].remove(telo2)
                  blsNV=reUsedBlock(reUsedLists)
                  if blsNV[0][0]!=blsNV[1][0]:
                     brkptsCrees.append(((blsNV[0],blsNV[1]),0.3))
                     fileDetails.write('From the n-1 validated brkpts, we deduce a new ancestral brkpt ('+blsNV[0][0].name+','+blsNV[1][0].name+')')
                  else:
                     transpo=blsNV[0][0].name[:-2]
                     fileDetails.write('We delete the bloc '+transpo+' that we cannot localized:')
                     blocsDeleted[1].append((blsNV[0][0],blsNV[0][2]))
               ## NONE
               else:
                  # on test
                  newBrkpts,transpo=testNewBrkpt(reUsedLists,blocsDeleted,genomes[2:],blocs1,blocs2,fileDetails)
                  analyse(c,newBrkpts,brkptsCrees,fileContradict,fileDetails)
      else:
         fileDetails.write('We cannot identified all ancestral brkpts, only '+str(len(valC(c,1))+len(valC(c,2)))+':')

      n1=max(len([b for b in c.breakpoints1 if b.valid==-1])-1,0)
      n2=max(len([b for b in c.breakpoints2 if b.valid==-1])-1,0)
      if (telo1.valid==1 or telo2.valid==1):
         if fusorfiss==1:
            head='1 fusion/fission to '+genome1+' or '+genome2+', '
            f=2
            n12=min(int(l1),int(l2))-n1-n2
         else:
            if telosIn1:
               head='1 fusion to '+genome2+', '
               f=1
            else:
               head='1 fusion to '+genome1+', '
               f=0
      elif fusorfiss==-1:
         if telosIn1:
            head='1 fission to '+genome1+', '
            f=0
            n1=max(len([b for b in c.breakpoints1 if b.valid==-1])-2,0)
         else:
            head='1 fission to '+genome2+', '
            f=1
            n2=max(len([b for b in c.breakpoints2 if b.valid==-1])-2,0)
      else:
         head='1 fusion/fission to '+genome1+' or '+genome2+', '
         f=2
         if telosIn1:
            n1=max(len([b for b in c.breakpoints1 if b.valid==-1])-2,0)
         else:
            n2=max(len([b for b in c.breakpoints2 if b.valid==-1])-2,0)
      n12=min(int(l1),int(l2))-1-n1-n2
    
      if transpo:
         n1=max(n1-1,0)
         n2=max(n2-1,0)
         head2=' ('+transpo+' deleted)\n'
      else:
         head2='\n'
      if n1:
         head+=str(n1)+' rea to '+genome1+', '
      if n2:
         head+=str(n2)+' rea to '+genome2+', '
      if n12:
         head+=str(n12)+' rea to '+genome1+' or '+genome2+', '
      head=head[:-2]+head2
      fileDetails.write(head+'\n')
      fileBrkpt.write('P'+str(c.length)+'\t'+head)
      writeBrkpts(fileBrkpt,c)
    
      NBREAR[0]+=n1
      NBREAR[1]+=n2
      NBREAR[2]+=n12
      NBREAR[f]+=1


########################################
## CYCLE
#############################
## Cycle de taille 4, 6, 8 ...
def treatCycle(realCycles,blocs,genomes,blocs1,blocs2,fileBrkpt,
               fileContradict,fileDetails,cycles,brkptsCrees,blocsDeleted,NBREAR):

   genome1=genomes[0].name
   genome2=genomes[1].name
   print 'Cycle  ['+genome1+';'+genome2+']'
   fileDetails.write('\nCycle  ['+genome1+';'+genome2+']\n')
   for c in realCycles:
      completeBlocs(c,blocs)
      scoreAndstr(c,genomes,blocs1,blocs2,fileDetails)
      l1=len(c.breakpoints1)*1.
      l2=len(c.breakpoints2)*1.

      maxiSc=max(maxL(scoreC(c,1)),maxL(scoreC(c,2)))
      transpo=0
      ## tous ont ete VALIDES
      if l1==2 and maxiSc!=0 and maxiSc!=1:
         if (sum(scoreC(c,1))>sum(scoreC(c,2)) or
         sum(scoreC(c,1))==sum(scoreC(c,2)) and maxiSc in scoreC(c,1) and maxiSc not in scoreC(c,2)):
            for b in c.breakpoints1:
               b.valid=1
               unvalidate([b],c.breakpoints2,fileContradict)
            fileDetails.write('Sum(score_G1)>Sum(score_G2), brkpts of G1 are both validated:')
         elif (sum(scoreC(c,1))<sum(scoreC(c,2)) or
         maxiSc not in scoreC(c,1) and maxiSc in scoreC(c,2)):
            for b in c.breakpoints2:
               b.valid=1
               unvalidate([b],c.breakpoints1,fileContradict)
            fileDetails.write('Sum(score_G2)>Sum(score_G1), brkpts of G2 are both validated:')
         else:
            fileDetails.write('None of these 4 brkpts are validated\n')

      else:
         while maxiSc>0.4 and (maxiSc>0.9 and len(valC(c,1))+len(valC(c,2))<(l1-1)
         or (maxiSc<=0.9 and len(valC(c,1))+len(valC(c,2))<(l1-2))):
            EGscoreMax(maxiSc,c,fileContradict,fileDetails)
            maxiSc=max(maxL(scoreC(c,1)),maxL(scoreC(c,2)))

         ## on cree la liste des blocs pas encore localises
         reUsedLists=creeReusedList(c)
         transpo=0
      
         ## tous ont ete VALIDES
         if len(valC(c,1))+len(valC(c,2))==int(l1):
            if len(valC(c,1))==int(l1):
               fileDetails.write('All G1 breakpoints have been found in outgroup(s):')
            elif len(valC(c,2))==int(l2): 
               fileDetails.write('All G2 breakpoints have been found in outgroup(s):')
            else:
               print 'Contradiction 1'

         ## tous ceux de G1 ou G2 ont ete unvalidated:
         elif len(unvalC(c,1))==int(l1) or len(unvalC(c,2))==int(l2):
            if len(valC(c,1))+len(valC(c,2))==int(l1)-1:
               scoreV=0.4
            else:
               scoreV=0.35
            if len(unvalC(c,1))==int(l1):
               fileDetails.write('All G1 breakpoints have been unvalidated, we validated the last G2 breakpoints:')
               for brkV in c.breakpoints2:
                  if brkV.valid==0:
                     brkV.valScore=scoreV
                     brkV.valid=1
            else:
               fileDetails.write('All G2 breakpoints have been unvalidated, we validated the last G1 breakpoints:')
               for brkV in c.breakpoints1:
                  if brkV.valid==0:
                     brkV.valScore=scoreV
                     brkV.valid=1

         ## le nime est DEDUISABLE
         elif len(valC(c,1))+len(valC(c,2))==int(l1)-1:
            blsNV=reUsedBlock(reUsedLists)
            if len(blsNV)==2:
               if blsNV[0][0]!=blsNV[1][0]:
                  brkptsCrees.append(((blsNV[0],blsNV[1]),0.3))
                  fileDetails.write('From the n-1 validated brkpts, we deduce a new ancestral brkpt ('+blsNV[0][0].name+','+blsNV[1][0].name+')')
               else: ## sinon bloc circulaire
                  blocsDeleted[1].append((blsNV[0][0],blsNV[0][2]))
                  transpo=blsNV[0][0].name[:-2]
                  fileDetails.write('We delete the bloc '+str(transpo)+' that we cannot localized:')
            else:
               print 'Normally only two blocks are not localized, not',len(blsNV), #,len(valC(c,1)),len(valC(c,2)),int(l1)

         ## les n et n-1 ime brkpts st TESTABLES
         elif len(valC(c,1))+len(valC(c,2))==int(l1)-2:
            newBrkpts,transpo=testNewBrkpt(reUsedLists,blocsDeleted,genomes[2:],blocs1,blocs2,fileDetails)
            analyse(c,newBrkpts,brkptsCrees,fileContradict,fileDetails)

         else:
            fileDetails.write('We cannot identified all ancestral brkpts, only '+str(len(valC(c,1))+len(valC(c,2))))

      if not transpo:
         n1=max(len([b for b in c.breakpoints1 if b.valid==-1])-1,0)
         NBREAR[0]+=n1
         n2=max(len([b for b in c.breakpoints2 if b.valid==-1])-1,0)
         NBREAR[1]+=n2
         n12=int(l1)-1-n1-n2
         NBREAR[2]+=n12
         head2='\n'
      else:
         n1=max(len([b for b in c.breakpoints1 if b.valid==-1])-2,0)
         NBREAR[0]+=n1
         n2=max(len([b for b in c.breakpoints2 if b.valid==-1])-2,0)
         NBREAR[1]+=n2
         n12=int(l1)-3-n1-n2
         NBREAR[2]+=n12
         head2=' ('+transpo+' deleted)\n'
      head=''
      if n1:
         head+=str(n1)+' rea to '+genome1+', '
      if n2:
         head+=str(n2)+' rea to '+genome2+', '
      if n12:
         head+=str(n12)+' rea to '+genome1+' or '+genome2+', '
      head=head[:-2]+head2
      fileDetails.write(head+'\n')
      fileBrkpt.write('C'+str(c.length)+'\t'+head)
      writeBrkpts(fileBrkpt,c)


### involveTelomericBlocks(oddPath,blocs)
#   return [[c1],[c2]] with c1 in oddPath that involves a block validated as telomeric (blocs)
def involvesTelomericBlocks(oddPath,blocs):
   res=[[],[]]
   for c in oddPath:
      non=1
      for br1 in c.breakpoints1:
         if br1.gauche in blocs[0] or br1.droit in blocs[0]:
            non=0
      res[non].append(c)
   return res

### completeBlocs(c,blocs)
#   completes 'blocs' with the blocs involved in c
def completeBlocs(c,blocs):
   for br1 in c.breakpoints1:
      br1g=br1.gauche
      if br1g!=0 and br1g not in blocs[0]:
         blocs[0].append(br1g)
         b1gn=br1g.name[:6]
         for br2 in c.breakpoints2:
            br2g=br2.gauche
            br2d=br2.droit
            if br2g!=0 and b1gn==br2g.name[:6]:
               blocs[1].append(br2g)
               break
            elif br2d!=0 and b1gn==br2d.name[:6]:
               blocs[1].append(br2d)
               break
      br1g=br1.droit
      if br1g!=0 and br1g not in blocs[0]:
         blocs[0].append(br1g)
         b1gn=br1g.name[:6]
         for br2 in c.breakpoints2:
            br2g=br2.gauche
            br2d=br2.droit
            if br2g!=0 and b1gn==br2g.name[:6]:
               blocs[1].append(br2g)
               break
            elif br2d!=0 and b1gn==br2d.name[:6]:
               blocs[1].append(br2d)
               break
