#!/usr/bin/env python
# -*- coding: utf-8 -*-
## n05ValCycles

from n00Objets import *

#################
## VALIDATION of PATHS and CYCLES
#################


## MAIN MAIN
# on valide les cycles en partant des plus petits
def validationCycles(packs1,packs2,cycles,fileD,fileName,t=0):

   # on groupe les packs lies par les memes cycles: list de list of packs
   packChosen=groupPacks(packs1,packs2,fileName)
   cyclesValidated=valCycles(cycles,packChosen)
   delBl=[]
   for (p,c) in packChosen:
      lB=p.combinations[c]
      for b in lB:
         b.block.sign=b.sign
      for b in p.blocks:
         if b not in map((lambda x:x.block),lB):
            delBl.append(b)

   resD='Validated CYCLES\n'
   cyclesValidatedS=sorted(cyclesValidated,key=lambda x : (x.length,not x.isPath()))
   lenPrev=ip=1
   nbLenPrev=0
   res=''
   for c in cyclesValidatedS:
      for b in c.breakpoints1+c.breakpoints2:
         if b.gauche!=0:
            b.gauche.next=b.droit
            if 'v' in b.gauche.name:
               b.gauche.block.blocksV=b.gauche
               b.gauche.block.sign=b.gauche.sign
               b.gauche.block.next=b.droit
               b.gauche.block.blockG.setBlockG(b.gauche)
               if 'v' in b.gauche.block.blockG.name:
                  b.gauche.block.blockG.block.setBlockG(b.gauche)
               else:
                  if type(b.gauche.block.blockG.blocksV)==list:
                     for bvir in b.gauche.block.blockG.blocksV:
                        bvir.setBlockG(b.gauche)
                  else:
                     b.gauche.block.blockG.blocksV.setBlockG(b.gauche)
         if b.droit!=0:
            b.droit.previous=b.gauche
            if 'v' in b.droit.name:
               b.droit.block.blocksV=b.droit
               b.droit.block.sign=b.droit.sign
               b.droit.block.previous=b.gauche
               b.droit.block.blockG.setBlockG(b.droit)
               if 'v' in b.droit.block.blockG.name:
                  b.droit.block.blockG.block.setBlockG(b.droit)
               elif b.droit.block.blockG.blocksV:
                  if type(b.droit.block.blockG.blocksV)==list:
                     for bvir in b.droit.block.blockG.blocksV:
                        bvir.setBlockG(b.droit)
                  else:
                     b.droit.block.blockG.blocksV.setBlockG(b.droit)

      if c.isPath():
         if (c.length!=lenPrev) or (c.length==lenPrev and not ip):
            if ip:
               resD+='\n'+str(nbLenPrev)+' PATHs of length '+str(lenPrev)+'\n'
            else:
               resD+='\n'+str(nbLenPrev)+' CYCLEs of length '+str(lenPrev)+'\n'
            resD+=res
            nbLenPrev=1
            lenPrev=c.length
            ip=1
            res=''
         else:
            nbLenPrev+=1
         res+=str(c)+'\n'
      else:
         if (c.length!=lenPrev) or (c.length==lenPrev and ip):
            if ip:
               resD+='\n'+str(nbLenPrev)+' PATHs of length '+str(lenPrev)+'\n'
            else:
               resD+='\n'+str(nbLenPrev)+' CYCLEs of length '+str(lenPrev)+'\n'
            resD+=res
            nbLenPrev=1
            lenPrev=c.length
            ip=0
            res=''
         else:
            nbLenPrev+=1
         res+=str(c)+'\n'
   if ip:
      resD+='\n'+str(nbLenPrev)+' PATH of length '+str(lenPrev)+'\n'
      resD+=res
   else:
      resD+='\n'+str(nbLenPrev)+' CYCLE of length '+str(lenPrev)+'\n'
      resD+=res

   outD=open(fileD,'w')
   outD.write(resD)
   outD.close()
   return delBl,cyclesValidatedS


#####
## on groupe les packs lies par les memes blocs
# list de list de packs grouped together
def groupPacks(packs1,packs2,fileName):
   packs=packs1+packs2
   blocInP=[]
   for p in packs:
      if p.name[0]=='P':
         p.setScoreList()
         blocIn=[]
         for b in p.blocks:
            blocIn.append(b.name[:6])
         blocInP.append(blocIn)

   groupedB=[blocInP[0]]
   for bs in blocInP: #blocks d'un meme pack
      res=[]
      for i,gb in enumerate(groupedB): # blocks liants des packs entre eux
         if [x for x in bs if x in gb]!=[]: #intersection!=[]
            res.insert(0,i)
      if res==[]:
         groupedB.append(bs)
      elif len(res)==1:
         for x in bs:
            if x not in groupedB[res[0]]:
               groupedB[res[0]].append(x)
      else:
         fusion=[]
         for i in res:
            for x in groupedB[i]:
               if x not in fusion:
                  fusion.append(x)
            groupedB.remove(groupedB[i])
         for x in bs:
            if x not in fusion:
               fusion.append(x)
         groupedB.append(fusion)

   groupedP=[]
   for g in groupedB:   # traduction of GroupsofBlocks to GroupsofPacks
      groupedP.append([[],[]])
   for p in packs1:
      if p.name[0]=='P':
         for i,gb in enumerate(groupedB):
            if [x for x in p.blocks if x.name[:6] in gb]!=[]:
               groupedP[i][0].append(p)
   for p in packs2:
      if p.name[0]=='P':
         for i,gb in enumerate(groupedB):
            if [x for x in p.blocks if x.name[:6] in gb]!=[]:
               groupedP[i][1].append(p)
   return bestAssoCombi(groupedP,fileName)

## pour chaque groupe choisit la meilleur association de combis possible
def bestAssoCombi(packsGrouped,fileName):
   res=[]
   resD='Different (or only one) combinations of BLOCKS (first pair), in G1 (first list of list) and in G2,\n'
   resD+='and their associated scores (second pair)'
   for g in packsGrouped:
      blocsList=[[],[]]
      scoreList=[[],[]]
      combiList=[[],[]]
      for p in g[0]:
         combisP=[]
         for c in p.combinations:
            combisP.append([])
            for b in c:
               combisP[-1].append(b.name[:6])
         blocsList[0].append(combisP)
         scoreList[0].append(p.scores)
         combiList[0].append([[(p,x)] for x in range(len(p.scores))])
      ## on mixe les diff combi de G1
      mixedBlock1,addedScore1,mixedCombi1=mixeSameG(blocsList[0],scoreList[0],combiList[0])
      blocsList[0]=mixedCombi1
      scoreList[0]=addedScore1

      for p in g[1]:
         combisP=[]
         for c in p.combinations:
            combisP.append([])
            for b in c:
               combisP[-1].append(b.name[:6])
         blocsList[1].append(combisP)
         scoreList[1].append(p.scores)
         combiList[1].append([[(p,x)] for x in range(len(p.scores))])
      ## on mixe les diff combi de G2
      mixedBlock2,addedScore2,mixedCombi2=mixeSameG(blocsList[1],scoreList[1],combiList[1])
      blocsList=[mixedBlock1,mixedBlock2]
      scoreList=[addedScore1,addedScore2]
      combiList=[mixedCombi1,mixedCombi2]
      resD+='\n\n('+str(blocsList[0])+','+str(blocsList[1])+')   ('+str(scoreList[0])+','+str(scoreList[1])+')\n'

      packCombiVal=mixeDiffG(blocsList,scoreList,combiList)
      resD+='(Pack,the validated combination) :'
      for (p,c) in packCombiVal:
         resD+='('+p.name+','+str(c)+') '
      res.extend(packCombiVal)
   fileO=open(fileName,'w')
   fileO.write(resD+'\n')
   fileO.close()
   return res

def mixeSameG(blocsList,scoreList,combiList):
   if blocsList==[]:
      return [],[],[]
   elif len(blocsList)==1:
      return blocsList[0],scoreList[0],combiList[0]
   else:
      cres=[]
      sres=[]
      pres=[]
      c1=blocsList[0]
      c2=blocsList[1]
      for i,c in enumerate(c1):
         for j,cc in enumerate(c2):
            cres.append(c+cc)
            sres.append(scoreList[0][i]+scoreList[1][j])
            pres.append(combiList[0][i]+combiList[1][j])
      blocsList.remove(blocsList[0])
      blocsList.remove(blocsList[0])
      blocsList.insert(0,cres)
      scoreList.remove(scoreList[0])
      scoreList.remove(scoreList[0])
      scoreList.insert(0,sres)
      combiList.remove(combiList[0])
      combiList.remove(combiList[0])
      combiList.insert(0,pres)
      return mixeSameG(blocsList,scoreList,combiList)

def mixeDiffG(blocsList,scoreList,combiList):
   G1=blocsList[0]
   G2=blocsList[1]
   if G1==[]:
      return combiList[1][scoreList[1].index(min(scoreList[1]))]
   elif G2==[]:
      return combiList[0][scoreList[0].index(min(scoreList[0]))]
   else:
      interG1=inter(G1)
      interG2=inter(G2)
      score=[]
      packC=[]
      for i in range(len(G1)):
         for j in range (len(G2)):
            if ([x for x in G1[i] if x not in interG1 and x not in G2[j]]==[]
               and [x for x in G2[j] if x not in interG2 and x not in G1[i]]==[]):
               score.append(scoreList[0][i]+scoreList[1][j])
               packC.append(combiList[0][i]+combiList[1][j])
      return packC[score.index(min(score))]

def inter(l):
   if len(l)==1:
      return l[0]
   else:
      i=[x for x in l[0] if x in l[1]]
      if len(l)==2:
         return i
      else:
         return inter([i]+l[2:])

def valCycles(cycles,packChosen):
   cyclesValidated=[]
   for c in cycles:
      if c.packsAndCombi1=={} and c.packsAndCombi2=={}:
         cyclesValidated.append(c)
      else:
         flag=[]
         for k,v in c.packsAndCombi1.iteritems():
            f=0
            for vv in v:
               if (k,vv) in packChosen:
                  f=1
            flag.append(f)
         for k,v in c.packsAndCombi2.iteritems():
            f=0
            for vv in v:
               if (k,vv) in packChosen:
                  f=1
            flag.append(f)
         if 0 not in flag:
            cyclesValidated.append(c)
   return cyclesValidated