#!/usr/bin/env python
# -*- coding: utf-8 -*-
## n04CreCycles

import time
from n00Objets import *
import n05ValCycles

#################
## CREATION of PATHS and CYCLES
#################

#trie fin et pas fin de chromosome
def divideExtremitesBrkpt(breakpoints):
   extremites=[]
   inside=[]
   for bp in breakpoints:
      if bp.gauche==0 or bp.droit==0:
         extremites.append(bp)
      else:
         inside.append(bp)
   return (extremites,inside)

## PATH
# renvoie les cycles qui continue le path donn
# block est le dernier block implique ds path,
# side==1 if on cherche le brkpt right du block donn
# g est le gnome ds lequel on cherche
def auxPath(path,bl,side,extremites,g,t=0):
   if t and time.time()>t:
      raise ValueError  (u"Arret du calcul demande")
   cycles=[]
   if 'v' in bl.name:
      blockG2=bl.block.blockG
   else:
      blockG2=bl.blockG
   if side==1:
      lBrkpt=blockG2.brkptRight
   else:
      lBrkpt=blockG2.brkptLeft
   for bp in lBrkpt:
      if bp.gauche==0 or bp.droit==0:  # s'arrette si cycle deja consider
         #print 'fin'
         if bp in extremites:
            try:
               newpath=Cycle(path)
               if newpath.addbrkpt(bp,g): # s'arrette si contradiction entre breakpoints precedents
                  cycles.append(newpath)
               else:
                  #print 'contradict'
                  del(newpath)
            except RuntimeError:
               raise ValueError  (u"RuntimeError: Maximum recursion depth exceeded")
      else:
         try:
            newpath=Cycle(path)
            if newpath.addbrkpt(bp,g):
               if bp.gauche.name[:7]==blockG2.name[:7]:     #(+old,new) #(-old,new)
                  #(+old,+new) #(-old,+new) #(+old,-new) or (+new,-old) #(-old,-new) or (+new,+old)
                  cycles.extend(auxPath(newpath,bp.droit,-1*bp.droit.sign,extremites,g*-1,t))
               else:
                  #(+new,-old) #(+new,+old) #(-new,-old) or (+old,+new) #(-new,+old) or (+old,+new)
                  cycles.extend(auxPath(newpath,bp.gauche,bp.gauche.sign,extremites,g*-1,t))
            else:
               #print 'contradict'
               del(newpath)   # s'arrete si contradiction entre breakpoints precedents
         except RuntimeError:
               raise ValueError  (u"RuntimeError: Maximum recursion depth")
            
   del(path)
   return cycles        

def path(extremites,i,t=0):
   brkpt1=extremites[0]
   path=Cycle()
   path.addbrkpt(brkpt1,i)

   if brkpt1.gauche==0:  ## (0,A)
      if brkpt1.droit==0:   ## (0,0)
         return [path]
      elif brkpt1.droit.sign==0:
         print 'Erreur l 249 n08Cycles : normalement tous les blocs ont un signe!'
      else:
         #print 'd',brkpt1.droit.name
         x=auxPath(path,brkpt1.droit,-1*brkpt1.droit.sign,extremites,i*-1,t)
         return x
   
   else:                   ## (A,0)
      if brkpt1.gauche.sign==0:
         print 'Erreur l 259 n08Cycles : normalement tous les blocs ont un signe!'
      else:
         #print 'g',brkpt1.gauche.name
         x=auxPath(path,brkpt1.gauche,brkpt1.gauche.sign,extremites,i*-1,t)
         return x


## CYCLE
def auxCycle(oldCycle,bl,side,insides,g,t=0):
   if t and time.time()>t:
      raise ValueError  (u"Arret du calcul demande")
   cycles=[]
   if 'v' in bl.name:
      blockG2=bl.block.blockG
   else:
      blockG2=bl.blockG
   if side==1:
      lBrkpt=blockG2.brkptRight
   else:
      lBrkpt=blockG2.brkptLeft
   for bp in lBrkpt:
      if bp.gauche!=0 and bp.droit!=0:  # sinon s'arrette car path
         if oldCycle.endCycle(bp,g):
            cycles.append(oldCycle)
         elif bp in insides:
            newCycle=Cycle(oldCycle)
            if newCycle.addbrkpt(bp,g):
               if bp.gauche.name[:7]==blockG2.name[:7]:     #(+old,new) #(-old,new)
                  cycles.extend(auxCycle(newCycle,bp.droit,-1*bp.droit.sign,insides,g*-1,t))
               else:
                  cycles.extend(auxCycle(newCycle,bp.gauche,bp.gauche.sign,insides,g*-1,t))
            else:
               del(newCycle)   # s'arrette si contradiction entre breakpoints precedents
   del(oldCycle)
   return cycles        

def cycle(insides,i,t=0):
   brkpt1=insides[0]
   newcycle=Cycle()
   newcycle.addbrkpt(brkpt1,i)

   if brkpt1.gauche.sign==1:
      x=auxCycle(newcycle,brkpt1.gauche,1,insides,i*-1,t)
      return x
   else:
      x=auxCycle(newcycle,brkpt1.gauche,-1,insides,i*-1,t)
      return x 


## MAIN MAIN
def cycles2GenomesSynthesis(packs1,packs2,breakpoints1,breakpoints2,fileD,fileName,time=0):    
   ## on cree les cycles !!
   print "\nCYCLES"
   cycles=creationCycles(breakpoints1,breakpoints2,time)
   nbCycle=len(cycles)
   maxLenC=max(map(lambda c:c.length,cycles))
   assoCyclesToBrkpts(cycles)
   assoCyclesToPacks(breakpoints1)
   assoCyclesToPacks(breakpoints2)
   try:
      return nbCycle,maxLenC,n05ValCycles.validationCycles(packs1,packs2,cycles,fileD,fileName,time)
   except RuntimeError:
      raise ValueError  (u"RuntimeError: Maximum recursion depth")

    
def creationCycles(breakpoints1,breakpoints2,t=0):
   cycles=[]
   (extremites1,inside1)=divideExtremitesBrkpt(breakpoints1)
   (extremites2,inside2)=divideExtremitesBrkpt(breakpoints2)

   ## creation des paths
   extremites1.extend(extremites2)
   for i in range(len(extremites1)-len(extremites2)):
      cycles.extend(path(extremites1[i:],1,t))
   print 'End of the path definition starting and finishing in G1'
   for i in range(len(extremites2)):
      #print extremites2[i]
      cycles.extend(path(extremites2[i:],-1,t))
   print 'End of the path definition starting and finishing in G2'

   ## creation des cycles
   inside1.extend(inside2)
   for i in range(len(inside1)):
      cycles.extend(cycle(inside1[i:],1,t)) 

   maxi=max(map(lambda c:c.length,cycles))
   print 'Number of CYCLES:',len(cycles),' Maximum lenght:', maxi,'\n'
   return cycles


######################################################
# ASSOCIATION
####

## on associe le cycle  chacun des breakpoints correspondants
def assoCyclesToBrkpts(cycles):
   for cycle in cycles:
      for b in cycle.breakpoints1:
         for k,v in b.packCombi.iteritems():
            if k not in b.packCombiCycles.keys():
               b.packCombiCycles[k]={}
            for combi in v:
               if combi not in b.packCombiCycles[k].keys():
                  b.packCombiCycles[k][combi]=[cycle]
               else:
                  b.packCombiCycles[k][combi].append(cycle)
      for b in cycle.breakpoints2:
         for k,v in b.packCombi.iteritems():
            if k not in b.packCombiCycles.keys():
               b.packCombiCycles[k]={}
            for c in v:
               if c not in b.packCombiCycles[k].keys():
                  b.packCombiCycles[k][c]=[cycle]
               else:
                  b.packCombiCycles[k][c].append(cycle)      

## on remplit les pack.cycles
def assoCyclesToPacks(breakpoints):
   for b in breakpoints:
      for k,v in b.packCombiCycles.iteritems():
         if k.cyclesCombi==[]:
            k.createCycles()
         for kk in v.keys():   #kk=combi
            cmini=min(b.packCombiCycles[k][kk],key=lambda x : x.length)
            k.cyclesCombi[kk].append(cmini)    
                


