#!/usr/bin/env python
# -*- coding: utf-8 -*-
## n02Packs

############################################################################
## Construction de PACK
## on definie 'previous', 'next' et 'pack' des blocks
############################################################################

from n00Objets import *
import re

#################################
##  MAIN      MAIN      MAIN   ##
# fonctions appelees du script2 #
#################################
def addStr(x, y): return str(x+y)

def packs2GenomesSynthesis(blocs1,blocs2,genomes3):
   print "\nPACKS"
   packs1,nbpack1=creationPacks(blocs1,genomes3)
   packs2,nbpack2=creationPacks(blocs2,genomes3)
   return packs1,packs2,nbpack1+nbpack2
  
######
##
def creationPacks(blocs1,genomes3):
   blocksPacksList=[]
   nbpack=0
   previous=0
   for block in blocs1:
      combiList=fPack(block,0,genomes3)
      # un bloc non (inclus ou overlappant sur la gauche)
      if combiList!=[]:                       
         if type(combiList[0])!=list:        # un BLOCK un vrai
            blocksPacksList.append(block)
            if previous!=0:
               if previous.chromo==block.chromo:       
                  previous.next=block     
                  block.previous=previous
               else:
                  previous.next=0
                  block.previous=0
            else:
               block.previous=0
            previous=block
         else:                               # un PACK un vrai
            nbpack+=1     
            prePackLists=[combiList]
            chevR=block.overlapR
            while chevR!=0:
               while chevR.including!=[]:
                  chevR=chevR.including[0]
               prePackLists.append(fPack(chevR,1,genomes3))
               chevR=chevR.overlapR
            combiList=chevauchPack(prePackLists) 
            newPack=Pack('P'+block.name[1:],block.chromo,combiList)
            blocksPacksList.append(newPack)
            newPack.setBlocks(block)
            if previous!=0:
               if previous.chromo==newPack.chromo: 
                  previous.next=newPack
                  newPack.previous=previous
               else:
                  previous.next=0
                  newPack.previous=0
            else:
               newPack.previous=0
            previous=newPack
   return blocksPacksList,nbpack

# i=0 premier pack
# renvoie [] si le block est inclus ou overlap sur sa gauche
#                         -> il sera traite a travers un autre
# renvoie [block] si le block est seul
# renvoie les differentes combi otherwise    
def fPack(block,i,genomes3):
   if i==0:
      if (block.including==[] and block.overlapL==0 and
         (block.sign==0 or block.overlapR!=0 or
            block.isIncludedG() or block.isInSubtelo() or
            block.included!=[])):
         return prePack(block,genomes3)
      else:
         if block.including!=[] or block.overlapL!=0:
            return []
         else:
            return [block]
   else:     # creation d'un pre-pack pour une suite de chevauchement
      if (block.sign==0 or block.overlapR!=0 or
         block.isIncludedG() or block.isInSubtelo() or
         block.included!=[]):
         return prePack(block,genomes3)
      else:
         newBlv=Blockv(block,0)
         block.addBlocksV(newBlv)
         return [[newBlv]]

# creation d'un pack ou pre-pack sans chevauchement
def prePack(block,genomes3):
   if block.included==[]:
      # UNSIGNED BLOCK
      if block.sign==0:
         newBlv1=Blockv(block,-1)
         newBlv2=Blockv(block,1)
         block.addBlocksV(newBlv1)
         block.addBlocksV(newBlv2)
         if block.isIncludedG() or block.isInSubtelo():
            return [[newBlv1],[newBlv2],[]]
         else:
            return [[newBlv1],[newBlv2]]
      # EXISTENCE ??
      elif block.isIncludedG() or block.isInSubtelo():
         newBlv=Blockv(block,0)
         block.addBlocksV(newBlv)
         return [[newBlv],[]]
      # OVERLAPPING BLOCK only block.overlapR!=0
      elif block.overlapR!=0:
         newBlv=Blockv(block,0)
         block.addBlocksV(newBlv)
         return [[newBlv]]
   else:
      # DUPLICATED BLOCK
      # on traite ts les blocs de la mme faon ie 1 par 1 ou aucun
      if isIncluded(block,block.included)!=0:
         res=[[]]
         l=block.included[:]
         l.append(block)
         for i in l:
            (a,b)=creatV(i)
            res.extend([[a],[b]])
         return res
      else:
         blList=[]
         if block.sign==0:
            newBlv1=Blockv(block,-1)
            newBlv2=Blockv(block,1)
            block.addBlocksV(newBlv1)
            block.addBlocksV(newBlv2)
            blList.extend([newBlv1,newBlv2])
         else:
            newBlv=Blockv(block,0)
            block.addBlocksV(newBlv)
            blList.append(newBlv)
         if block.isIncludedG() or block.isInSubtelo():
            blList.append(0)
         return diffcombi(blList,block.included[:],genomes3)

# On cree les differents blocs
def creatV(bl):
   if bl.sign==0:
      newBlv1=Blockv(bl,1)
      newBlv2=Blockv(bl,-1)
   elif bl.sign==-1:
      newBlv1=Blockv(bl,-1,1)
      newBlv2=Blockv(bl,1,-1)
   elif bl.sign==1:
      newBlv1=Blockv(bl,1,1)
      newBlv2=Blockv(bl,-1,-1)
   bl.addBlocksV(newBlv1)
   bl.addBlocksV(newBlv2)    
   return newBlv1,newBlv2

# Cree les differents ordres partiels des blocks inclus B -B S1S2...       
def diffcombi(lBs,Ss,genomes3):
   Ssbis=[]
   #print 'Ss',Ss[0]
   Ss=triBloc(Ss)
   for bl in lBs:
      if bl==0:
         Ssbis.append([])
      else:
         Ssbis.append([bl])
   liste=[]
   for i in range(len(Ss)):
      liste.append(creatV(Ss[i]))
   for bl in lBs:
      if bl!=0:
         for i in range(len(Ss)):
            Ssbis.extend(auxDiffcombi1(bl,liste[i],Ss[i],genomes3))
            for j in range(i+1,len(Ss)):
               #print 'smallBV1,smallBV2',Ss,Ss[i],Ss[j]
               Ssbis.extend(auxDiffcombi2(bl,liste[i],Ss[i],
                                          liste[j],Ss[j],genomes3))
   return Ssbis

def auxDiffcombi1(bigB,(newBlv1,newBlv2),smallBV,genomes3):
   res = intermediateGenome(bigB,smallBV,genomes3)
   if res==0:
      return [[newBlv1,bigB],[newBlv2,bigB],[bigB,newBlv1],[bigB,newBlv2]]
   elif res>0:
      return [[bigB,newBlv1],[bigB,newBlv2]]
   else:
      return [[newBlv1,bigB],[newBlv2,bigB]]

def auxDiffcombi2(bigB,(newBlv11,newBlv12),smallBV1,(newBlv21,newBlv22),
                  smallBV2,genomes3):
   res1=intermediateGenome(bigB,smallBV1,genomes3)
   res2=intermediateGenome(bigB,smallBV2,genomes3)
   if res1==0:
      if res2==0:    
         return [[newBlv22,newBlv11,bigB],[newBlv12,newBlv22,bigB],
               [bigB,newBlv21,newBlv12],[bigB,newBlv12,newBlv22],
               [newBlv12,bigB,newBlv22]]
      elif res2>0:
         return [[bigB,newBlv21,newBlv12],[bigB,newBlv12,newBlv22],
               [newBlv12,bigB,newBlv22]]
      else:
         return [[newBlv22,newBlv11,bigB],[newBlv12,newBlv22,bigB]]
   elif res1>0:
      if res2==0:    
         return [[bigB,newBlv21,newBlv12],[bigB,newBlv12,newBlv22]]
      elif res2>0:
         return [[bigB,newBlv21,newBlv12],[bigB,newBlv12,newBlv22]]
      else:
         return []
   else:
      if res2==0:    
         return [[newBlv22,newBlv11,bigB],[newBlv12,newBlv22,bigB],
               [newBlv12,bigB,newBlv22]]
      elif res2>0:
         return [[newBlv12,bigB,newBlv22]]
      else:
         return [[newBlv22,newBlv11,bigB],[newBlv12,newBlv22,bigB]]

## Remets les blocs ds l'ordre        
def triBloc(listBlocs):
   blocsTrie=[listBlocs[0]]
   listBlocs.remove(listBlocs[0])
   for bloc in listBlocs:
      if bloc.bornes[0]<blocsTrie[0].bornes[0]:
         blocsTrie.insert(0,bloc)
      else:
         for i in range(len(blocsTrie)-1):
            if (bloc.bornes[0]>=blocsTrie[i].bornes[0]
                  and bloc.bornes[0]<=blocsTrie[i+1].bornes[0]):
               blocsTrie.insert(i+1,bloc)
               break
         if bloc.bornes[0]>blocsTrie[-1].bornes[0]:
            blocsTrie.append(bloc)
   return blocsTrie

# groupe plusieurs prePacks
def chevauchPack(prePackList):
   #print 'chevauchPack', prePackList
   result=[]
   if len(prePackList)==2:
      for i in range(len(prePackList[0])):
         for j in range(len(prePackList[1])):
            #print prePackList[0][i],prePackList[1][j]
            result.append(prePackList[0][i]+prePackList[1][j])
   elif len(prePackList)>2:
      #print prePackList[0]
      return chevauchPack([prePackList[0],chevauchPack(prePackList[1:])])
   else:
      return prePackList[0]
   return result            


## fonction qui pour un block, un block inclus, des outgroups [ bl [inclBl] ]
# renvoie 0 si on ne peut rien dire, 1 si on le trouve  droite [bl][inclBl], -1  gauche[inclBl][bl]
def intermediateGenome(blv,inclBl,genomes3=0):
   if genomes3==0:
      return 0
   bl=blv.block
   #inclBl=inclBlv.block
   name=bl.genes[0].genome.name
   bornesBl=bl.bornes
   bornesInclBl=inclBl.bornes
   b1bornes=(bornesBl[0],bornesInclBl[0]-1)
   b2bornes=bornesInclBl
   b3bornes=(bornesInclBl[1]+1,bornesBl[1])
   res=0
   for g in genomes3:
      blocksG1,blocksG2,blocksG3=blocksOut(bl,b1bornes,b2bornes,b3bornes)
      # l'intersection
      inter=filter(lambda x:x in blocksG1,(filter(lambda x:x in blocksG2,blocksG3)))
      if inter!=[]:
         for bloc in inter:
            bornesG1,bornesG2,bornesG3=bornesOut(bl,bloc,b1bornes,b2bornes,b3bornes)
            if bornesG1[1]<bornesG3[0] and bornesG3[1]<bornesG2[0]:
               res+=1
            elif bornesG2[1]<bornesG3[0] and bornesG3[1]<bornesG1[0]:
               res+=1
            elif bornesG3[1]<bornesG1[0] and bornesG1[1]<bornesG2[0]:
               res-=1
            elif bornesG2[1]<bornesG1[0] and bornesG1[1]<bornesG3[0]:
               res-=1
   if res!=0:
      print 'on a resolue localement le bloc inclue', inclBl, 'dans', bl, 'res=',res
   return res
          
## revoit les blocks des genes  l'interieur des bornes
# bornes1 genes de gauche qui inclus bornes2 et bornes ceux de droite
def blocksOut(bl,b1bornes,b2bornes,b3bornes):
   blocksG1=[]
   blocksG2=[]
   blocksG3=[]
   for g1 in bl.genes:
      if b1bornes[0]<=g1.position and g1.position<=b1bornes[1]:
         blocksG1=miseAJourBlocks(g1,blocksG1)
      elif b2bornes[0]<=g1.position and g1.position<=b2bornes[1]:
         blocksG2=miseAJourBlocks(g1,blocksG2)
      else:
         blocksG3=miseAJourBlocks(g1,blocksG3)
   return blocksG1,blocksG2,blocksG3
        
def miseAJourBlocks(g1c,blocksG1):
  if g1c.BDBH!=0:
     blocksG1=blocksG1+filter(lambda x:x not in blocksG1, g1c.BDBH[0].blocks)
  for g1c30 in g1c.homologues30:
     blocksG1=blocksG1+filter(lambda x:x not in blocksG1, g1c30[0].blocks)
  return blocksG1

## renvoie les bornes des homologues ds g3
def bornesOut(bl,bloc,b1bornes,b2bornes,b3bornes):
   bornesG1=(100000,0)
   bornesG2=(100000,0)
   bornesG3=(100000,0)
   for g1 in bl.genes:
      if b1bornes[0]<=g1.position and g1.position<=b1bornes[1]:
         bornesG1=miseAJourBornes(bloc,g1,bornesG1)
      elif b2bornes[0]<=g1.position and g1.position<=b2bornes[1]:
         bornesG2=miseAJourBornes(bloc,g1,bornesG2)
      else:
         bornesG3=miseAJourBornes(bloc,g1,bornesG3)
   return bornesG1,bornesG2,bornesG3
          
def miseAJourBornes(bloc,g1c,bornesG1):
   posS=[]
   if g1c.BDBH!=0:
      if bloc in g1c.BDBH[0].blocks:
         posS.append(g1c.BDBH[0].position)
   for g1c30 in g1c.homologues30:
      if bloc in g1c30[0].blocks:
         posS.append(g1c30[0].position)
   for posG1 in posS:
      if posG1<bornesG1[0]:
         bornesG1=(posG1,bornesG1[1])
      if posG1>bornesG1[1]:
         bornesG1=(bornesG1[0],posG1)
   return bornesG1
  
  
