#!/usr/bin/env python
# -*- coding: utf-8 -*-
###############################################################################
# Some small functions to get the characteristics of the chromosomes of a genomes

import re, os


###################
## USE in Script_SyntenyBlocks

## RETURN le nombre de genes d'une espece 'speciesName' appartenant a un groupe 'organismName'
#def nbGenes(path, speciesName):
#    os.system("grep -c '^gene' "+path+'/01Genomes/'+speciesName+'.def >nb')
#    nb=open('nb','r')
#    k=int(nb.readline())
#    nb.close()
#    os.remove('nb')
#    print('fini')
#    return k

## RETURN 3 lists: the names, the centromere positions, the last feature numbers
# for a given species
def chromosomesLists(path, speciesName):
   chromoFile=open(path+'/01Genomes/'+speciesName+'.ch','r')
   line=chromoFile.readline()
   ligneSplit=re.split('\t',line)
   name=ligneSplit[:-1]
   line=chromoFile.readline()
   ligneSplit=re.split('\t',line)
   centro=map(int,ligneSplit[:-1])
   line=chromoFile.readline()
   ligneSplit=re.split('\t',line)
   end=map(int,ligneSplit[:-1])
   chromoFile.close
   return name,centro,end

# Return the list of the different .def found in the 01Genomes/ directory
def ListShortName(path):
   ## Genome
   genomesL=os.listdir(path+'/01Genomes/')
   genomesL.sort()
   shortNameList=[]
   for f in genomesL:
      if re.match('(.*)\.def$',f):
         res=re.match('(.*)\.def$',f)
         shortNameList.append(res.group(1))
   return shortNameList


###################
## USE in n04

## RETURN the chromosome number of a given feature number (using the ENDChromo list)
# (return 1 if the feature belongs to the 1st chromo)
def chromosome(i,liste):
   for j in range(len(liste)):
      if i<=int(liste[j]):
         chromo=j+1
         break
   return chromo

## return the length of the longest chromosome
# liste : liste of the last feature number of each chromosome  
def maxLenghtChrom(liste):
   for i in range(len(liste)):
      if i==0:
         maxi=liste[0]
      else:
         maxi=max(maxi,liste[i]-liste[i-1])
   return maxi


###################
### WRITE THE RECAP FILE
def head(fileName,ancestor,g1,g2,outgroups):
   fo=open(fileName,'w')
   fo.write('Ancestor: '+ancestor+'\n')
   fo.write('G1: '+g1+'\n')
   fo.write('G2: '+g2+'\n')
   fo.write('Outgroups: '+' '.join(outgroups)+'\n\n')
   fo.close()
def macropart(fileName,ancestor,g1,g2,nbBlock,nbPack,nbCycle,maxLenC,nbBlockAP,nbVBlock,NBREAR,nbContig,nbGene1,nbGene2):
   fo=open(fileName,'a')
   fo.write('MACRO PART\n')
   fo.write(str(nbBlock)+'\tMacro Blocks\n')
   fo.write(str(nbPack)+'\tPacks\n')
   fo.write(str(nbCycle)+'\tCycles (and the longest cycle/path has a length of '+str(maxLenC)+')\n')
   fo.write(str(nbBlockAP)+'\tMacro Blocks (after packs definition and cycles validation) whose '+str(nbVBlock)+' virtual ones\n')
   fo.write(str(NBREAR[0])+'\tRea from '+ancestor+' to '+g1+'\n')
   fo.write(str(NBREAR[1])+'\tRea from '+ancestor+' to '+g2+'\n')
   fo.write(str(NBREAR[2])+'\tUnlocalized Rea\n')
   fo.write(str(nbContig)+'\tAncestral Contigs (with '+str(nbGene1)+' genes in '+ancestor+'_'+g1+' and '+
   str(nbGene2)+' genes in '+ancestor+'_'+g2+')\n\n')
   fo.close()
def micropart(fileName,ancestor,g1,g2,nbMiBl1,nbMiBl2,NBREARi,nbChro):
   fo=open(fileName,'a')
   fo.write('MICRO PART\n')
   fo.write(str(nbMiBl1)+'\tinitial Micro Blocks\n')
   fo.write(str(nbMiBl2)+'\tfinal Micro Blocks (after deletion of all duplications)\n')
   fo.write(str(len(NBREARi[0]))+'\tMicro Inversion from '+ancestor+' to '+g1+' (of length: '+', '.join(map(str,NBREARi[0]))+')\n')
   fo.write(str(len(NBREARi[1]))+'\tMicro Inversion from '+ancestor+' to '+g2+' (of length: '+', '.join(map(str,NBREARi[1]))+')\n')
   fo.write('(+ '+str(len(NBREARi[2]))+' arbitrary assigned to G2) '+('(of length: '+', '.join(map(str,NBREARi[2]))+')' if NBREARi[2] else '')+'\n')
   fo.write(str(len(nbChro))+'\tAncestral Contigs\n')
   fo.write(str(sum(nbChro))+'\tAncestral Genes ( '+str(nbChro[0]))
   for ch in nbChro[1:]:
      fo.write(' + '+str(ch))
   fo.write(' )\n')
   fo.close()

